/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.onlinedisplays;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.DimensionArgument;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.onlinedisplays.level.LevelImageStorage;
import org.zeith.onlinedisplays.tiles.TileDisplay;

public class CommandOnlineDisplay {
    private static <T> LiteralArgumentBuilder<CommandSourceStack> tweakDisplayParam(String name, ArgumentType<T> arg, BiFunction<CommandContext<CommandSourceStack>, String, T> getArg, @Nullable Function<TileDisplay, Float> get, BiConsumer<TileDisplay, T> handler) {
        boolean isNumber = arg instanceof FloatArgumentType && get != null;
        RequiredArgumentBuilder pArg = (RequiredArgumentBuilder)Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(Commands.m_82127_((String)"set").then(Commands.m_82129_((String)"value", arg).executes(s -> {
            BlockPos pos;
            ServerLevel dim = DimensionArgument.m_88808_((CommandContext)s, (String)"dimension");
            TileDisplay td = (TileDisplay)((Object)((Object)Cast.cast((Object)dim.m_7702_(pos = BlockPosArgument.m_174395_((CommandContext)s, (String)"pos")), TileDisplay.class)));
            if (td != null) {
                handler.accept(td, getArg.apply(s, "value"));
                for (ServerPlayer player : dim.m_7726_().f_8325_.m_183262_(new ChunkPos(td.m_58899_()), false)) {
                    player.f_8906_.m_9829_((Packet)td.getUpdatePacket());
                }
                return 1;
            }
            return 0;
        })));
        if (isNumber) {
            pArg.then(Commands.m_82127_((String)"plus").then(Commands.m_82129_((String)"value", arg).executes(s -> {
                ServerLevel dim = DimensionArgument.m_88808_((CommandContext)s, (String)"dimension");
                BlockPos pos = BlockPosArgument.m_174395_((CommandContext)s, (String)"pos");
                TileDisplay td = (TileDisplay)((Object)((Object)Cast.cast((Object)dim.m_7702_(pos), TileDisplay.class)));
                Object val = getArg.apply(s, "value");
                if (td != null && val instanceof Float) {
                    Float fv = (Float)val;
                    handler.accept(td, Cast.cast((Object)Float.valueOf(((Float)get.apply(td)).floatValue() + fv.floatValue())));
                    for (ServerPlayer player : dim.m_7726_().f_8325_.m_183262_(new ChunkPos(td.m_58899_()), false)) {
                        player.f_8906_.m_9829_((Packet)td.getUpdatePacket());
                    }
                    return 1;
                }
                return 0;
            })));
            pArg.then(Commands.m_82127_((String)"minus").then(Commands.m_82129_((String)"value", arg).executes(s -> {
                ServerLevel dim = DimensionArgument.m_88808_((CommandContext)s, (String)"dimension");
                BlockPos pos = BlockPosArgument.m_174395_((CommandContext)s, (String)"pos");
                TileDisplay td = (TileDisplay)((Object)((Object)Cast.cast((Object)dim.m_7702_(pos), TileDisplay.class)));
                Object val = getArg.apply(s, "value");
                if (td != null && val instanceof Float) {
                    Float fv = (Float)val;
                    handler.accept(td, Cast.cast((Object)Float.valueOf(((Float)get.apply(td)).floatValue() - fv.floatValue())));
                    for (ServerPlayer player : dim.m_7726_().f_8325_.m_183262_(new ChunkPos(td.m_58899_()), false)) {
                        player.f_8906_.m_9829_((Packet)td.getUpdatePacket());
                    }
                    return 1;
                }
                return 0;
            })));
            pArg.then(Commands.m_82127_((String)"multiply").then(Commands.m_82129_((String)"value", arg).executes(s -> {
                ServerLevel dim = DimensionArgument.m_88808_((CommandContext)s, (String)"dimension");
                BlockPos pos = BlockPosArgument.m_174395_((CommandContext)s, (String)"pos");
                TileDisplay td = (TileDisplay)((Object)((Object)Cast.cast((Object)dim.m_7702_(pos), TileDisplay.class)));
                Object val = getArg.apply(s, "value");
                if (td != null && val instanceof Float) {
                    Float fv = (Float)val;
                    handler.accept(td, Cast.cast((Object)Float.valueOf(((Float)get.apply(td)).floatValue() * fv.floatValue())));
                    for (ServerPlayer player : dim.m_7726_().f_8325_.m_183262_(new ChunkPos(td.m_58899_()), false)) {
                        player.f_8906_.m_9829_((Packet)td.getUpdatePacket());
                    }
                    return 1;
                }
                return 0;
            })));
            pArg.then(Commands.m_82127_((String)"divide").then(Commands.m_82129_((String)"value", arg).executes(s -> {
                Float fv;
                ServerLevel dim = DimensionArgument.m_88808_((CommandContext)s, (String)"dimension");
                BlockPos pos = BlockPosArgument.m_174395_((CommandContext)s, (String)"pos");
                TileDisplay td = (TileDisplay)((Object)((Object)Cast.cast((Object)dim.m_7702_(pos), TileDisplay.class)));
                Object val = getArg.apply(s, "value");
                if (td != null && val instanceof Float && Math.abs((fv = (Float)val).floatValue()) > 1.0E-5f) {
                    handler.accept(td, Cast.cast((Object)Float.valueOf(((Float)get.apply(td)).floatValue() / fv.floatValue())));
                    for (ServerPlayer player : dim.m_7726_().f_8325_.m_183262_(new ChunkPos(td.m_58899_()), false)) {
                        player.f_8906_.m_9829_((Packet)td.getUpdatePacket());
                    }
                    return 1;
                }
                return 0;
            })));
        }
        return (LiteralArgumentBuilder)Commands.m_82127_((String)name).then(Commands.m_82129_((String)"dimension", (ArgumentType)DimensionArgument.m_88805_()).then((ArgumentBuilder)pArg));
    }

    public static LiteralArgumentBuilder<CommandSourceStack> create() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"onlinedisplays").requires(s -> s.m_6761_(2))).then(Commands.m_82127_((String)"preload").then(Commands.m_82129_((String)"url", (ArgumentType)StringArgumentType.string()).then(Commands.m_82129_((String)"cache_for_clients", (ArgumentType)EntityArgument.m_91470_()).executes(s -> {
            String url = StringArgumentType.getString((CommandContext)s, (String)"url");
            UUID[] cacheForClients = (UUID[])EntityArgument.m_91477_((CommandContext)s, (String)"cache_for_clients").stream().map(Player::m_36316_).map(GameProfile::getId).toArray(UUID[]::new);
            MinecraftServer server = ((CommandSourceStack)s.getSource()).m_81377_();
            LevelImageStorage storage = LevelImageStorage.get(server.m_129783_());
            storage.queueDownload(url, cacheForClients);
            return 0;
        }))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"configure").then(CommandOnlineDisplay.tweakDisplayParam("offset_x", FloatArgumentType.floatArg(), FloatArgumentType::getFloat, td -> Float.valueOf(td.matrix.translateX), (td, val) -> {
            td.matrix.translateX = val.floatValue();
        }))).then(CommandOnlineDisplay.tweakDisplayParam("offset_y", FloatArgumentType.floatArg(), FloatArgumentType::getFloat, td -> Float.valueOf(td.matrix.translateY), (td, val) -> {
            td.matrix.translateY = val.floatValue();
        }))).then(CommandOnlineDisplay.tweakDisplayParam("offset_z", FloatArgumentType.floatArg(), FloatArgumentType::getFloat, td -> Float.valueOf(td.matrix.translateZ), (td, val) -> {
            td.matrix.translateZ = val.floatValue();
        }))).then(CommandOnlineDisplay.tweakDisplayParam("rotation_x", FloatArgumentType.floatArg(), FloatArgumentType::getFloat, td -> Float.valueOf(td.matrix.rotateX), (td, val) -> {
            td.matrix.rotateX = val.floatValue();
        }))).then(CommandOnlineDisplay.tweakDisplayParam("rotation_y", FloatArgumentType.floatArg(), FloatArgumentType::getFloat, td -> Float.valueOf(td.matrix.rotateY), (td, val) -> {
            td.matrix.rotateY = val.floatValue();
        }))).then(CommandOnlineDisplay.tweakDisplayParam("rotation_z", FloatArgumentType.floatArg(), FloatArgumentType::getFloat, td -> Float.valueOf(td.matrix.rotateZ), (td, val) -> {
            td.matrix.rotateZ = val.floatValue();
        }))).then(CommandOnlineDisplay.tweakDisplayParam("scale_x", FloatArgumentType.floatArg(), FloatArgumentType::getFloat, td -> Float.valueOf(td.matrix.scaleX), (td, val) -> {
            td.matrix.scaleX = val.floatValue();
        }))).then(CommandOnlineDisplay.tweakDisplayParam("scale_y", FloatArgumentType.floatArg(), FloatArgumentType::getFloat, td -> Float.valueOf(td.matrix.scaleY), (td, val) -> {
            td.matrix.scaleY = val.floatValue();
        }))).then(CommandOnlineDisplay.tweakDisplayParam("emissive", BoolArgumentType.bool(), BoolArgumentType::getBool, null, (td, val) -> td.isEmissive.setBool(val.booleanValue())))).then(CommandOnlineDisplay.tweakDisplayParam("url", StringArgumentType.string(), StringArgumentType::getString, null, TileDisplay::updateURL)));
    }
}

