/*
 * Decompiled with CFR 0.152.
 */
package gisellevonbingen.mmp.common.crafting.conditions;

import com.google.gson.JsonObject;
import gisellevonbingen.mmp.common.MoreMekanismProcessing;
import gisellevonbingen.mmp.common.config.MMPConfigs;
import gisellevonbingen.mmp.common.material.MaterialType;
import java.util.Arrays;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.crafting.conditions.IConditionSerializer;
import org.apache.commons.lang3.StringUtils;

public class ProcessingLevelCondition
implements ICondition {
    private static final ResourceLocation NAME = MoreMekanismProcessing.rl("processing_level");
    private final MaterialType materialType;
    private final int requireLevel;

    public ProcessingLevelCondition(MaterialType materialType, int requireLevel) {
        this.materialType = materialType;
        this.requireLevel = requireLevel;
    }

    public ResourceLocation getID() {
        return NAME;
    }

    public boolean test(ICondition.IContext context) {
        if (this.materialType == null) {
            return true;
        }
        int level = (Integer)MMPConfigs.COMMON.processingLevels.get((Object)this.materialType).get();
        return level >= this.requireLevel;
    }

    public String toString() {
        return "processing_level(\"" + this.materialType.getBaseName() + "\" require " + this.requireLevel + ")";
    }

    public MaterialType getMaterialType() {
        return this.materialType;
    }

    public int getRequireLevel() {
        return this.requireLevel;
    }

    public static class Serializer
    implements IConditionSerializer<ProcessingLevelCondition> {
        public static final Serializer INSTANCE = new Serializer();

        public void write(JsonObject json, ProcessingLevelCondition value) {
            json.addProperty("materialType", value.materialType.getBaseName());
            json.addProperty("requireLevel", (Number)value.requireLevel);
        }

        public ProcessingLevelCondition read(JsonObject json) {
            String asString = GsonHelper.m_13906_((JsonObject)json, (String)"materialType");
            MaterialType materialType = Arrays.stream(MaterialType.values()).filter(t -> StringUtils.equals((CharSequence)t.getBaseName(), (CharSequence)asString)).findFirst().get();
            return new ProcessingLevelCondition(materialType, GsonHelper.m_13927_((JsonObject)json, (String)"requireLevel"));
        }

        public ResourceLocation getID() {
            return NAME;
        }
    }
}

