/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.text;

import java.util.ArrayList;
import mekanism.api.text.APILang;
import mekanism.api.text.EnumColor;
import mekanism.api.text.IHasTextComponent;
import mekanism.api.text.IHasTranslationKey;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.HoverEvent;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class TextComponentUtil {
    private TextComponentUtil() {
    }

    public static MutableComponent color(MutableComponent component, int color) {
        return component.m_6270_(component.m_7383_().m_131148_(TextColor.m_131266_((int)color)));
    }

    public static MutableComponent build(Object ... components) {
        MutableComponent result = null;
        Style cachedStyle = Style.f_131099_;
        for (Object component : components) {
            if (component == null) continue;
            MutableComponent current = null;
            if (component instanceof IHasTextComponent) {
                IHasTextComponent hasTextComponent = (IHasTextComponent)component;
                current = hasTextComponent.getTextComponent().m_6881_();
            } else if (component instanceof IHasTranslationKey) {
                IHasTranslationKey hasTranslationKey = (IHasTranslationKey)component;
                current = TextComponentUtil.translate(hasTranslationKey.getTranslationKey(), new Object[0]);
            } else if (component instanceof EnumColor) {
                EnumColor color = (EnumColor)component;
                cachedStyle = cachedStyle.m_131148_(color.getColor());
            } else if (component instanceof TextColor) {
                TextColor color = (TextColor)component;
                cachedStyle = cachedStyle.m_131148_(color);
            } else if (component instanceof Component) {
                Component c = (Component)component;
                current = c.m_6881_();
            } else if (component instanceof ChatFormatting) {
                ChatFormatting formatting = (ChatFormatting)component;
                cachedStyle = cachedStyle.m_131157_(formatting);
            } else if (component instanceof ClickEvent) {
                ClickEvent event = (ClickEvent)component;
                cachedStyle = cachedStyle.m_131142_(event);
            } else if (component instanceof HoverEvent) {
                HoverEvent event = (HoverEvent)component;
                cachedStyle = cachedStyle.m_131144_(event);
            } else if (component instanceof Block) {
                Block block = (Block)component;
                current = TextComponentUtil.translate(block.m_7705_(), new Object[0]);
            } else if (component instanceof Item) {
                Item item = (Item)component;
                current = TextComponentUtil.translate(item.m_5524_(), new Object[0]);
            } else if (component instanceof ItemStack) {
                ItemStack stack = (ItemStack)component;
                current = stack.m_41786_().m_6881_();
            } else if (component instanceof FluidStack) {
                FluidStack stack = (FluidStack)component;
                current = stack.getDisplayName().m_6881_();
            } else if (component instanceof Fluid) {
                Fluid fluid = (Fluid)component;
                current = TextComponentUtil.translate(fluid.getFluidType().getDescriptionId(), new Object[0]);
            } else if (component instanceof Direction) {
                Direction direction = (Direction)component;
                current = TextComponentUtil.getTranslatedDirection(direction);
            } else if (component instanceof Boolean) {
                Boolean bool = (Boolean)component;
                current = TextComponentUtil.getTranslatedBoolean(bool);
            } else {
                current = TextComponentUtil.getString(component.toString());
            }
            if (current == null) continue;
            if (!cachedStyle.m_131179_()) {
                current.m_6270_(cachedStyle);
                cachedStyle = Style.f_131099_;
            }
            if (result == null) {
                result = current;
                continue;
            }
            result.m_7220_((Component)current);
        }
        return result;
    }

    private static MutableComponent getTranslatedBoolean(boolean bool) {
        return (bool ? APILang.TRUE_LOWER : APILang.FALSE_LOWER).translate(new Object[0]);
    }

    private static MutableComponent getTranslatedDirection(Direction direction) {
        return (switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.DOWN -> APILang.DOWN;
            case Direction.UP -> APILang.UP;
            case Direction.NORTH -> APILang.NORTH;
            case Direction.SOUTH -> APILang.SOUTH;
            case Direction.WEST -> APILang.WEST;
            case Direction.EAST -> APILang.EAST;
        }).translate(new Object[0]);
    }

    public static MutableComponent getString(String component) {
        return Component.m_237113_((String)TextComponentUtil.cleanString(component));
    }

    private static String cleanString(String component) {
        return component.replace("\u00a0", " ").replace("\u202f", " ");
    }

    public static MutableComponent translate(String key, Object ... args) {
        return Component.m_237110_((String)key, (Object[])args);
    }

    public static MutableComponent smartTranslate(String key, Object ... components) {
        if (components.length == 0) {
            return TextComponentUtil.translate(key, new Object[0]);
        }
        ArrayList<Object> args = new ArrayList<Object>();
        Style cachedStyle = Style.f_131099_;
        for (Object component : components) {
            if (component == null) {
                args.add(null);
                cachedStyle = Style.f_131099_;
                continue;
            }
            MutableComponent current = null;
            if (component instanceof IHasTextComponent) {
                IHasTextComponent hasTextComponent = (IHasTextComponent)component;
                current = hasTextComponent.getTextComponent().m_6881_();
            } else if (component instanceof IHasTranslationKey) {
                IHasTranslationKey hasTranslationKey = (IHasTranslationKey)component;
                current = TextComponentUtil.translate(hasTranslationKey.getTranslationKey(), new Object[0]);
            } else if (component instanceof Block) {
                Block block = (Block)component;
                current = TextComponentUtil.translate(block.m_7705_(), new Object[0]);
            } else if (component instanceof Item) {
                Item item = (Item)component;
                current = TextComponentUtil.translate(item.m_5524_(), new Object[0]);
            } else if (component instanceof ItemStack) {
                ItemStack stack = (ItemStack)component;
                current = stack.m_41786_().m_6881_();
            } else if (component instanceof FluidStack) {
                FluidStack stack = (FluidStack)component;
                current = stack.getDisplayName().m_6881_();
            } else if (component instanceof Fluid) {
                Fluid fluid = (Fluid)component;
                current = TextComponentUtil.translate(fluid.getFluidType().getDescriptionId(), new Object[0]);
            } else if (component instanceof Direction) {
                Direction direction = (Direction)component;
                current = TextComponentUtil.getTranslatedDirection(direction);
            } else if (component instanceof Boolean) {
                Boolean bool = (Boolean)component;
                current = TextComponentUtil.getTranslatedBoolean(bool);
            } else {
                ChatFormatting formatting;
                if (component instanceof EnumColor) {
                    EnumColor color = (EnumColor)component;
                    if (cachedStyle.m_131135_() == null) {
                        cachedStyle = cachedStyle.m_131148_(color.getColor());
                        continue;
                    }
                }
                if (component instanceof TextColor) {
                    TextColor color = (TextColor)component;
                    if (cachedStyle.m_131135_() == null) {
                        cachedStyle = cachedStyle.m_131148_(color);
                        continue;
                    }
                }
                if (component instanceof ChatFormatting && !TextComponentUtil.hasStyleType(cachedStyle, formatting = (ChatFormatting)component)) {
                    cachedStyle = cachedStyle.m_131157_(formatting);
                    continue;
                }
                if (component instanceof ClickEvent) {
                    ClickEvent event = (ClickEvent)component;
                    if (cachedStyle.m_131182_() == null) {
                        cachedStyle = cachedStyle.m_131142_(event);
                        continue;
                    }
                }
                if (component instanceof HoverEvent) {
                    HoverEvent event = (HoverEvent)component;
                    if (cachedStyle.m_131186_() == null) {
                        cachedStyle = cachedStyle.m_131144_(event);
                        continue;
                    }
                }
                if (!cachedStyle.m_131179_()) {
                    current = component instanceof Component ? ((Component)component).m_6881_() : (component instanceof EnumColor ? ((EnumColor)component).getName() : TextComponentUtil.getString(component.toString()));
                } else if (component instanceof String) {
                    component = TextComponentUtil.cleanString((String)component);
                }
            }
            if (!cachedStyle.m_131179_()) {
                if (current == null) {
                    args.add(component);
                } else {
                    args.add(current.m_6270_(cachedStyle));
                }
                cachedStyle = Style.f_131099_;
                continue;
            }
            if (current == null) {
                args.add(component);
                continue;
            }
            args.add(current);
        }
        if (!cachedStyle.m_131179_()) {
            Object lastComponent = components[components.length - 1];
            if (lastComponent instanceof EnumColor) {
                EnumColor color = (EnumColor)lastComponent;
                args.add(color.getName());
            } else {
                args.add(lastComponent);
            }
        }
        return TextComponentUtil.translate(key, args.toArray());
    }

    private static boolean hasStyleType(Style current, ChatFormatting formatting) {
        return switch (formatting) {
            case ChatFormatting.OBFUSCATED -> current.m_131176_();
            case ChatFormatting.BOLD -> current.m_131154_();
            case ChatFormatting.STRIKETHROUGH -> current.m_131168_();
            case ChatFormatting.UNDERLINE -> current.m_131171_();
            case ChatFormatting.ITALIC -> current.m_131161_();
            case ChatFormatting.RESET -> current.m_131179_();
            default -> current.m_131135_() != null;
        };
    }
}

