/*
 * Decompiled with CFR 0.152.
 */
package de.geheimagentnr1.manyideas_core.elements.commands.givedb;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import de.geheimagentnr1.manyideas_core.elements.blocks.template_blocks.dyed.DyeBlockItem;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;

class DyeItemParser {
    @NotNull
    private static final DynamicCommandExceptionType ITEM_BAD_ID = new DynamicCommandExceptionType(function -> Component.m_237110_((String)"argument.item.id.invalid", (Object[])new Object[]{function}));
    @NotNull
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> DEFAULT_SUGGESTIONS_BUILDER = SuggestionsBuilder::buildFuture;
    @NotNull
    private static final Set<ResourceLocation> KEY_SET = DyeItemParser.getDyeItemKeySet();
    @NotNull
    private final StringReader reader;
    private Item item;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestionsBuilder = DEFAULT_SUGGESTIONS_BUILDER;

    DyeItemParser(@NotNull StringReader _reader) {
        this.reader = _reader;
    }

    @NotNull
    private static Set<ResourceLocation> getDyeItemKeySet() {
        TreeSet<ResourceLocation> keySet = new TreeSet<ResourceLocation>();
        for (Item item : BuiltInRegistries.f_257033_) {
            if (!(item instanceof DyeBlockItem)) continue;
            keySet.add(BuiltInRegistries.f_257033_.m_7981_((Object)item));
        }
        return keySet;
    }

    public Item getItem() {
        return this.item;
    }

    private void readItem() throws CommandSyntaxException {
        int cursor = this.reader.getCursor();
        ResourceLocation resourceLocation = ResourceLocation.m_135818_((StringReader)this.reader);
        this.item = this.getItemForRegistry(resourceLocation).orElseThrow(() -> {
            this.reader.setCursor(cursor);
            return ITEM_BAD_ID.createWithContext((ImmutableStringReader)this.reader, (Object)resourceLocation.toString());
        });
    }

    @NotNull
    private Optional<Item> getItemForRegistry(@NotNull ResourceLocation resourceLocation) {
        Optional optional = BuiltInRegistries.f_257033_.m_6612_(resourceLocation);
        if (optional.isPresent()) {
            if (optional.get() instanceof DyeBlockItem) {
                return optional;
            }
            return Optional.empty();
        }
        return optional;
    }

    @NotNull
    DyeItemParser parse() throws CommandSyntaxException {
        this.suggestionsBuilder = this::suggestTagOrItem;
        this.readItem();
        this.suggestionsBuilder = this::suggestItem;
        return this;
    }

    @NotNull
    private CompletableFuture<Suggestions> suggestItem(@NotNull SuggestionsBuilder builder) {
        return builder.buildFuture();
    }

    @NotNull
    private CompletableFuture<Suggestions> suggestTagOrItem(@NotNull SuggestionsBuilder builder) {
        return SharedSuggestionProvider.m_82926_(KEY_SET, (SuggestionsBuilder)builder);
    }

    @NotNull
    CompletableFuture<Suggestions> fillSuggestions(@NotNull SuggestionsBuilder builder) {
        return this.suggestionsBuilder.apply(builder.createOffset(this.reader.getCursor()));
    }
}

