/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.registration.adapter;

import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.FenceBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.PressurePlateBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.StandingSignBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.WallBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import net.minecraftforge.fluids.ForgeFlowingFluid;
import net.minecraftforge.registries.IForgeRegistry;
import slimeknights.mantle.block.MantleCeilingHangingSignBlock;
import slimeknights.mantle.block.MantleStandingSignBlock;
import slimeknights.mantle.block.MantleWallHangingSignBlock;
import slimeknights.mantle.block.MantleWallSignBlock;
import slimeknights.mantle.block.StrippableLogBlock;
import slimeknights.mantle.block.entity.MantleHangingSignBlockEntity;
import slimeknights.mantle.block.entity.MantleSignBlockEntity;
import slimeknights.mantle.registration.RegistrationHelper;
import slimeknights.mantle.registration.adapter.EnumRegistryAdapter;
import slimeknights.mantle.registration.object.BuildingBlockObject;
import slimeknights.mantle.registration.object.FenceBuildingBlockObject;
import slimeknights.mantle.registration.object.WallBuildingBlockObject;
import slimeknights.mantle.registration.object.WoodBlockObject;
import slimeknights.mantle.util.RegistryHelper;

public class BlockRegistryAdapter
extends EnumRegistryAdapter<Block> {
    public BlockRegistryAdapter(IForgeRegistry<Block> registry) {
        super(registry);
    }

    public BlockRegistryAdapter(IForgeRegistry<Block> registry, String modid) {
        super(registry, modid);
    }

    public <T extends Block> T registerOverride(Function<BlockBehaviour.Properties, T> constructor, Block base) {
        return (T)this.register((Block)constructor.apply(BlockBehaviour.Properties.m_60926_((BlockBehaviour)base)), base);
    }

    public BuildingBlockObject registerBuilding(Block block, String name) {
        return new BuildingBlockObject(this.register(block, name), (Block)this.register(new SlabBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block)), name + "_slab"), (Block)this.register(new StairBlock(() -> ((Block)block).m_49966_(), BlockBehaviour.Properties.m_60926_((BlockBehaviour)block)), name + "_stairs"));
    }

    public WallBuildingBlockObject registerWallBuilding(Block block, String name) {
        return new WallBuildingBlockObject(this.registerBuilding(block, name), (Block)this.register(new WallBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block)), name + "_wall"));
    }

    public FenceBuildingBlockObject registerFenceBuilding(Block block, String name) {
        return new FenceBuildingBlockObject(this.registerBuilding(block, name), (Block)this.register(new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)block)), name + "_fence"));
    }

    public WoodBlockObject registerWood(String name, Function<WoodBlockObject.WoodVariant, BlockBehaviour.Properties> behaviorCreator) {
        BlockSetType setType = new BlockSetType(this.resourceName(name));
        WoodType woodType = new WoodType(this.resourceName(name), setType);
        BlockSetType.m_272115_((BlockSetType)setType);
        WoodType.m_61844_((WoodType)woodType);
        RegistrationHelper.registerWoodType(woodType);
        BlockBehaviour.Properties planksProps = behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_280658_(NoteBlockInstrument.BASS).m_60913_(2.0f, 3.0f);
        BuildingBlockObject planks = this.registerBuilding(new Block(planksProps), name + "_planks");
        FenceBlock fence = this.register(new FenceBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)((BlockBehaviour)planks.get())).m_280606_()), name + "_fence");
        Supplier<RotatedPillarBlock> stripped = () -> new RotatedPillarBlock(((BlockBehaviour.Properties)behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS)).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f));
        RotatedPillarBlock strippedLog = this.register(stripped.get(), "stripped_" + name + "_log");
        RotatedPillarBlock strippedWood = this.register(stripped.get(), "stripped_" + name + "_wood");
        RotatedPillarBlock log = this.register(new StrippableLogBlock(RegistryHelper.getHolder(BuiltInRegistries.f_256975_, strippedLog), behaviorCreator.apply(WoodBlockObject.WoodVariant.LOG).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f)), name + "_log");
        RotatedPillarBlock wood = this.register(new StrippableLogBlock(RegistryHelper.getHolder(BuiltInRegistries.f_256975_, strippedWood), behaviorCreator.apply(WoodBlockObject.WoodVariant.WOOD).m_280658_(NoteBlockInstrument.BASS).m_60978_(2.0f)), name + "_wood");
        DoorBlock door = this.register(new DoorBlock(behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_278166_(PushReaction.DESTROY), setType), name + "_door");
        TrapDoorBlock trapdoor = this.register(new TrapDoorBlock(behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_280658_(NoteBlockInstrument.BASS).m_60978_(3.0f).m_60955_().m_60922_(Blocks::m_50778_), setType), name + "_trapdoor");
        FenceGateBlock fenceGate = this.register(new FenceGateBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)fence), woodType), name + "_fence_gate");
        BlockBehaviour.Properties redstoneProps = behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_278166_(PushReaction.DESTROY).m_60978_(0.5f);
        PressurePlateBlock pressurePlate = this.register(new PressurePlateBlock(PressurePlateBlock.Sensitivity.EVERYTHING, redstoneProps, setType), name + "_pressure_plate");
        ButtonBlock button = this.register(new ButtonBlock(redstoneProps, setType, 30, true), name + "_button");
        StandingSignBlock standingSign = this.register(new MantleStandingSignBlock(behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f), woodType), name + "_sign");
        WallSignBlock wallSign = this.register(new MantleWallSignBlock(behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_60916_((Block)standingSign), woodType), name + "_wall_sign");
        MantleCeilingHangingSignBlock hangingSign = this.register(new MantleCeilingHangingSignBlock(behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f), woodType), name + "_hanging_sign");
        MantleWallHangingSignBlock wallHangingSign = this.register(new MantleWallHangingSignBlock(behaviorCreator.apply(WoodBlockObject.WoodVariant.PLANKS).m_280606_().m_280658_(NoteBlockInstrument.BASS).m_60910_().m_60978_(1.0f).m_60916_((Block)hangingSign), woodType), name + "_wall_hanging_sign");
        MantleSignBlockEntity.registerSignBlock(() -> standingSign);
        MantleSignBlockEntity.registerSignBlock(() -> wallSign);
        MantleHangingSignBlockEntity.registerSignBlock(() -> hangingSign);
        MantleHangingSignBlockEntity.registerSignBlock(() -> wallHangingSign);
        return new WoodBlockObject(this.getResource(name), woodType, planks, (Block)log, (Block)strippedLog, (Block)wood, (Block)strippedWood, (Block)fence, (Block)fenceGate, (Block)door, (Block)trapdoor, (Block)pressurePlate, (Block)button, (Block)standingSign, (Block)wallSign, (Block)hangingSign, (Block)wallHangingSign);
    }

    public LiquidBlock registerFluidBlock(Supplier<? extends ForgeFlowingFluid> fluid, MapColor color, int lightLevel, String name) {
        return this.register(new LiquidBlock(fluid, BlockBehaviour.Properties.m_284310_().m_284180_(color).m_60910_().m_60978_(100.0f).m_222994_().m_60953_(state -> lightLevel)), name + "_fluid");
    }
}

