/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.data.loadable.field;

import com.google.gson.JsonObject;
import net.minecraft.network.FriendlyByteBuf;
import slimeknights.mantle.Mantle;
import slimeknights.mantle.data.loadable.field.ContextKey;
import slimeknights.mantle.data.loadable.field.LoadableField;
import slimeknights.mantle.util.typed.TypedMap;

public record LegacyField<T, P>(LoadableField<T, P> base, String fallback) implements LoadableField<T, P>
{
    public LegacyField {
        if (base.key().equals(fallback)) {
            throw new IllegalArgumentException("Cannot create a legacy key with a fallback matching the base key '" + base.key() + "'");
        }
    }

    @Override
    public String key() {
        return this.base.key();
    }

    @Override
    public T get(JsonObject json, String key, TypedMap context) {
        if (json.has(this.fallback) && !json.has(key)) {
            Object debug = context.get(ContextKey.DEBUG);
            debug = debug != null ? " while parsing " + (String)debug : "";
            Mantle.logger.warn("Using deprecated JSON key '{}'{}, switch to current name of '{}'", (Object)this.fallback, debug, (Object)key);
            return this.base.get(json, this.fallback, context);
        }
        return this.base.get(json, key, context);
    }

    @Override
    public void serialize(P parent, JsonObject json) {
        this.base.serialize(parent, json);
    }

    @Override
    public T decode(FriendlyByteBuf buffer, TypedMap context) {
        return this.base.decode(buffer, context);
    }

    @Override
    public void encode(FriendlyByteBuf buffer, P parent) {
        this.base.encode(buffer, parent);
    }
}

