/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.render;

import java.util.List;
import java.util.function.Function;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.block.Block;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import slimeknights.mantle.client.model.util.ModelHelper;
import slimeknights.mantle.data.datamap.RegistryDataMapLoader;
import slimeknights.mantle.data.loadable.Loadable;
import slimeknights.mantle.data.loadable.Loadables;
import slimeknights.mantle.data.loadable.common.DisplayContextLoadable;
import slimeknights.mantle.data.loadable.common.Vector3fLoadable;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;

public class RenderItem {
    private static final RenderItem EMPTY = new RenderItem(new Vector3f(0.0f, 0.0f, 0.0f), 0.0f, 0, 0, ItemDisplayContext.NONE);
    public static final RecordLoadable<RenderItem> LOADABLE = RecordLoadable.create(Vector3fLoadable.INSTANCE.defaultField("center", RenderItem.EMPTY.center, RenderItem::getCenter), FloatLoadable.FROM_ZERO.requiredField("size", RenderItem::getSize), Loadables.ROTATION.defaultField("x", 0, RenderItem::getX), Loadables.ROTATION.defaultField("y", 0, RenderItem::getY), DisplayContextLoadable.INSTANCE.defaultField("transform", ItemDisplayContext.NONE, RenderItem::getTransform), RenderItem::new).validate((value, error) -> {
        if (value.size == 0.0f) {
            return EMPTY;
        }
        return value;
    });
    private static final Loadable<List<RenderItem>> LIST_LOADABLE = LOADABLE.list(-1);
    public static final RegistryDataMapLoader<Block, List<RenderItem>> REGISTRY = new RegistryDataMapLoader("Block entity items", "mantle/model/render_items", BuiltInRegistries.f_256975_, RecordLoadable.create(LIST_LOADABLE.requiredField("items", Function.identity()), Function.identity()));
    private final Vector3f center;
    private final float size;
    private final int x;
    private final int y;
    private final ItemDisplayContext transform;
    private Vector3f centerScaled;
    private Float sizeScaled;

    public Vector3f getCenterScaled() {
        if (this.centerScaled == null) {
            this.centerScaled = new Vector3f((Vector3fc)this.center);
            this.centerScaled.mul(0.0625f);
        }
        return this.centerScaled;
    }

    public float getSizeScaled() {
        if (this.sizeScaled == null) {
            this.sizeScaled = Float.valueOf(this.size / 16.0f);
        }
        return this.sizeScaled.floatValue();
    }

    public boolean isHidden() {
        return this.size == 0.0f;
    }

    public static Builder builder() {
        return new Builder();
    }

    protected RenderItem(Vector3f center, float size, int x, int y, ItemDisplayContext transform) {
        this.center = center;
        this.size = size;
        this.x = x;
        this.y = y;
        this.transform = transform;
    }

    public Vector3f getCenter() {
        return this.center;
    }

    public float getSize() {
        return this.size;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public ItemDisplayContext getTransform() {
        return this.transform;
    }

    public static class Builder {
        private Vector3f center = new Vector3f(8.0f, 8.0f, 8.0f);
        private float size = 16.0f;
        private int x = 0;
        private int y = 0;
        private ItemDisplayContext transform = ItemDisplayContext.NONE;

        public Builder center(float x, float y, float z) {
            this.center = new Vector3f(x, y, z);
            return this;
        }

        public Builder x(int x) {
            if (!ModelHelper.checkRotation(x)) {
                throw new IllegalArgumentException("Invalid rotation value " + x + ", must be 0/90/180/270");
            }
            this.x = x;
            return this;
        }

        public Builder y(int y) {
            if (!ModelHelper.checkRotation(y)) {
                throw new IllegalArgumentException("Invalid rotation value " + y + ", must be 0/90/180/270");
            }
            this.y = y;
            return this;
        }

        public RenderItem build() {
            return new RenderItem(this.center, this.size, this.x, this.y, this.transform);
        }

        public Builder size(float size) {
            this.size = size;
            return this;
        }

        public Builder transform(ItemDisplayContext transform) {
            this.transform = transform;
            return this;
        }
    }
}

