/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.malilib.util;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;

public class PositionUtils {
    public static final Direction[] ALL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] HORIZONTAL_DIRECTIONS = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.WEST, Direction.EAST};
    public static final Direction[] VERTICAL_DIRECTIONS = new Direction[]{Direction.DOWN, Direction.UP};

    public static Vec3 modifyValue(CoordinateType type, Vec3 valueIn, double amount) {
        switch (type) {
            case X: {
                return new Vec3(valueIn.f_82479_ + amount, valueIn.f_82480_, valueIn.f_82481_);
            }
            case Y: {
                return new Vec3(valueIn.f_82479_, valueIn.f_82480_ + amount, valueIn.f_82481_);
            }
            case Z: {
                return new Vec3(valueIn.f_82479_, valueIn.f_82480_, valueIn.f_82481_ + amount);
            }
        }
        return valueIn;
    }

    public static BlockPos modifyValue(CoordinateType type, BlockPos valueIn, int amount) {
        switch (type) {
            case X: {
                return BlockPos.m_274561_((double)(valueIn.m_123341_() + amount), (double)valueIn.m_123342_(), (double)valueIn.m_123343_());
            }
            case Y: {
                return BlockPos.m_274561_((double)valueIn.m_123341_(), (double)(valueIn.m_123342_() + amount), (double)valueIn.m_123343_());
            }
            case Z: {
                return BlockPos.m_274561_((double)valueIn.m_123341_(), (double)valueIn.m_123342_(), (double)(valueIn.m_123343_() + amount));
            }
        }
        return valueIn;
    }

    public static Vec3 setValue(CoordinateType type, Vec3 valueIn, double newValue) {
        switch (type) {
            case X: {
                return new Vec3(newValue, valueIn.f_82480_, valueIn.f_82481_);
            }
            case Y: {
                return new Vec3(valueIn.f_82479_, newValue, valueIn.f_82481_);
            }
            case Z: {
                return new Vec3(valueIn.f_82479_, valueIn.f_82480_, newValue);
            }
        }
        return valueIn;
    }

    public static BlockPos setValue(CoordinateType type, BlockPos valueIn, int newValue) {
        switch (type) {
            case X: {
                return BlockPos.m_274561_((double)newValue, (double)valueIn.m_123342_(), (double)valueIn.m_123343_());
            }
            case Y: {
                return BlockPos.m_274561_((double)valueIn.m_123341_(), (double)newValue, (double)valueIn.m_123343_());
            }
            case Z: {
                return BlockPos.m_274561_((double)valueIn.m_123341_(), (double)valueIn.m_123342_(), (double)newValue);
            }
        }
        return valueIn;
    }

    public static BlockPos getEntityBlockPos(Entity entity) {
        return BlockPos.m_274561_((double)Math.floor(entity.m_20185_()), (double)Math.floor(entity.m_20186_()), (double)Math.floor(entity.m_20189_()));
    }

    public static Direction getClosestLookingDirection(Entity entity) {
        return PositionUtils.getClosestLookingDirection(entity, 60.0f);
    }

    public static Direction getClosestLookingDirection(Entity entity, float verticalThreshold) {
        if (entity.m_146909_() >= verticalThreshold) {
            return Direction.DOWN;
        }
        if (entity.m_146908_() <= -verticalThreshold) {
            return Direction.UP;
        }
        return entity.m_6350_();
    }

    public static BlockPos getPositionInfrontOfEntity(Entity entity) {
        return PositionUtils.getPositionInfrontOfEntity(entity, 60.0f);
    }

    public static BlockPos getPositionInfrontOfEntity(Entity entity, float verticalThreshold) {
        double x = entity.m_20185_();
        double y = entity.m_20186_();
        double z = entity.m_20189_();
        double w = entity.m_20205_();
        BlockPos pos = BlockPos.m_274561_((double)x, (double)y, (double)z);
        if (entity.m_146909_() >= verticalThreshold) {
            return pos.m_6625_(1);
        }
        if (entity.m_146909_() <= -verticalThreshold) {
            return BlockPos.m_274561_((double)x, (double)Math.ceil(entity.m_20191_().f_82292_), (double)z);
        }
        y = Math.floor(y + (double)entity.m_20192_());
        switch (entity.m_6350_()) {
            case EAST: {
                return BlockPos.m_274561_((double)((int)Math.ceil(x + w / 2.0)), (double)((int)y), (double)((int)Math.floor(z)));
            }
            case WEST: {
                return BlockPos.m_274561_((double)((int)Math.floor(x - w / 2.0) - 1), (double)((int)y), (double)((int)Math.floor(z)));
            }
            case SOUTH: {
                return BlockPos.m_274561_((double)((int)Math.floor(x)), (double)((int)y), (double)((int)Math.ceil(z + w / 2.0)));
            }
            case NORTH: {
                return BlockPos.m_274561_((double)((int)Math.floor(x)), (double)((int)y), (double)((int)Math.floor(z - w / 2.0) - 1));
            }
        }
        return pos;
    }

    public static Vec3 getHitVecCenter(BlockPos basePos, Direction facing) {
        int x = basePos.m_123341_();
        int y = basePos.m_123342_();
        int z = basePos.m_123343_();
        switch (facing) {
            case UP: {
                return new Vec3((double)x + 0.5, (double)(y + 1), (double)z + 0.5);
            }
            case DOWN: {
                return new Vec3((double)x + 0.5, (double)y, (double)z + 0.5);
            }
            case NORTH: {
                return new Vec3((double)x + 0.5, (double)y + 0.5, (double)z);
            }
            case SOUTH: {
                return new Vec3((double)x + 0.5, (double)y + 0.5, (double)(z + 1));
            }
            case WEST: {
                return new Vec3((double)x, (double)y + 0.5, (double)z);
            }
            case EAST: {
                return new Vec3((double)(x + 1), (double)y + 0.5, (double)(z + 1));
            }
        }
        return new Vec3((double)x, (double)y, (double)z);
    }

    public static HitPart getHitPart(Direction originalSide, Direction playerFacingH, BlockPos pos, Vec3 hitVec) {
        Vec3 positions = PositionUtils.getHitPartPositions(originalSide, playerFacingH, pos, hitVec);
        double posH = positions.f_82479_;
        double posV = positions.f_82480_;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (offH > offV) {
                return posH < 0.5 ? HitPart.LEFT : HitPart.RIGHT;
            }
            return posV < 0.5 ? HitPart.BOTTOM : HitPart.TOP;
        }
        return HitPart.CENTER;
    }

    private static Vec3 getHitPartPositions(Direction originalSide, Direction playerFacingH, BlockPos pos, Vec3 hitVec) {
        double x = hitVec.f_82479_ - (double)pos.m_123341_();
        double y = hitVec.f_82480_ - (double)pos.m_123342_();
        double z = hitVec.f_82481_ - (double)pos.m_123343_();
        double posH = 0.0;
        double posV = 0.0;
        switch (originalSide) {
            case UP: 
            case DOWN: {
                switch (playerFacingH) {
                    case NORTH: {
                        posH = x;
                        posV = 1.0 - z;
                        break;
                    }
                    case SOUTH: {
                        posH = 1.0 - x;
                        posV = z;
                        break;
                    }
                    case WEST: {
                        posH = 1.0 - z;
                        posV = 1.0 - x;
                        break;
                    }
                    case EAST: {
                        posH = z;
                        posV = x;
                        break;
                    }
                }
                if (originalSide != Direction.DOWN) break;
                posV = 1.0 - posV;
                break;
            }
            case SOUTH: 
            case NORTH: {
                posH = originalSide.m_122421_() == Direction.AxisDirection.POSITIVE ? x : 1.0 - x;
                posV = y;
                break;
            }
            case EAST: 
            case WEST: {
                posH = originalSide.m_122421_() == Direction.AxisDirection.NEGATIVE ? z : 1.0 - z;
                posV = y;
            }
        }
        return new Vec3(posH, posV, 0.0);
    }

    public static Direction getTargetedDirection(Direction side, Direction playerFacingH, BlockPos pos, Vec3 hitVec) {
        Vec3 positions = PositionUtils.getHitPartPositions(side, playerFacingH, pos, hitVec);
        double posH = positions.f_82479_;
        double posV = positions.f_82480_;
        double offH = Math.abs(posH - 0.5);
        double offV = Math.abs(posV - 0.5);
        if (offH > 0.25 || offV > 0.25) {
            if (side.m_122434_() == Direction.Axis.Y) {
                if (offH > offV) {
                    return posH < 0.5 ? playerFacingH.m_122428_() : playerFacingH.m_122427_();
                }
                if (side == Direction.DOWN) {
                    return posV > 0.5 ? playerFacingH.m_122424_() : playerFacingH;
                }
                return posV < 0.5 ? playerFacingH.m_122424_() : playerFacingH;
            }
            if (offH > offV) {
                return posH < 0.5 ? side.m_122427_() : side.m_122428_();
            }
            return posV < 0.5 ? Direction.DOWN : Direction.UP;
        }
        return side;
    }

    public static enum CoordinateType {
        X,
        Y,
        Z;

    }

    public static enum HitPart {
        CENTER,
        LEFT,
        RIGHT,
        BOTTOM,
        TOP;

    }
}

