/*
 * Decompiled with CFR 0.152.
 */
package giselle.jei_mekanism_multiblocks.client.jei.category;

import giselle.jei_mekanism_multiblocks.client.gui.CheckBoxWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWidget;
import giselle.jei_mekanism_multiblocks.client.gui.IntSliderWithButtons;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockCategory;
import giselle.jei_mekanism_multiblocks.client.jei.MultiblockWidget;
import giselle.jei_mekanism_multiblocks.client.jei.ResultWidget;
import giselle.jei_mekanism_multiblocks.client.jei.category.ICostConsumer;
import giselle.jei_mekanism_multiblocks.common.util.VolumeTextHelper;
import java.util.function.Consumer;
import mekanism.common.Mekanism;
import mekanism.common.MekanismLang;
import mekanism.common.config.MekanismConfig;
import mekanism.common.registries.MekanismBlocks;
import mezz.jei.api.helpers.IGuiHelper;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class DynamicTankCategory
extends MultiblockCategory<DynamicTankWidget> {
    public DynamicTankCategory(IGuiHelper helper) {
        super(helper, Mekanism.rl((String)"dynamic_tank"), DynamicTankWidget.class, (Component)MekanismLang.DYNAMIC_TANK.translate(new Object[0]), MekanismBlocks.DYNAMIC_VALVE.getItemStack());
    }

    @Override
    protected void getRecipeCatalystItemStacks(Consumer<ItemStack> consumer) {
        super.getRecipeCatalystItemStacks(consumer);
        consumer.accept(MekanismBlocks.DYNAMIC_TANK.getItemStack());
        consumer.accept(MekanismBlocks.DYNAMIC_VALVE.getItemStack());
        consumer.accept(MekanismBlocks.STRUCTURAL_GLASS.getItemStack());
    }

    public static class DynamicTankWidget
    extends MultiblockWidget {
        protected CheckBoxWidget useStructuralGlassCheckBox;
        protected IntSliderWithButtons valvesWidget;

        @Override
        protected void collectOtherConfigs(Consumer<AbstractWidget> consumer) {
            super.collectOtherConfigs(consumer);
            this.useStructuralGlassCheckBox = new CheckBoxWidget(0, 0, 0, 0, (Component)Component.m_237110_((String)"text.jei_mekanism_multiblocks.specs.use_things", (Object[])new Object[]{MekanismBlocks.STRUCTURAL_GLASS.getItemStack().m_41786_()}), true);
            consumer.accept((AbstractWidget)this.useStructuralGlassCheckBox);
            this.useStructuralGlassCheckBox.addSelectedChangedHandler(this::onUseStructuralGlassChanged);
            this.valvesWidget = new IntSliderWithButtons(0, 0, 0, 0, "text.jei_mekanism_multiblocks.specs.valves", 0, 2, 0);
            consumer.accept(this.valvesWidget);
            ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).addValueChangeHanlder(this::onValvesChanged);
            this.updateValvesSliderLimit();
        }

        @Override
        protected void onDimensionChanged() {
            super.onDimensionChanged();
            this.updateValvesSliderLimit();
        }

        public void updateValvesSliderLimit() {
            IntSliderWidget valvesSlider = (IntSliderWidget)((Object)this.valvesWidget.getSlider());
            int valves = valvesSlider.getValue();
            valvesSlider.setMaxValue(this.getSideBlocks());
            valvesSlider.setValue(valves);
        }

        protected void onValvesChanged(int valves) {
            this.markNeedUpdate();
        }

        protected void onUseStructuralGlassChanged(boolean useStructuralGlass) {
            this.markNeedUpdate();
        }

        @Override
        protected void collectCost(ICostConsumer consumer) {
            super.collectCost(consumer);
            int corners = this.getCornerBlocks();
            int sides = this.getSideBlocks();
            int valves = this.getValveCount();
            sides -= valves;
            int tanks = 0;
            int structuralGlasses = 0;
            if (this.isUseStruturalGlass()) {
                tanks = corners;
                structuralGlasses = sides;
            } else {
                tanks = corners + sides;
            }
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.DYNAMIC_TANK, tanks));
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.DYNAMIC_VALVE, valves));
            consumer.accept(new ItemStack((ItemLike)MekanismBlocks.STRUCTURAL_GLASS, structuralGlasses));
        }

        @Override
        protected void collectResult(Consumer<AbstractWidget> consumer) {
            super.collectResult(consumer);
            int volume = this.getDimensionVolume();
            long fluidCapacity = volume * MekanismConfig.general.dynamicTankFluidPerTank.get();
            long chemicalCapacity = (long)volume * MekanismConfig.general.dynamicTankChemicalPerTank.get();
            consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.fluid_tank"), VolumeTextHelper.formatMB(fluidCapacity)));
            consumer.accept(new ResultWidget((Component)Component.m_237115_((String)"text.jei_mekanism_multiblocks.result.chemical_tank"), VolumeTextHelper.formatMB(chemicalCapacity)));
        }

        public int getValveCount() {
            return ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).getValue();
        }

        public void setValveCount(int valveCount) {
            ((IntSliderWidget)((Object)this.valvesWidget.getSlider())).setValue(valveCount);
        }

        public boolean isUseStruturalGlass() {
            return this.useStructuralGlassCheckBox.isSelected();
        }

        public void setUseStructuralGlass(boolean useStructuralGlass) {
            this.useStructuralGlassCheckBox.setSelected(useStructuralGlass);
        }

        @Override
        public int getDimensionWidthMin() {
            return 3;
        }

        @Override
        public int getDimensionWidthMax() {
            return 18;
        }

        @Override
        public int getDimensionLengthMin() {
            return 3;
        }

        @Override
        public int getDimensionLengthMax() {
            return 18;
        }

        @Override
        public int getDimensionHeightMin() {
            return 3;
        }

        @Override
        public int getDimensionHeightMax() {
            return 18;
        }
    }
}

