/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.util.parse.value;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.util.parse.function.JsonObjectConsumer;
import dev.gigaherz.jsonthings.util.parse.function.JsonObjectFunction;
import dev.gigaherz.jsonthings.util.parse.function.ObjValueFunction;
import dev.gigaherz.jsonthings.util.parse.value.Any;
import dev.gigaherz.jsonthings.util.parse.value.MappedValue;
import dev.gigaherz.jsonthings.util.parse.value.StringAnyConsumer;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;

public interface ObjValue {
    public ObjValue key(String var1, Consumer<Any> var2);

    public ObjValue ifKey(String var1, Consumer<Any> var2);

    public void forEach(StringAnyConsumer var1);

    public boolean hasKey(String var1);

    public JsonObject getAsJsonObject();

    public void raw(JsonObjectConsumer var1);

    default public <T> MappedValue<T> map(JsonObjectFunction<T> mapping) {
        return MappedValue.of(mapping.apply(this.getAsJsonObject()));
    }

    default public <T> MappedValue<T> map(ObjValueFunction<T> mapping) {
        return MappedValue.of(mapping.apply(this));
    }

    default public ObjValue noKey(String keyName, Supplier<RuntimeException> exception) {
        if (this.hasKey(keyName)) {
            throw exception.get();
        }
        return this;
    }

    default public ObjValue mutex(List<String> keys, Supplier<RuntimeException> exception) {
        String found = null;
        for (String key : keys) {
            if (!this.hasKey(key)) continue;
            if (found != null) {
                throw exception.get();
            }
            found = key;
        }
        return this;
    }

    default public ObjValue requireExactlyOne(List<String> keys, Supplier<RuntimeException> exception) {
        return this.requireExactlyOne(keys, exception, exception);
    }

    default public ObjValue requireExactlyOne(List<String> keys, Supplier<RuntimeException> tooManyException, Supplier<RuntimeException> notEnoughException) {
        String found = null;
        for (String key : keys) {
            if (!this.hasKey(key)) continue;
            if (found != null) {
                throw tooManyException.get();
            }
            found = key;
        }
        if (found == null) {
            throw notEnoughException.get();
        }
        return this;
    }
}

