/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.util;

import com.google.common.collect.ImmutableMap;
import dev.gigaherz.jsonthings.util.KeyNotFoundException;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

public class Utils {
    private static final Map<String, ArmorItem.Type> BACKWARD_COMPAT = ImmutableMap.builder().put((Object)"head", (Object)ArmorItem.Type.HELMET).put((Object)"chest", (Object)ArmorItem.Type.CHESTPLATE).put((Object)"legs", (Object)ArmorItem.Type.LEGGINGS).put((Object)"feet", (Object)ArmorItem.Type.BOOTS).build();

    public static TagKey<Item> itemTag(String pName) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(pName));
    }

    public static TagKey<Block> blockTag(String pName) {
        return TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(pName));
    }

    public static <T extends Comparable<T>> T getPropertyValue(Property<T> prop, String value) {
        Optional propValue = prop.m_6215_(value);
        return (T)((Comparable)propValue.orElseThrow(() -> new KeyNotFoundException("Value " + value + " for property " + prop.m_61708_() + " not found in the allowed values.")));
    }

    @Nonnull
    public static <T> T orElse(@Nullable T val, T def) {
        return val != null ? val : def;
    }

    public static <T> T orElseGet(@Nullable T val, Supplier<T> def) {
        return val != null ? val : def.get();
    }

    public static Item getItemOrCrash(ResourceLocation which) {
        return (Item)Utils.getOrCrash(ForgeRegistries.ITEMS, which);
    }

    public static Block getBlockOrCrash(ResourceLocation which) {
        return (Block)Utils.getOrCrash(ForgeRegistries.BLOCKS, which);
    }

    public static <T> T getOrCrash(IForgeRegistry<T> reg, ResourceLocation name) {
        if (!reg.containsKey(name)) {
            throw new KeyNotFoundException("Could not find an entry with name " + name + " in registry " + reg.getRegistryName());
        }
        return (T)reg.getValue(name);
    }

    public static <T> T getOrCrash(Registry<T> registry, ResourceLocation name) {
        Object t = registry.m_7745_(name);
        if (t == null) {
            throw new KeyNotFoundException("No object with name " + name + " found in the registry " + registry);
        }
        return (T)t;
    }

    public static <T> T getOrElse(IForgeRegistry<T> reg, ResourceLocation name, T fallback) {
        if (!reg.containsKey(name)) {
            return fallback;
        }
        return (T)reg.getValue(name);
    }

    public static <T> T getOrElse(Registry<T> registry, ResourceLocation name, T fallback) {
        if (!registry.m_7804_(name)) {
            return fallback;
        }
        return (T)Objects.requireNonNull(registry.m_7745_(name));
    }

    public static ArmorItem.Type armorTypeByEquipmentSlotName(String name) {
        ArmorItem.Type backwardCompat = BACKWARD_COMPAT.get(name);
        if (backwardCompat != null) {
            return backwardCompat;
        }
        throw new IllegalArgumentException("Invalid armor type '" + name + "'");
    }

    public static ArmorItem.Type armorTypeByName(String name) {
        for (ArmorItem.Type equipmentslot : ArmorItem.Type.values()) {
            if (!equipmentslot.m_266355_().equals(name)) continue;
            return equipmentslot;
        }
        throw new IllegalArgumentException("Invalid armor type '" + name + "'");
    }

    public MutableComponent withFont(MutableComponent component, ResourceLocation font) {
        return component.m_130938_(style -> style.m_131150_(font));
    }
}

