/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.serializers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.IFlexBlock;
import dev.gigaherz.jsonthings.things.IFlexFluid;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BlockBuilder;
import dev.gigaherz.jsonthings.things.builders.FluidBuilder;
import dev.gigaherz.jsonthings.things.fluids.FlexFlowingFluid;
import dev.gigaherz.jsonthings.things.fluids.FlexFluid;
import dev.gigaherz.jsonthings.things.serializers.FlexBlockType;
import dev.gigaherz.jsonthings.things.serializers.IFluidFactory;
import dev.gigaherz.jsonthings.things.serializers.IFluidSerializer;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.Any;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.fluids.FluidType;
import org.apache.commons.lang3.mutable.MutableObject;

public class FlexFluidType<T extends Fluid> {
    public static final FlexFluidType<FlexFluid> PLAIN = FlexFluidType.register("plain", (builder, data) -> new IFluidFactory<FlexFluid>(){

        @Override
        public FlexFluid construct(FluidBuilder builder) {
            Supplier<FluidType> fluidType = builder.getAttributesType();
            final List<Property<?>> _properties = builder.getProperties();
            Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
            return new FlexFluid(fluidType, propertyDefaultValues){

                protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder1) {
                    super.m_7180_(builder1);
                    _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                }
            };
        }
    }, "translucent", new Property[0]);
    public static final FlexFluidType<FlexFlowingFluid> FLOWING = FlexFluidType.register("flowing", new IFluidSerializer<FlexFlowingFluid>(){

        private static void parseLiquidBlock(ResourceLocation name, Any val, Consumer<BlockBuilder> blockConsumer) {
            val.ifBool(v -> v.handle(b -> {
                if (b) {
                    2.createLiquidBlock(name, new JsonObject(), blockConsumer);
                }
            })).ifObj(obj -> obj.raw(block -> 2.createLiquidBlock(name, block, blockConsumer))).typeError();
        }

        private static void createLiquidBlock(ResourceLocation name, JsonObject obj, Consumer<BlockBuilder> blockConsumer) {
            obj.addProperty("fluid", name.toString());
            BlockBuilder blockBuilder = JsonThings.blockParser.parseFromElement(name, (JsonElement)obj, b -> {
                if (!b.hasBlockType()) {
                    b.setBlockType(FlexBlockType.LIQUID);
                }
            });
            blockConsumer.accept(blockBuilder);
        }

        @Override
        public IFluidFactory<FlexFlowingFluid> createFactory(ResourceLocation name, JsonObject data) {
            final MutableObject slopeDistance = new MutableObject((Object)4);
            final MutableObject dropOff = new MutableObject((Object)1);
            final MutableObject canConvertToSource = new MutableObject((Object)false);
            final MutableObject tickDelay = new MutableObject((Object)5);
            final MutableObject explosionResistance = new MutableObject((Object)Float.valueOf(100.0f));
            final MutableObject block = new MutableObject();
            JParse.begin(data).ifKey("slope_distance", any -> any.intValue().min(1).handle(arg_0 -> ((MutableObject)slopeDistance).setValue(arg_0))).ifKey("dropoff", any -> any.intValue().range(1, 8).handle(arg_0 -> ((MutableObject)dropOff).setValue(arg_0))).ifKey("can_convert_to_source", any -> any.bool().handle(arg_0 -> ((MutableObject)canConvertToSource).setValue(arg_0))).ifKey("tick_delay", any -> any.intValue().min(0).handle(arg_0 -> ((MutableObject)tickDelay).setValue(arg_0))).ifKey("explosion_resistance", any -> any.floatValue().handle(arg_0 -> ((MutableObject)explosionResistance).setValue(arg_0))).ifKey("block", any -> 2.parseLiquidBlock(name, any, arg_0 -> ((MutableObject)block).setValue(arg_0)));
            return new IFluidFactory<FlexFlowingFluid>(){

                @Override
                public FlexFlowingFluid construct(FluidBuilder builder) {
                    Supplier<FluidType> fluidType = builder.getAttributesType();
                    final List<Property<?>> _properties = builder.getProperties();
                    Map<Property<?>, Comparable<?>> propertyDefaultValues = builder.getPropertyDefaultValues();
                    return new FlexFlowingFluid(fluidType, _properties, propertyDefaultValues, (Integer)slopeDistance.getValue(), (Integer)dropOff.getValue(), (Boolean)canConvertToSource.getValue(), (Integer)tickDelay.getValue(), ((Float)explosionResistance.getValue()).floatValue(), (Supplier)Lazy.of(() -> {
                        BlockBuilder v = (BlockBuilder)block.getValue();
                        return v != null ? ((IFlexBlock)v.get()).self() : Blocks.f_50016_;
                    })){

                        protected void m_7180_(StateDefinition.Builder<Fluid, FluidState> builder1) {
                            super.m_7180_(builder1);
                            _properties.forEach(xva$0 -> builder1.m_61104_(new Property[]{xva$0}));
                        }
                    };
                }

                @Override
                public Iterable<Fluid> getAllSiblings(FluidBuilder builder) {
                    FlowingFluid main = (FlowingFluid)((IFlexFluid)builder.get()).self();
                    return Arrays.asList(main.m_5613_(), main.m_5615_());
                }

                @Override
                public void register(FluidBuilder builder, BiConsumer<ResourceLocation, Fluid> register) {
                    register.accept(builder.getRegistryName(), ((IFlexFluid)builder.get()).self());
                    ResourceLocation flowingName = new ResourceLocation(builder.getRegistryName().m_135827_(), builder.getRegistryName().m_135815_() + "_flowing");
                    register.accept(flowingName, ((FlowingFluid)((IFlexFluid)builder.get()).self()).m_5615_());
                }
            };
        }
    }, "translucent", new Property[0]);
    private final IFluidSerializer<T> factory;
    private final List<Property<?>> stockProperties;
    private final String defaultLayer;

    public static void init() {
    }

    public static <T extends Fluid> FlexFluidType<T> register(String name, IFluidSerializer<T> factory, String defaultLayer, Property<?> ... stockProperties) {
        return (FlexFluidType)Registry.m_122961_(ThingRegistries.FLUID_TYPES, (String)name, new FlexFluidType<T>(factory, defaultLayer, Arrays.asList(stockProperties)));
    }

    private FlexFluidType(IFluidSerializer<T> factory, String defaultLayer, List<Property<?>> stockProperties) {
        this.factory = factory;
        this.defaultLayer = defaultLayer;
        this.stockProperties = stockProperties;
    }

    public IFluidFactory<T> getFactory(ResourceLocation name, JsonObject data) {
        return this.factory.createFactory(name, data);
    }

    public List<Property<?>> getStockProperties() {
        return this.stockProperties;
    }

    public String toString() {
        return "FluidType{" + ThingRegistries.FLUID_TYPES.m_7981_((Object)this) + "}";
    }

    public String getDefaultLayer() {
        return this.defaultLayer;
    }
}

