/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.scripting.rhino.dsl;

import com.google.common.collect.ImmutableMap;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.DSLHelpers;
import dev.gigaherz.jsonthings.things.scripting.rhino.dsl.LambdaBaseFunction;
import dev.latvian.mods.rhino.Context;
import dev.latvian.mods.rhino.NativeJavaMap;
import dev.latvian.mods.rhino.NativeJavaObject;
import dev.latvian.mods.rhino.Scriptable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.minecraft.nbt.ByteTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.ShortTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;

public class NbtDSL {
    public static void use(Context cx, Scriptable scope) {
        if (scope.has(cx, ".use_nbt", scope)) {
            return;
        }
        scope.put(cx, "NBT", scope, (Object)new NativeJavaMap(cx, scope, new Object(), (Map)ImmutableMap.builder().put((Object)"of", (Object)new LambdaBaseFunction(NbtDSL::wrap)).put((Object)"boolean", (Object)new LambdaBaseFunction(NbtDSL::makeBoolTag)).put((Object)"byte", (Object)new LambdaBaseFunction(NbtDSL::makeByteTag)).put((Object)"short", (Object)new LambdaBaseFunction(NbtDSL::makeShortTag)).put((Object)"int", (Object)new LambdaBaseFunction(NbtDSL::makeIntTag)).put((Object)"long", (Object)new LambdaBaseFunction(NbtDSL::makeLongTag)).put((Object)"float", (Object)new LambdaBaseFunction(NbtDSL::makeFloatTag)).put((Object)"double", (Object)new LambdaBaseFunction(NbtDSL::makeDoubleTag)).put((Object)"string", (Object)new LambdaBaseFunction(NbtDSL::makeStringTag)).put((Object)"list", (Object)new LambdaBaseFunction(NbtDSL::makeListTag)).put((Object)"compound", (Object)new LambdaBaseFunction(NbtDSL::makeCompoundTag)).build()));
        scope.put(cx, ".use_nbt", scope, (Object)true);
    }

    private static Object wrap(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        return DSLHelpers.wrap(cx, scope, NbtDSL.wrapInternal(args[0]), TagProxy.class);
    }

    private static TagProxy<?> wrapInternal(Object arg0) {
        Object d;
        Object f;
        Object l;
        Object i;
        Object s;
        Object b;
        if (arg0 instanceof NativeJavaObject) {
            NativeJavaObject obj = (NativeJavaObject)arg0;
            arg0 = obj.unwrap();
        }
        if (arg0 instanceof TagProxy) {
            TagProxy t = (TagProxy)arg0;
            return t;
        }
        if (arg0 instanceof ByteTag) {
            b = (ByteTag)arg0;
            return new ByteTagProxy(b.m_7063_());
        }
        if (arg0 instanceof ShortTag) {
            s = (ShortTag)arg0;
            return new ShortTagProxy(s.m_7053_());
        }
        if (arg0 instanceof IntTag) {
            i = (IntTag)arg0;
            return new IntTagProxy(i.m_7047_());
        }
        if (arg0 instanceof LongTag) {
            l = (LongTag)arg0;
            return new LongTagProxy(l.m_7046_());
        }
        if (arg0 instanceof FloatTag) {
            f = (FloatTag)arg0;
            return new FloatTagProxy(f.m_7057_());
        }
        if (arg0 instanceof DoubleTag) {
            d = (DoubleTag)arg0;
            return new DoubleTagProxy(d.m_7061_());
        }
        if (arg0 instanceof StringTag) {
            s = (StringTag)arg0;
            return new StringTagProxy(s.m_7916_());
        }
        if (arg0 instanceof ListTag) {
            l = (ListTag)arg0;
            return new ListTagProxy((ListTag)l);
        }
        if (arg0 instanceof CompoundTag) {
            CompoundTag c = (CompoundTag)arg0;
            return new CompoundTagProxy(c);
        }
        if (arg0 instanceof Boolean) {
            b = (Boolean)arg0;
            return new BooleanTagProxy((Boolean)b);
        }
        if (arg0 instanceof Byte) {
            b = (Byte)arg0;
            return new ByteTagProxy((Byte)b);
        }
        if (arg0 instanceof Short) {
            s = (Short)arg0;
            return new ShortTagProxy((Short)s);
        }
        if (arg0 instanceof Integer) {
            i = (Integer)arg0;
            return new IntTagProxy((Integer)i);
        }
        if (arg0 instanceof Long) {
            l = (Long)arg0;
            return new LongTagProxy((Long)l);
        }
        if (arg0 instanceof Float) {
            f = (Float)arg0;
            return new FloatTagProxy(((Float)f).floatValue());
        }
        if (arg0 instanceof Double) {
            d = (Double)arg0;
            return new DoubleTagProxy((Double)d);
        }
        if (arg0 instanceof String) {
            s = (String)arg0;
            return new StringTagProxy((String)s);
        }
        if (arg0 instanceof List) {
            l = (List)arg0;
            return new ListTagProxy(NbtDSL.makeListTagInternal(l));
        }
        if (arg0 instanceof Map) {
            Map m = (Map)arg0;
            return new CompoundTagProxy(NbtDSL.makeCompoundTagInternal(m));
        }
        throw new RuntimeException("Cannot convert " + arg0.getClass() + " to a Tag");
    }

    public static Tag wrapVanillaInternal(Object arg0) {
        Object d;
        Object f;
        Object l;
        Object i;
        Object s;
        Object b;
        if (arg0 instanceof NativeJavaObject) {
            NativeJavaObject obj = (NativeJavaObject)arg0;
            arg0 = obj.unwrap();
        }
        if (arg0 instanceof TagProxy) {
            TagProxy t = (TagProxy)arg0;
            return t.getTag();
        }
        if (arg0 instanceof ByteTag) {
            b = (ByteTag)arg0;
            return b;
        }
        if (arg0 instanceof ShortTag) {
            s = (ShortTag)arg0;
            return s;
        }
        if (arg0 instanceof IntTag) {
            i = (IntTag)arg0;
            return i;
        }
        if (arg0 instanceof LongTag) {
            l = (LongTag)arg0;
            return l;
        }
        if (arg0 instanceof FloatTag) {
            f = (FloatTag)arg0;
            return f;
        }
        if (arg0 instanceof DoubleTag) {
            d = (DoubleTag)arg0;
            return d;
        }
        if (arg0 instanceof StringTag) {
            s = (StringTag)arg0;
            return s;
        }
        if (arg0 instanceof ListTag) {
            l = (ListTag)arg0;
            return l;
        }
        if (arg0 instanceof CompoundTag) {
            CompoundTag c = (CompoundTag)arg0;
            return c;
        }
        if (arg0 instanceof Boolean) {
            b = (Boolean)arg0;
            return ByteTag.m_128273_((boolean)((Boolean)b));
        }
        if (arg0 instanceof Byte) {
            b = (Byte)arg0;
            return ByteTag.m_128266_((byte)((Byte)b));
        }
        if (arg0 instanceof Short) {
            s = (Short)arg0;
            return ShortTag.m_129258_((short)((Short)s));
        }
        if (arg0 instanceof Integer) {
            i = (Integer)arg0;
            return IntTag.m_128679_((int)((Integer)i));
        }
        if (arg0 instanceof Long) {
            l = (Long)arg0;
            return LongTag.m_128882_((long)((Long)l));
        }
        if (arg0 instanceof Float) {
            f = (Float)arg0;
            return FloatTag.m_128566_((float)((Float)f).floatValue());
        }
        if (arg0 instanceof Double) {
            d = (Double)arg0;
            return DoubleTag.m_128500_((double)((Double)d));
        }
        if (arg0 instanceof String) {
            s = (String)arg0;
            return StringTag.m_129297_((String)s);
        }
        if (arg0 instanceof List) {
            l = (List)arg0;
            return NbtDSL.makeListTagInternal(l);
        }
        if (arg0 instanceof Map) {
            Map m = (Map)arg0;
            return NbtDSL.makeCompoundTagInternal(m);
        }
        throw new RuntimeException("Cannot convert " + arg0.getClass() + " to a Tag");
    }

    private static Object makeBoolTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ByteTag b;
        Object arg0 = args[0];
        boolean value = arg0 instanceof ByteTag ? (b = (ByteTag)arg0).m_7063_() != 0 : (Boolean)arg0;
        return DSLHelpers.wrap(cx, scope, new BooleanTagProxy(value), TagProxy.class);
    }

    private static Object makeByteTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        byte by;
        Object arg0 = args[0];
        if (arg0 instanceof ByteTag) {
            ByteTag b = (ByteTag)arg0;
            by = b.m_7063_();
        } else {
            by = (Byte)arg0;
        }
        byte value = by;
        return DSLHelpers.wrap(cx, scope, new ByteTagProxy(value), TagProxy.class);
    }

    private static Object makeShortTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        short s;
        Object arg0 = args[0];
        if (arg0 instanceof ShortTag) {
            ShortTag b = (ShortTag)arg0;
            s = b.m_7053_();
        } else {
            s = (Short)arg0;
        }
        short value = s;
        return DSLHelpers.wrap(cx, scope, new ShortTagProxy(value), TagProxy.class);
    }

    private static Object makeIntTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        int n;
        Object arg0 = args[0];
        if (arg0 instanceof IntTag) {
            IntTag b = (IntTag)arg0;
            n = b.m_7047_();
        } else {
            n = (Integer)arg0;
        }
        int value = n;
        return DSLHelpers.wrap(cx, scope, new IntTagProxy(value), TagProxy.class);
    }

    private static Object makeLongTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        long l;
        Object arg0 = args[0];
        if (arg0 instanceof LongTag) {
            LongTag b = (LongTag)arg0;
            l = b.m_7046_();
        } else {
            l = (Long)arg0;
        }
        long value = l;
        return DSLHelpers.wrap(cx, scope, new LongTagProxy(value), TagProxy.class);
    }

    private static Object makeFloatTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        float f;
        Object arg0 = args[0];
        if (arg0 instanceof FloatTag) {
            FloatTag b = (FloatTag)arg0;
            f = b.m_7057_();
        } else {
            f = ((Float)arg0).floatValue();
        }
        float value = f;
        return DSLHelpers.wrap(cx, scope, new FloatTagProxy(value), TagProxy.class);
    }

    private static Object makeDoubleTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        double d;
        Object arg0 = args[0];
        if (arg0 instanceof DoubleTag) {
            DoubleTag b = (DoubleTag)arg0;
            d = b.m_7061_();
        } else {
            d = (Double)arg0;
        }
        double value = d;
        return DSLHelpers.wrap(cx, scope, new DoubleTagProxy(value), TagProxy.class);
    }

    private static Object makeStringTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        String string;
        Object arg0 = args[0];
        if (arg0 instanceof StringTag) {
            StringTag b = (StringTag)arg0;
            string = b.m_7916_();
        } else {
            string = (String)arg0;
        }
        String value = string;
        return DSLHelpers.wrap(cx, scope, new StringTagProxy(value), TagProxy.class);
    }

    private static Object makeListTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        ListTag list;
        Object arg0 = args[0];
        if (args.length == 1 && arg0 instanceof ListTag) {
            ListTag tag;
            list = tag = (ListTag)arg0;
        } else if (args.length == 1 && arg0 instanceof List) {
            List arr = (List)arg0;
            list = NbtDSL.makeListTagInternal(arr);
        } else {
            list = NbtDSL.makeListTagInternal(Arrays.asList(args));
        }
        return DSLHelpers.wrap(cx, scope, new ListTagProxy(list), TagProxy.class);
    }

    private static ListTag makeListTagInternal(List<?> args) {
        ListTag list = new ListTag();
        NbtDSL.addAllElements(list, args);
        return list;
    }

    private static void addAllElements(ListTag list, List<?> args) {
        Class<?> tagType = null;
        for (Object arg : args) {
            Tag wrapped = NbtDSL.wrapVanillaInternal(arg);
            if (tagType == null) {
                tagType = wrapped.getClass();
            } else if (tagType != wrapped.getClass()) {
                throw new IllegalStateException("List tags must have homogenous data type. Tried to add " + wrapped.getClass() + " but the list already contains " + tagType);
            }
            list.add((Object)wrapped);
        }
    }

    private static void addAllElements(CompoundTag map, Map<?, ?> values) {
        for (Map.Entry<?, ?> arg : values.entrySet()) {
            String key = (String)arg.getKey();
            Object value = arg.getValue();
            Tag wrapped = NbtDSL.wrapVanillaInternal(value);
            map.m_128365_(key, wrapped);
        }
    }

    private static Object makeCompoundTag(Context cx, Scriptable scope, Scriptable thisObj, Object[] args) {
        CompoundTag compound;
        Object arg0 = args[0];
        if (args.length == 1 && arg0 instanceof CompoundTag) {
            CompoundTag tag;
            compound = tag = (CompoundTag)arg0;
        } else if (args.length == 1 && arg0 instanceof Map) {
            Map arr = (Map)arg0;
            compound = NbtDSL.makeCompoundTagInternal(arr);
        } else {
            compound = new CompoundTag();
            if (args.length % 2 != 0) {
                throw new IllegalStateException("compound constructor must either have one compound param, or a sequence of key-value pairs");
            }
            for (int i = 0; i < args.length; i += 2) {
                compound.m_128365_((String)args[i], NbtDSL.wrapVanillaInternal(args[i + 1]));
            }
        }
        return DSLHelpers.wrap(cx, scope, new CompoundTagProxy(compound), TagProxy.class);
    }

    private static CompoundTag makeCompoundTagInternal(Map<?, ?> map) {
        CompoundTag compound = new CompoundTag();
        NbtDSL.addAllElements(compound, map);
        return compound;
    }

    public static interface TagProxy<T extends Tag> {
        public T getTag();
    }

    public static class ByteTagProxy
    extends PrimitiveTagProxy<Byte, ByteTag> {
        public ByteTagProxy(byte value) {
            super(value);
        }

        @Override
        public ByteTag getTag() {
            return ByteTag.m_128266_((byte)((Byte)this.value));
        }
    }

    public static class ShortTagProxy
    extends PrimitiveTagProxy<Short, ShortTag> {
        public ShortTagProxy(short value) {
            super(value);
        }

        @Override
        public ShortTag getTag() {
            return ShortTag.m_129258_((short)((Short)this.value));
        }
    }

    public static class IntTagProxy
    extends PrimitiveTagProxy<Integer, IntTag> {
        public IntTagProxy(int value) {
            super(value);
        }

        @Override
        public IntTag getTag() {
            return IntTag.m_128679_((int)((Integer)this.value));
        }
    }

    public static class LongTagProxy
    extends PrimitiveTagProxy<Long, LongTag> {
        public LongTagProxy(long value) {
            super(value);
        }

        @Override
        public LongTag getTag() {
            return LongTag.m_128882_((long)((Long)this.value));
        }
    }

    public static class FloatTagProxy
    extends PrimitiveTagProxy<Float, FloatTag> {
        public FloatTagProxy(float value) {
            super(Float.valueOf(value));
        }

        @Override
        public FloatTag getTag() {
            return FloatTag.m_128566_((float)((Float)this.value).floatValue());
        }
    }

    public static class DoubleTagProxy
    extends PrimitiveTagProxy<Double, DoubleTag> {
        public DoubleTagProxy(double value) {
            super(value);
        }

        @Override
        public DoubleTag getTag() {
            return DoubleTag.m_128500_((double)((Double)this.value));
        }
    }

    public static class StringTagProxy
    extends PrimitiveTagProxy<String, StringTag> {
        public StringTagProxy(String value) {
            super(value);
        }

        @Override
        public StringTag getTag() {
            return StringTag.m_129297_((String)((String)this.value));
        }
    }

    public static class ListTagProxy
    implements TagProxy<ListTag> {
        private final ListTag list;

        public ListTagProxy(ListTag value) {
            this.list = value;
        }

        public Object get(int index) {
            return NbtDSL.wrapInternal(this.list.get(index));
        }

        public void add(Tag tag) {
            this.list.add((Object)tag);
        }

        public void add(TagProxy<?> tag) {
            this.list.add(tag.getTag());
        }

        public void remove(int index) {
            this.list.remove(index);
        }

        @Override
        public ListTag getTag() {
            return this.list;
        }
    }

    public static class CompoundTagProxy
    implements TagProxy<CompoundTag> {
        private final CompoundTag compound;

        public CompoundTagProxy(CompoundTag value) {
            this.compound = value;
        }

        public Object get(String key) {
            return NbtDSL.wrapInternal(this.compound.m_128423_(key));
        }

        public void put(String key, Tag tag) {
            this.compound.m_128365_(key, tag);
        }

        public void put(String key, TagProxy<?> tag) {
            this.compound.m_128365_(key, tag.getTag());
        }

        public void remove(String key) {
            this.compound.m_128473_(key);
        }

        @Override
        public CompoundTag getTag() {
            return this.compound;
        }
    }

    public static class BooleanTagProxy
    extends PrimitiveTagProxy<Boolean, ByteTag> {
        public BooleanTagProxy(boolean value) {
            super(value);
        }

        @Override
        public ByteTag getTag() {
            return ByteTag.m_128273_((boolean)((Boolean)this.value));
        }
    }

    private static abstract class PrimitiveTagProxy<V, T extends Tag>
    implements TagProxy<T> {
        public final V value;

        protected PrimitiveTagProxy(V value) {
            this.value = value;
        }
    }
}

