/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.SoundEventBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.parse.JParse;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SoundEventParser
extends ThingParser<SoundEventBuilder> {
    public static final Logger LOGGER = LogManager.getLogger();

    public SoundEventParser(IEventBus bus) {
        super(GSON, "sound_event");
        bus.addListener(this::register);
    }

    public void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.SOUND_EVENTS, helper -> {
            LOGGER.info("Started registering SoundEvent things, errors about unexpected registry domains are harmless...");
            SoundEventParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> helper.register(thing.getRegistryName(), (Object)((SoundEvent)thing.get())), BaseBuilder::getRegistryName);
            LOGGER.info("Done processing thingpack SoundEvents.");
        });
    }

    @Override
    public SoundEventBuilder processThing(ResourceLocation key, JsonObject data, Consumer<SoundEventBuilder> builderModification) {
        SoundEventBuilder builder = SoundEventBuilder.begin(this, key);
        JParse.begin(data).ifKey("range", val -> val.floatValue().handle(builder::setRange));
        builderModification.accept(builder);
        return builder;
    }
}

