/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.parsers;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.ThingRegistries;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.FoodBuilder;
import dev.gigaherz.jsonthings.things.builders.MobEffectInstanceBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParseException;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.parse.JParse;
import dev.gigaherz.jsonthings.util.parse.value.ObjValue;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public class FoodParser
extends ThingParser<FoodBuilder> {
    public FoodParser() {
        super(GSON, "food");
    }

    @Override
    protected void finishLoadingInternal() {
        FoodParser.processAndConsumeErrors(this.getThingType(), this.getBuilders(), (T thing) -> Registry.m_122965_(ThingRegistries.FOODS, (ResourceLocation)thing.getRegistryName(), (Object)((FoodProperties)thing.get())), BaseBuilder::getRegistryName);
    }

    @Override
    public FoodBuilder processThing(ResourceLocation key, JsonObject data, Consumer<FoodBuilder> builderModification) {
        FoodBuilder builder = FoodBuilder.begin(this, key);
        JParse.begin(data).key("nutrition", val -> val.intValue().min(1).handle(builder::setNutrition)).key("saturation", val -> val.floatValue().min(0.0f).handle(builder::setSaturation)).ifKey("meat", val -> val.bool().handle(builder::setIsMeat)).ifKey("fast", val -> val.bool().handle(builder::setFast)).ifKey("always_eat", val -> val.bool().handle(builder::setAlwaysEat)).ifKey("effects", val -> val.array().forEach((i, entry) -> {
            MutableFloat probability = new MutableFloat(1.0f);
            MobEffectInstanceBuilder effectBuilder = this.parseEffectInstance(entry.obj().ifKey("probability", v3 -> v3.floatValue().range(0.0f, 1.0f).handle(arg_0 -> ((MutableFloat)probability).setValue(arg_0))), builder);
            if (effectBuilder != null) {
                builder.effect(effectBuilder, probability.getValue().floatValue());
            }
        }));
        builderModification.accept(builder);
        return builder;
    }

    @Nullable
    private MobEffectInstanceBuilder parseEffectInstance(ObjValue obj, FoodBuilder parentBuilder) {
        try {
            MobEffectInstanceBuilder builder = (MobEffectInstanceBuilder)JsonThings.mobEffectInstanceParser.parseFromElement(parentBuilder.getRegistryName(), (JsonElement)obj.getAsJsonObject());
            if (builder != null) {
                builder.setOwner(parentBuilder);
            }
            return builder;
        }
        catch (Exception e) {
            throw new ThingParseException("Exception while parsing nested block in " + parentBuilder.getRegistryName(), e);
        }
    }
}

