/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.fluids;

import com.google.common.collect.Maps;
import dev.gigaherz.jsonthings.things.IFlexFluid;
import dev.gigaherz.jsonthings.things.events.FlexEventHandler;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidType;

public class FlexFluid
extends Fluid
implements IFlexFluid {
    private final Map<String, FlexEventHandler> eventHandlers = Maps.newHashMap();
    private Supplier<Item> bucketItem = () -> Items.f_41852_;
    private Supplier<FluidType> fluidType;

    public FlexFluid(Supplier<FluidType> fluidType, Map<Property<?>, Comparable<?>> propertyDefaultValues) {
        this.fluidType = fluidType;
        this.initializeFlex(propertyDefaultValues);
    }

    private void initializeFlex(Map<Property<?>, Comparable<?>> propertyDefaultValues) {
        if (propertyDefaultValues.size() > 0) {
            FluidState def = (FluidState)this.m_76144_().m_61090_();
            for (Map.Entry<Property<?>, Comparable<?>> entry : propertyDefaultValues.entrySet()) {
                Property<?> prop = entry.getKey();
                Comparable<?> value = entry.getValue();
                def = (FluidState)def.m_61124_(prop, value);
            }
            this.m_76142_(def);
        }
    }

    @Override
    public void addEventHandler(String eventName, FlexEventHandler eventHandler) {
        this.eventHandlers.put(eventName, eventHandler);
    }

    @Override
    public FlexEventHandler getEventHandler(String eventName) {
        return this.eventHandlers.get(eventName);
    }

    @Override
    public void setBucketItem(Supplier<Item> bucketItem) {
        this.bucketItem = bucketItem;
    }

    public FluidType getFluidType() {
        return this.fluidType.get();
    }

    public Item m_6859_() {
        return this.bucketItem != null ? this.bucketItem.get() : Items.f_41852_;
    }

    protected boolean m_5486_(FluidState pFluidState, BlockGetter pBlockReader, BlockPos pPos, Fluid pFluid, Direction pDirection) {
        return true;
    }

    public Vec3 m_7000_(BlockGetter pBlockReader, BlockPos pPos, FluidState pFluidState) {
        return Vec3.f_82478_;
    }

    public int m_6718_(LevelReader level) {
        return 0;
    }

    protected float m_6752_() {
        return 0.0f;
    }

    public float m_6098_(FluidState pState, BlockGetter level, BlockPos pos) {
        return 0.0f;
    }

    public float m_7427_(FluidState pState) {
        return 0.0f;
    }

    protected BlockState m_5804_(FluidState pState) {
        return Blocks.f_50016_.m_49966_();
    }

    public boolean m_7444_(FluidState pState) {
        return true;
    }

    public int m_7430_(FluidState pState) {
        return 0;
    }

    public VoxelShape m_7999_(FluidState pState, BlockGetter level, BlockPos pos) {
        return Shapes.m_83040_();
    }
}

