/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.client;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.state.BlockState;

public class ItemColorHandler {
    private static final Map<String, Function<BlockColors, ItemColor>> colorHandlersByName = Maps.newHashMap();

    public static void init() {
        ItemColorHandler.register("tall_grass", blockColors -> (stack, color) -> GrassColor.m_46415_((double)0.5, (double)1.0));
        ItemColorHandler.register("foliage", blockColors -> (stack, color) -> {
            BlockState blockstate = ((BlockItem)stack.m_41720_()).m_40614_().m_49966_();
            return blockColors.m_92577_(blockstate, null, null, color);
        });
    }

    public static void register(String name, Function<BlockColors, ItemColor> handler) {
        colorHandlersByName.put(name, handler);
    }

    public static Function<BlockColors, ItemColor> get(String handlerName) {
        if (!colorHandlersByName.containsKey(handlerName)) {
            throw new IllegalStateException("No item color handler known with name " + handlerName);
        }
        return colorHandlersByName.get(handlerName);
    }
}

