/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.client;

import com.google.common.collect.Maps;
import java.util.Map;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.renderer.BiomeColors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.FoliageColor;
import net.minecraft.world.level.GrassColor;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class BlockColorHandler {
    private static final Map<String, BlockColor> colorHandlersByName = Maps.newHashMap();

    public static void init() {
        BlockColorHandler.register("tall_grass", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)(state.m_61143_((Property)DoublePlantBlock.f_52858_) == DoubleBlockHalf.UPPER ? pos.m_7495_() : pos)) : -1);
        BlockColorHandler.register("grass", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : GrassColor.m_46415_((double)0.5, (double)1.0));
        BlockColorHandler.register("spruce", (state, reader, pos, color) -> FoliageColor.m_46106_());
        BlockColorHandler.register("birch", (state, reader, pos, color) -> FoliageColor.m_46112_());
        BlockColorHandler.register("foliage", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108804_((BlockAndTintGetter)reader, (BlockPos)pos) : FoliageColor.m_46113_());
        BlockColorHandler.register("water", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108811_((BlockAndTintGetter)reader, (BlockPos)pos) : -1);
        BlockColorHandler.register("redstone", (state, reader, pos, color) -> RedStoneWireBlock.m_55606_((int)((Integer)state.m_61143_((Property)RedStoneWireBlock.f_55500_))));
        BlockColorHandler.register("sugarcane", (state, reader, pos, color) -> reader != null && pos != null ? BiomeColors.m_108793_((BlockAndTintGetter)reader, (BlockPos)pos) : -1);
    }

    public static void register(String name, BlockColor handler) {
        colorHandlersByName.put(name, handler);
    }

    public static BlockColor get(String handlerName) {
        if (!colorHandlersByName.containsKey(handlerName)) {
            throw new IllegalStateException("No block color handler known with name " + handlerName);
        }
        return colorHandlersByName.get(handlerName);
    }
}

