/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.FoodBuilder;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.util.Utils;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraftforge.registries.ForgeRegistries;

public class MobEffectInstanceBuilder
extends BaseBuilder<MobEffectInstance, MobEffectInstanceBuilder> {
    private ResourceLocation effect;
    private int duration;
    private int amplifier = 0;
    private boolean isAmbient = false;
    private boolean showParticles = true;
    private boolean showIcon = true;
    private FoodBuilder owner;

    public MobEffectInstanceBuilder(ThingParser<MobEffectInstanceBuilder> ownerParser, ResourceLocation name) {
        super(ownerParser, name);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Mob Effect Instance";
    }

    @Override
    protected CrashReportCategory fillReport(CrashReport crashReport) {
        CrashReportCategory reportCategory = super.fillReport(crashReport);
        reportCategory.m_128159_("Contained in", (Object)this.owner.getThingTypeDisplayName());
        return reportCategory;
    }

    public void setOwner(FoodBuilder owner) {
        this.owner = owner;
    }

    public FoodBuilder getOwner() {
        return this.owner;
    }

    public ResourceLocation getEffect() {
        return this.effect;
    }

    public void setEffect(ResourceLocation effect) {
        this.effect = effect;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public void setAmplifier(int amplifier) {
        this.amplifier = amplifier;
    }

    public void setAmbient(boolean ambient) {
        this.isAmbient = ambient;
    }

    public void setShowParticles(boolean showParticles) {
        this.showParticles = showParticles;
    }

    public void setShowIcon(boolean showIcon) {
        this.showIcon = showIcon;
    }

    public void setVisible(boolean visible) {
        this.showParticles = this.showIcon = visible;
    }

    @Override
    protected MobEffectInstance buildInternal() {
        return new MobEffectInstance((MobEffect)Utils.getOrCrash(ForgeRegistries.MOB_EFFECTS, this.effect), this.duration, this.amplifier, this.isAmbient, this.showParticles, this.showIcon);
    }
}

