/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.JsonThings;
import dev.gigaherz.jsonthings.things.StackContext;
import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.builders.ItemBuilder;
import dev.gigaherz.jsonthings.things.misc.FlexCreativeModeTab;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import dev.gigaherz.jsonthings.things.serializers.ItemVariantProvider;
import dev.gigaherz.jsonthings.util.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.Nullable;

public class CreativeModeTabBuilder
extends BaseBuilder<FlexCreativeModeTab, CreativeModeTabBuilder> {
    private StackContext iconItem;
    private final ArrayList<ItemVariantProvider> items = new ArrayList();
    private ResourceLocation[] before;
    private ResourceLocation[] after;
    private String translation_key;
    private boolean rightSide;

    public static CreativeModeTabBuilder begin(ThingParser<CreativeModeTabBuilder> ownerParser, ResourceLocation registryName) {
        return new CreativeModeTabBuilder(ownerParser, registryName);
    }

    private CreativeModeTabBuilder(ThingParser<CreativeModeTabBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Creative Mode Tab";
    }

    public void setIcon(StackContext stackContext) {
        this.iconItem = stackContext;
    }

    public void setBefore(ResourceLocation ... before) {
        this.before = before;
    }

    public void setAfter(ResourceLocation ... after) {
        this.after = after;
    }

    @Override
    protected FlexCreativeModeTab buildInternal() {
        ResourceLocation registryName = this.getRegistryName();
        return new FlexCreativeModeTab((String)(this.translation_key != null ? this.translation_key : registryName.m_135827_() + "." + registryName.m_135815_().replace("/", ".")), this.iconItem);
    }

    public void addItem(final ResourceLocation item) {
        this.items.add(new ItemVariantProvider(){
            final ResourceLocation itemName;
            private ItemVariantProvider actualVariant;
            {
                this.itemName = item;
            }

            @Override
            public final void provideVariants(ResourceKey<CreativeModeTab> tabKey, CreativeModeTab.Output output, CreativeModeTab.ItemDisplayParameters parameters, @Nullable ItemBuilder context, boolean explicit) {
                if (this.actualVariant == null) {
                    ItemVariantProvider provider;
                    Item item2;
                    ItemBuilder builder = (ItemBuilder)JsonThings.itemParser.getBuildersMap().get(this.itemName);
                    this.actualVariant = builder != null ? builder : ((item2 = Utils.getItemOrCrash(this.itemName)) instanceof ItemVariantProvider ? (provider = (ItemVariantProvider)item2) : (tabKey1, output1, parameters1, context1, explicit1) -> output1.m_246342_(item2.m_7968_()));
                }
                this.actualVariant.provideVariants(tabKey, output, parameters, context, explicit);
            }
        });
    }

    public void addItem(StackContext stackContext) {
        this.items.add(stackContext);
    }

    public List<StackContext> getItems() {
        return this.items.stream().filter(t -> t instanceof StackContext).map(t -> (StackContext)t).toList();
    }

    public List<ItemVariantProvider> getVariantProviders() {
        return this.items;
    }

    public ResourceLocation @Nullable [] getBefore() {
        return this.before;
    }

    public ResourceLocation @Nullable [] getAfter() {
        return this.after;
    }

    public boolean getRightSide() {
        return this.rightSide;
    }

    public void setTranslationKey(String key) {
        this.translation_key = key;
    }

    public void setRightSide(boolean rightSide) {
        this.rightSide = rightSide;
    }
}

