/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things.builders;

import dev.gigaherz.jsonthings.things.builders.BaseBuilder;
import dev.gigaherz.jsonthings.things.misc.FlexArmorMaterial;
import dev.gigaherz.jsonthings.things.parsers.ThingParser;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public class ArmorMaterialBuilder
extends BaseBuilder<FlexArmorMaterial, ArmorMaterialBuilder> {
    private final Map<ArmorItem.Type, Integer> durability = new HashMap<ArmorItem.Type, Integer>();
    private final Map<ArmorItem.Type, Integer> defense = new HashMap<ArmorItem.Type, Integer>();
    private float toughness;
    private float knockbackResistance;
    private int enchantmentValue;
    private ResourceLocation equipSound;
    private Supplier<Ingredient> repairIngredient;

    public static ArmorMaterialBuilder begin(ThingParser<ArmorMaterialBuilder> ownerParser, ResourceLocation registryName) {
        return new ArmorMaterialBuilder(ownerParser, registryName);
    }

    private ArmorMaterialBuilder(ThingParser<ArmorMaterialBuilder> ownerParser, ResourceLocation registryName) {
        super(ownerParser, registryName);
    }

    @Override
    protected String getThingTypeDisplayName() {
        return "Armor Material";
    }

    public void setDurability(Map<ArmorItem.Type, Integer> durability) {
        this.durability.putAll(durability);
    }

    public void setDefense(Map<ArmorItem.Type, Integer> defense) {
        this.defense.putAll(defense);
    }

    public void setToughness(float toughness) {
        this.toughness = toughness;
    }

    public void setKnockbackResistance(float knockbackResistance) {
        this.knockbackResistance = knockbackResistance;
    }

    public void setEnchantmentValue(int enchantmentValue) {
        this.enchantmentValue = enchantmentValue;
    }

    public void setEquipSound(ResourceLocation equipSound) {
        this.equipSound = equipSound;
    }

    public void setRepairIngredient(Supplier<Ingredient> repairIngredient) {
        this.repairIngredient = repairIngredient;
    }

    @Override
    protected FlexArmorMaterial buildInternal() {
        RegistryObject se = RegistryObject.create((ResourceLocation)this.equipSound, (IForgeRegistry)ForgeRegistries.SOUND_EVENTS);
        return new FlexArmorMaterial(this.getRegistryName().toString(), this.durability, this.defense, this.toughness, this.knockbackResistance, this.enchantmentValue, (Supplier<SoundEvent>)se, this.repairIngredient);
    }
}

