/*
 * Decompiled with CFR 0.152.
 */
package dev.gigaherz.jsonthings.things;

import com.mojang.serialization.Lifecycle;
import dev.gigaherz.jsonthings.things.properties.PropertyType;
import dev.gigaherz.jsonthings.things.properties.PropertyTypes;
import dev.gigaherz.jsonthings.things.serializers.FlexBlockType;
import dev.gigaherz.jsonthings.things.serializers.FlexFluidType;
import dev.gigaherz.jsonthings.things.serializers.FlexItemType;
import dev.gigaherz.jsonthings.things.serializers.MapColors;
import dev.gigaherz.jsonthings.things.shapes.DynamicShape;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.food.Foods;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.ArmorMaterials;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ThingRegistries {
    public static final ResourceKey<Registry<Registry<?>>> THING_REGISTRIES_REGISTRY = ThingRegistries.createKey("jsonthings:registries");
    public static final ResourceKey<Registry<ArmorMaterial>> ARMOR_MATERIAL_REGISTRY = ThingRegistries.createKey("jsonthings:armor_material");
    public static final ResourceKey<Registry<FoodProperties>> FOOD_REGISTRY = ThingRegistries.createKey("jsonthings:food");
    public static final ResourceKey<Registry<PropertyType>> PROPERTY_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:property_type");
    public static final ResourceKey<Registry<Property<?>>> PROPERTY_REGISTRY = ThingRegistries.createKey("jsonthings:property");
    public static final ResourceKey<Registry<DynamicShape>> DYNAMIC_SHAPE_REGISTRY = ThingRegistries.createKey("jsonthings:dynamic_shapes");
    public static final ResourceKey<Registry<FlexBlockType<?>>> BLOCK_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:block_types");
    public static final ResourceKey<Registry<FlexItemType<?>>> ITEM_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:item_types");
    public static final ResourceKey<Registry<SoundType>> SOUND_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:sound_types");
    public static final ResourceKey<Registry<FlexFluidType<?>>> FLUID_TYPE_REGISTRY = ThingRegistries.createKey("jsonthings:fluid_types");
    public static final Registry<Registry<?>> THING_REGISTRIES = new MappedRegistry(THING_REGISTRIES_REGISTRY, Lifecycle.experimental(), false);
    public static final Registry<ArmorMaterial> ARMOR_MATERIALS = ThingRegistries.makeRegistry(ARMOR_MATERIAL_REGISTRY);
    public static final Registry<FoodProperties> FOODS = ThingRegistries.makeRegistry(FOOD_REGISTRY);
    public static final Registry<PropertyType> PROPERTY_TYPES = ThingRegistries.makeRegistry(PROPERTY_TYPE_REGISTRY);
    public static final Registry<Property<?>> PROPERTIES = ThingRegistries.makeRegistry(PROPERTY_REGISTRY);
    public static final Registry<DynamicShape> DYNAMIC_SHAPES = ThingRegistries.makeRegistry(DYNAMIC_SHAPE_REGISTRY);
    public static final Registry<FlexItemType<?>> ITEM_TYPES = ThingRegistries.makeRegistry(ITEM_TYPE_REGISTRY);
    public static final Registry<FlexBlockType<?>> BLOCK_TYPES = ThingRegistries.makeRegistry(BLOCK_TYPE_REGISTRY);
    public static final Registry<SoundType> SOUND_TYPES = ThingRegistries.makeRegistry(SOUND_TYPE_REGISTRY);
    public static final Registry<FlexFluidType<?>> FLUID_TYPES = ThingRegistries.makeRegistry(FLUID_TYPE_REGISTRY);

    public static void staticInit() {
    }

    private static <T> ResourceKey<Registry<T>> createKey(String name) {
        return ResourceKey.m_135788_((ResourceLocation)new ResourceLocation(name));
    }

    private static <T> Registry<T> makeRegistry(ResourceKey<Registry<T>> key) {
        MappedRegistry registry = new MappedRegistry(key, Lifecycle.experimental(), false);
        return (Registry)Registry.m_122961_(THING_REGISTRIES, (String)key.m_135782_().toString(), (Object)registry);
    }

    private static void registerDynamicShapes() {
        Registry.m_122961_(DYNAMIC_SHAPES, (String)"empty", (Object)DynamicShape.empty());
    }

    private static void registerProperties() {
        Registry.m_122961_(PROPERTIES, (String)"attached", (Object)BlockStateProperties.f_61386_);
        Registry.m_122961_(PROPERTIES, (String)"bottom", (Object)BlockStateProperties.f_61427_);
        Registry.m_122961_(PROPERTIES, (String)"conditional", (Object)BlockStateProperties.f_61428_);
        Registry.m_122961_(PROPERTIES, (String)"disarmed", (Object)BlockStateProperties.f_61429_);
        Registry.m_122961_(PROPERTIES, (String)"drag", (Object)BlockStateProperties.f_61430_);
        Registry.m_122961_(PROPERTIES, (String)"enabled", (Object)BlockStateProperties.f_61431_);
        Registry.m_122961_(PROPERTIES, (String)"extended", (Object)BlockStateProperties.f_61432_);
        Registry.m_122961_(PROPERTIES, (String)"eye", (Object)BlockStateProperties.f_61433_);
        Registry.m_122961_(PROPERTIES, (String)"falling", (Object)BlockStateProperties.f_61434_);
        Registry.m_122961_(PROPERTIES, (String)"hanging", (Object)BlockStateProperties.f_61435_);
        Registry.m_122961_(PROPERTIES, (String)"has_bottle_0", (Object)BlockStateProperties.f_61436_);
        Registry.m_122961_(PROPERTIES, (String)"has_bottle_1", (Object)BlockStateProperties.f_61437_);
        Registry.m_122961_(PROPERTIES, (String)"has_bottle_2", (Object)BlockStateProperties.f_61438_);
        Registry.m_122961_(PROPERTIES, (String)"has_record", (Object)BlockStateProperties.f_61439_);
        Registry.m_122961_(PROPERTIES, (String)"has_book", (Object)BlockStateProperties.f_61440_);
        Registry.m_122961_(PROPERTIES, (String)"inverted", (Object)BlockStateProperties.f_61441_);
        Registry.m_122961_(PROPERTIES, (String)"in_wall", (Object)BlockStateProperties.f_61442_);
        Registry.m_122961_(PROPERTIES, (String)"lit", (Object)BlockStateProperties.f_61443_);
        Registry.m_122961_(PROPERTIES, (String)"locked", (Object)BlockStateProperties.f_61444_);
        Registry.m_122961_(PROPERTIES, (String)"occupied", (Object)BlockStateProperties.f_61445_);
        Registry.m_122961_(PROPERTIES, (String)"open", (Object)BlockStateProperties.f_61446_);
        Registry.m_122961_(PROPERTIES, (String)"persistent", (Object)BlockStateProperties.f_61447_);
        Registry.m_122961_(PROPERTIES, (String)"powered", (Object)BlockStateProperties.f_61448_);
        Registry.m_122961_(PROPERTIES, (String)"short", (Object)BlockStateProperties.f_61449_);
        Registry.m_122961_(PROPERTIES, (String)"signal_fire", (Object)BlockStateProperties.f_61450_);
        Registry.m_122961_(PROPERTIES, (String)"snowy", (Object)BlockStateProperties.f_61451_);
        Registry.m_122961_(PROPERTIES, (String)"triggered", (Object)BlockStateProperties.f_61360_);
        Registry.m_122961_(PROPERTIES, (String)"unstable", (Object)BlockStateProperties.f_61361_);
        Registry.m_122961_(PROPERTIES, (String)"waterlogged", (Object)BlockStateProperties.f_61362_);
        Registry.m_122961_(PROPERTIES, (String)"berries", (Object)BlockStateProperties.f_155977_);
        Registry.m_122961_(PROPERTIES, (String)"bloom", (Object)BlockStateProperties.f_222995_);
        Registry.m_122961_(PROPERTIES, (String)"shrieking", (Object)BlockStateProperties.f_222996_);
        Registry.m_122961_(PROPERTIES, (String)"can_summon", (Object)BlockStateProperties.f_222997_);
        Registry.m_122961_(PROPERTIES, (String)"horizontal_axis", (Object)BlockStateProperties.f_61364_);
        Registry.m_122961_(PROPERTIES, (String)"axis", (Object)BlockStateProperties.f_61365_);
        Registry.m_122961_(PROPERTIES, (String)"up", (Object)BlockStateProperties.f_61366_);
        Registry.m_122961_(PROPERTIES, (String)"down", (Object)BlockStateProperties.f_61367_);
        Registry.m_122961_(PROPERTIES, (String)"north", (Object)BlockStateProperties.f_61368_);
        Registry.m_122961_(PROPERTIES, (String)"east", (Object)BlockStateProperties.f_61369_);
        Registry.m_122961_(PROPERTIES, (String)"south", (Object)BlockStateProperties.f_61370_);
        Registry.m_122961_(PROPERTIES, (String)"west", (Object)BlockStateProperties.f_61371_);
        Registry.m_122961_(PROPERTIES, (String)"facing", (Object)BlockStateProperties.f_61372_);
        Registry.m_122961_(PROPERTIES, (String)"facing_except_up", (Object)BlockStateProperties.f_61373_);
        Registry.m_122961_(PROPERTIES, (String)"horizontal_facing", (Object)BlockStateProperties.f_61374_);
        Registry.m_122961_(PROPERTIES, (String)"flower_amount", (Object)BlockStateProperties.f_271526_);
        Registry.m_122961_(PROPERTIES, (String)"orientation", (Object)BlockStateProperties.f_61375_);
        Registry.m_122961_(PROPERTIES, (String)"face", (Object)BlockStateProperties.f_61376_);
        Registry.m_122961_(PROPERTIES, (String)"bell_attachment", (Object)BlockStateProperties.f_61377_);
        Registry.m_122961_(PROPERTIES, (String)"wall_height_east", (Object)BlockStateProperties.f_61378_);
        Registry.m_122961_(PROPERTIES, (String)"wall_height_north", (Object)BlockStateProperties.f_61379_);
        Registry.m_122961_(PROPERTIES, (String)"wall_height_south", (Object)BlockStateProperties.f_61380_);
        Registry.m_122961_(PROPERTIES, (String)"wall_height_west", (Object)BlockStateProperties.f_61381_);
        Registry.m_122961_(PROPERTIES, (String)"redstone_east", (Object)BlockStateProperties.f_61382_);
        Registry.m_122961_(PROPERTIES, (String)"redstone_north", (Object)BlockStateProperties.f_61383_);
        Registry.m_122961_(PROPERTIES, (String)"redstone_south", (Object)BlockStateProperties.f_61384_);
        Registry.m_122961_(PROPERTIES, (String)"redstone_west", (Object)BlockStateProperties.f_61385_);
        Registry.m_122961_(PROPERTIES, (String)"double_block_half", (Object)BlockStateProperties.f_61401_);
        Registry.m_122961_(PROPERTIES, (String)"half", (Object)BlockStateProperties.f_61402_);
        Registry.m_122961_(PROPERTIES, (String)"rail_shape", (Object)BlockStateProperties.f_61403_);
        Registry.m_122961_(PROPERTIES, (String)"rail_shape_straight", (Object)BlockStateProperties.f_61404_);
        Registry.m_122961_(PROPERTIES, (String)"age_0_1", (Object)BlockStateProperties.f_61405_);
        Registry.m_122961_(PROPERTIES, (String)"age_0_2", (Object)BlockStateProperties.f_61406_);
        Registry.m_122961_(PROPERTIES, (String)"age_0_3", (Object)BlockStateProperties.f_61407_);
        Registry.m_122961_(PROPERTIES, (String)"age_0_4", (Object)BlockStateProperties.f_222999_);
        Registry.m_122961_(PROPERTIES, (String)"age_0_5", (Object)BlockStateProperties.f_61408_);
        Registry.m_122961_(PROPERTIES, (String)"age_0_7", (Object)BlockStateProperties.f_61409_);
        Registry.m_122961_(PROPERTIES, (String)"age_0_15", (Object)BlockStateProperties.f_61410_);
        Registry.m_122961_(PROPERTIES, (String)"age_0_25", (Object)BlockStateProperties.f_61411_);
        Registry.m_122961_(PROPERTIES, (String)"bites_0_6", (Object)BlockStateProperties.f_61412_);
        Registry.m_122961_(PROPERTIES, (String)"candles", (Object)BlockStateProperties.f_155994_);
        Registry.m_122961_(PROPERTIES, (String)"delay_1_4", (Object)BlockStateProperties.f_61413_);
        Registry.m_122961_(PROPERTIES, (String)"distance_1_7", (Object)BlockStateProperties.f_61414_);
        Registry.m_122961_(PROPERTIES, (String)"eggs_1_4", (Object)BlockStateProperties.f_61415_);
        Registry.m_122961_(PROPERTIES, (String)"hatch_0_2", (Object)BlockStateProperties.f_61416_);
        Registry.m_122961_(PROPERTIES, (String)"layers_1_8", (Object)BlockStateProperties.f_61417_);
        Registry.m_122961_(PROPERTIES, (String)"level_0_3", (Object)BlockStateProperties.f_61418_);
        Registry.m_122961_(PROPERTIES, (String)"level_0_8", (Object)BlockStateProperties.f_61419_);
        Registry.m_122961_(PROPERTIES, (String)"level_1_8", (Object)BlockStateProperties.f_61420_);
        Registry.m_122961_(PROPERTIES, (String)"honey_level", (Object)BlockStateProperties.f_61421_);
        Registry.m_122961_(PROPERTIES, (String)"level_0_15", (Object)BlockStateProperties.f_61422_);
        Registry.m_122961_(PROPERTIES, (String)"moisture_0_7", (Object)BlockStateProperties.f_61423_);
        Registry.m_122961_(PROPERTIES, (String)"note_0_24", (Object)BlockStateProperties.f_61424_);
        Registry.m_122961_(PROPERTIES, (String)"pickles_1_4", (Object)BlockStateProperties.f_61425_);
        Registry.m_122961_(PROPERTIES, (String)"power_0_15", (Object)BlockStateProperties.f_61426_);
        Registry.m_122961_(PROPERTIES, (String)"stage_0_1", (Object)BlockStateProperties.f_61387_);
        Registry.m_122961_(PROPERTIES, (String)"distance_0_7", (Object)BlockStateProperties.f_61388_);
        Registry.m_122961_(PROPERTIES, (String)"charges", (Object)BlockStateProperties.f_61389_);
        Registry.m_122961_(PROPERTIES, (String)"rotation_0_15", (Object)BlockStateProperties.f_61390_);
        Registry.m_122961_(PROPERTIES, (String)"bed_part", (Object)BlockStateProperties.f_61391_);
        Registry.m_122961_(PROPERTIES, (String)"chest_type", (Object)BlockStateProperties.f_61392_);
        Registry.m_122961_(PROPERTIES, (String)"comparator_mode", (Object)BlockStateProperties.f_61393_);
        Registry.m_122961_(PROPERTIES, (String)"door_hinge", (Object)BlockStateProperties.f_61394_);
        Registry.m_122961_(PROPERTIES, (String)"note_block_instrument", (Object)BlockStateProperties.f_61395_);
        Registry.m_122961_(PROPERTIES, (String)"piston_type", (Object)BlockStateProperties.f_61396_);
        Registry.m_122961_(PROPERTIES, (String)"slab_type", (Object)BlockStateProperties.f_61397_);
        Registry.m_122961_(PROPERTIES, (String)"stairs_shape", (Object)BlockStateProperties.f_61398_);
        Registry.m_122961_(PROPERTIES, (String)"structure_block_mode", (Object)BlockStateProperties.f_61399_);
        Registry.m_122961_(PROPERTIES, (String)"bamboo_leaves", (Object)BlockStateProperties.f_61400_);
        Registry.m_122961_(PROPERTIES, (String)"tilt", (Object)BlockStateProperties.f_155996_);
        Registry.m_122961_(PROPERTIES, (String)"vertical_direction", (Object)BlockStateProperties.f_155997_);
        Registry.m_122961_(PROPERTIES, (String)"dripstone_thickness", (Object)BlockStateProperties.f_155998_);
        Registry.m_122961_(PROPERTIES, (String)"sculk_sensor_phase", (Object)BlockStateProperties.f_155999_);
        Registry.m_122961_(PROPERTIES, (String)"chiseled_bookshelf_slot_0_occupied", (Object)BlockStateProperties.f_260472_);
        Registry.m_122961_(PROPERTIES, (String)"chiseled_bookshelf_slot_1_occupied", (Object)BlockStateProperties.f_260553_);
        Registry.m_122961_(PROPERTIES, (String)"chiseled_bookshelf_slot_2_occupied", (Object)BlockStateProperties.f_260538_);
        Registry.m_122961_(PROPERTIES, (String)"chiseled_bookshelf_slot_3_occupied", (Object)BlockStateProperties.f_260590_);
        Registry.m_122961_(PROPERTIES, (String)"chiseled_bookshelf_slot_4_occupied", (Object)BlockStateProperties.f_260519_);
        Registry.m_122961_(PROPERTIES, (String)"chiseled_bookshelf_slot_5_occupied", (Object)BlockStateProperties.f_260439_);
        Registry.m_122961_(PROPERTIES, (String)"dusted", (Object)BlockStateProperties.f_271112_);
    }

    private static void registerFoods() {
        Registry.m_122961_(FOODS, (String)"apple", (Object)Foods.f_38810_);
        Registry.m_122961_(FOODS, (String)"baked_potato", (Object)Foods.f_38811_);
        Registry.m_122961_(FOODS, (String)"beef", (Object)Foods.f_38812_);
        Registry.m_122961_(FOODS, (String)"beetroot", (Object)Foods.f_38813_);
        Registry.m_122961_(FOODS, (String)"beetroot_soup", (Object)Foods.f_38814_);
        Registry.m_122961_(FOODS, (String)"bread", (Object)Foods.f_38815_);
        Registry.m_122961_(FOODS, (String)"carrot", (Object)Foods.f_38816_);
        Registry.m_122961_(FOODS, (String)"chicken", (Object)Foods.f_38817_);
        Registry.m_122961_(FOODS, (String)"chorus_fruit", (Object)Foods.f_38818_);
        Registry.m_122961_(FOODS, (String)"cod", (Object)Foods.f_38819_);
        Registry.m_122961_(FOODS, (String)"cooked_beef", (Object)Foods.f_38820_);
        Registry.m_122961_(FOODS, (String)"cooked_chicken", (Object)Foods.f_38821_);
        Registry.m_122961_(FOODS, (String)"cooked_cod", (Object)Foods.f_38822_);
        Registry.m_122961_(FOODS, (String)"cooked_mutton", (Object)Foods.f_38823_);
        Registry.m_122961_(FOODS, (String)"cooked_porkchop", (Object)Foods.f_38824_);
        Registry.m_122961_(FOODS, (String)"cooked_rabbit", (Object)Foods.f_38825_);
        Registry.m_122961_(FOODS, (String)"cooked_salmon", (Object)Foods.f_38826_);
        Registry.m_122961_(FOODS, (String)"cookie", (Object)Foods.f_38827_);
        Registry.m_122961_(FOODS, (String)"dried_kelp", (Object)Foods.f_38828_);
        Registry.m_122961_(FOODS, (String)"enchanted_golden_apple", (Object)Foods.f_38829_);
        Registry.m_122961_(FOODS, (String)"golden_apple", (Object)Foods.f_38830_);
        Registry.m_122961_(FOODS, (String)"golden_carrot", (Object)Foods.f_38831_);
        Registry.m_122961_(FOODS, (String)"honey_bottle", (Object)Foods.f_38832_);
        Registry.m_122961_(FOODS, (String)"melon_slice", (Object)Foods.f_38833_);
        Registry.m_122961_(FOODS, (String)"mushroom_stew", (Object)Foods.f_38834_);
        Registry.m_122961_(FOODS, (String)"mutton", (Object)Foods.f_38835_);
        Registry.m_122961_(FOODS, (String)"poisonous_potato", (Object)Foods.f_38797_);
        Registry.m_122961_(FOODS, (String)"porkchop", (Object)Foods.f_38798_);
        Registry.m_122961_(FOODS, (String)"potato", (Object)Foods.f_38799_);
        Registry.m_122961_(FOODS, (String)"pufferfish", (Object)Foods.f_38800_);
        Registry.m_122961_(FOODS, (String)"pumpkin_pie", (Object)Foods.f_38801_);
        Registry.m_122961_(FOODS, (String)"rabbit", (Object)Foods.f_38802_);
        Registry.m_122961_(FOODS, (String)"rabbit_stew", (Object)Foods.f_38803_);
        Registry.m_122961_(FOODS, (String)"rotten_flesh", (Object)Foods.f_38804_);
        Registry.m_122961_(FOODS, (String)"salmon", (Object)Foods.f_38805_);
        Registry.m_122961_(FOODS, (String)"spider_eye", (Object)Foods.f_38806_);
        Registry.m_122961_(FOODS, (String)"suspicious_stew", (Object)Foods.f_38807_);
        Registry.m_122961_(FOODS, (String)"sweet_berries", (Object)Foods.f_38808_);
        Registry.m_122961_(FOODS, (String)"glow_berries", (Object)Foods.f_150381_);
        Registry.m_122961_(FOODS, (String)"tropical_fish", (Object)Foods.f_38809_);
    }

    private static void registerArmorMaterials() {
        for (ArmorMaterials mat : ArmorMaterials.values()) {
            Registry.m_122961_(ARMOR_MATERIALS, (String)mat.m_6082_(), (Object)mat);
        }
    }

    private static void registerSoundTypes() {
        Registry.m_122961_(SOUND_TYPES, (String)"wood", (Object)SoundType.f_56736_);
        Registry.m_122961_(SOUND_TYPES, (String)"gravel", (Object)SoundType.f_56739_);
        Registry.m_122961_(SOUND_TYPES, (String)"grass", (Object)SoundType.f_56740_);
        Registry.m_122961_(SOUND_TYPES, (String)"lily_pad", (Object)SoundType.f_56741_);
        Registry.m_122961_(SOUND_TYPES, (String)"stone", (Object)SoundType.f_56742_);
        Registry.m_122961_(SOUND_TYPES, (String)"metal", (Object)SoundType.f_56743_);
        Registry.m_122961_(SOUND_TYPES, (String)"glass", (Object)SoundType.f_56744_);
        Registry.m_122961_(SOUND_TYPES, (String)"wool", (Object)SoundType.f_56745_);
        Registry.m_122961_(SOUND_TYPES, (String)"sand", (Object)SoundType.f_56746_);
        Registry.m_122961_(SOUND_TYPES, (String)"snow", (Object)SoundType.f_56747_);
        Registry.m_122961_(SOUND_TYPES, (String)"powder_snow", (Object)SoundType.f_154681_);
        Registry.m_122961_(SOUND_TYPES, (String)"ladder", (Object)SoundType.f_56748_);
        Registry.m_122961_(SOUND_TYPES, (String)"anvil", (Object)SoundType.f_56749_);
        Registry.m_122961_(SOUND_TYPES, (String)"slime_block", (Object)SoundType.f_56750_);
        Registry.m_122961_(SOUND_TYPES, (String)"honey_block", (Object)SoundType.f_56751_);
        Registry.m_122961_(SOUND_TYPES, (String)"wet_grass", (Object)SoundType.f_56752_);
        Registry.m_122961_(SOUND_TYPES, (String)"coral_block", (Object)SoundType.f_56753_);
        Registry.m_122961_(SOUND_TYPES, (String)"bamboo", (Object)SoundType.f_56754_);
        Registry.m_122961_(SOUND_TYPES, (String)"bamboo_sapling", (Object)SoundType.f_56755_);
        Registry.m_122961_(SOUND_TYPES, (String)"scaffolding", (Object)SoundType.f_56756_);
        Registry.m_122961_(SOUND_TYPES, (String)"sweet_berry_bush", (Object)SoundType.f_56757_);
        Registry.m_122961_(SOUND_TYPES, (String)"crop", (Object)SoundType.f_56758_);
        Registry.m_122961_(SOUND_TYPES, (String)"hard_crop", (Object)SoundType.f_56759_);
        Registry.m_122961_(SOUND_TYPES, (String)"vine", (Object)SoundType.f_56760_);
        Registry.m_122961_(SOUND_TYPES, (String)"nether_wart", (Object)SoundType.f_56761_);
        Registry.m_122961_(SOUND_TYPES, (String)"lantern", (Object)SoundType.f_56762_);
        Registry.m_122961_(SOUND_TYPES, (String)"stem", (Object)SoundType.f_56763_);
        Registry.m_122961_(SOUND_TYPES, (String)"nylium", (Object)SoundType.f_56710_);
        Registry.m_122961_(SOUND_TYPES, (String)"fungus", (Object)SoundType.f_56711_);
        Registry.m_122961_(SOUND_TYPES, (String)"roots", (Object)SoundType.f_56712_);
        Registry.m_122961_(SOUND_TYPES, (String)"shroomlight", (Object)SoundType.f_56713_);
        Registry.m_122961_(SOUND_TYPES, (String)"weeping_vines", (Object)SoundType.f_56714_);
        Registry.m_122961_(SOUND_TYPES, (String)"twisting_vines", (Object)SoundType.f_56715_);
        Registry.m_122961_(SOUND_TYPES, (String)"soul_sand", (Object)SoundType.f_56716_);
        Registry.m_122961_(SOUND_TYPES, (String)"soul_soil", (Object)SoundType.f_56717_);
        Registry.m_122961_(SOUND_TYPES, (String)"basalt", (Object)SoundType.f_56718_);
        Registry.m_122961_(SOUND_TYPES, (String)"wart_block", (Object)SoundType.f_56719_);
        Registry.m_122961_(SOUND_TYPES, (String)"netherrack", (Object)SoundType.f_56720_);
        Registry.m_122961_(SOUND_TYPES, (String)"nether_bricks", (Object)SoundType.f_56721_);
        Registry.m_122961_(SOUND_TYPES, (String)"nether_sprouts", (Object)SoundType.f_56722_);
        Registry.m_122961_(SOUND_TYPES, (String)"nether_ore", (Object)SoundType.f_56723_);
        Registry.m_122961_(SOUND_TYPES, (String)"bone_block", (Object)SoundType.f_56724_);
        Registry.m_122961_(SOUND_TYPES, (String)"netherite_block", (Object)SoundType.f_56725_);
        Registry.m_122961_(SOUND_TYPES, (String)"ancient_debris", (Object)SoundType.f_56726_);
        Registry.m_122961_(SOUND_TYPES, (String)"lodestone", (Object)SoundType.f_56727_);
        Registry.m_122961_(SOUND_TYPES, (String)"chain", (Object)SoundType.f_56728_);
        Registry.m_122961_(SOUND_TYPES, (String)"nether_gold_ore", (Object)SoundType.f_56729_);
        Registry.m_122961_(SOUND_TYPES, (String)"gilded_blackstone", (Object)SoundType.f_56730_);
        Registry.m_122961_(SOUND_TYPES, (String)"candle", (Object)SoundType.f_154653_);
        Registry.m_122961_(SOUND_TYPES, (String)"amethyst", (Object)SoundType.f_154654_);
        Registry.m_122961_(SOUND_TYPES, (String)"amethyst_cluster", (Object)SoundType.f_154655_);
        Registry.m_122961_(SOUND_TYPES, (String)"small_amethyst_bud", (Object)SoundType.f_154656_);
        Registry.m_122961_(SOUND_TYPES, (String)"medium_amethyst_bud", (Object)SoundType.f_154657_);
        Registry.m_122961_(SOUND_TYPES, (String)"large_amethyst_bud", (Object)SoundType.f_154658_);
        Registry.m_122961_(SOUND_TYPES, (String)"tuff", (Object)SoundType.f_154659_);
        Registry.m_122961_(SOUND_TYPES, (String)"calcite", (Object)SoundType.f_154660_);
        Registry.m_122961_(SOUND_TYPES, (String)"dripstone_block", (Object)SoundType.f_154661_);
        Registry.m_122961_(SOUND_TYPES, (String)"pointed_dripstone", (Object)SoundType.f_154662_);
        Registry.m_122961_(SOUND_TYPES, (String)"copper", (Object)SoundType.f_154663_);
        Registry.m_122961_(SOUND_TYPES, (String)"cave_vines", (Object)SoundType.f_154664_);
        Registry.m_122961_(SOUND_TYPES, (String)"spore_blossom", (Object)SoundType.f_154665_);
        Registry.m_122961_(SOUND_TYPES, (String)"azalea", (Object)SoundType.f_154666_);
        Registry.m_122961_(SOUND_TYPES, (String)"flowering_azalea", (Object)SoundType.f_154667_);
        Registry.m_122961_(SOUND_TYPES, (String)"moss_carpet", (Object)SoundType.f_154668_);
        Registry.m_122961_(SOUND_TYPES, (String)"pink_petals", (Object)SoundType.f_271137_);
        Registry.m_122961_(SOUND_TYPES, (String)"moss", (Object)SoundType.f_154669_);
        Registry.m_122961_(SOUND_TYPES, (String)"big_dripleaf", (Object)SoundType.f_154670_);
        Registry.m_122961_(SOUND_TYPES, (String)"small_dripleaf", (Object)SoundType.f_154671_);
        Registry.m_122961_(SOUND_TYPES, (String)"rooted_dirt", (Object)SoundType.f_154672_);
        Registry.m_122961_(SOUND_TYPES, (String)"hanging_roots", (Object)SoundType.f_154673_);
        Registry.m_122961_(SOUND_TYPES, (String)"azalea_leaves", (Object)SoundType.f_154674_);
        Registry.m_122961_(SOUND_TYPES, (String)"sculk_sensor", (Object)SoundType.f_154675_);
        Registry.m_122961_(SOUND_TYPES, (String)"sculk_catalyst", (Object)SoundType.f_222472_);
        Registry.m_122961_(SOUND_TYPES, (String)"sculk", (Object)SoundType.f_222473_);
        Registry.m_122961_(SOUND_TYPES, (String)"sculk_vein", (Object)SoundType.f_222474_);
        Registry.m_122961_(SOUND_TYPES, (String)"sculk_shrieker", (Object)SoundType.f_222475_);
        Registry.m_122961_(SOUND_TYPES, (String)"glow_lichen", (Object)SoundType.f_154676_);
        Registry.m_122961_(SOUND_TYPES, (String)"deepslate", (Object)SoundType.f_154677_);
        Registry.m_122961_(SOUND_TYPES, (String)"deepslate_bricks", (Object)SoundType.f_154678_);
        Registry.m_122961_(SOUND_TYPES, (String)"deepslate_tiles", (Object)SoundType.f_154679_);
        Registry.m_122961_(SOUND_TYPES, (String)"polished_deepslate", (Object)SoundType.f_154680_);
        Registry.m_122961_(SOUND_TYPES, (String)"froglight", (Object)SoundType.f_222465_);
        Registry.m_122961_(SOUND_TYPES, (String)"frogspawn", (Object)SoundType.f_222466_);
        Registry.m_122961_(SOUND_TYPES, (String)"mangrove_roots", (Object)SoundType.f_222467_);
        Registry.m_122961_(SOUND_TYPES, (String)"muddy_mangrove_roots", (Object)SoundType.f_222468_);
        Registry.m_122961_(SOUND_TYPES, (String)"mud", (Object)SoundType.f_222469_);
        Registry.m_122961_(SOUND_TYPES, (String)"mud_bricks", (Object)SoundType.f_222470_);
        Registry.m_122961_(SOUND_TYPES, (String)"packed_mud", (Object)SoundType.f_222471_);
        Registry.m_122961_(SOUND_TYPES, (String)"hanging_sign", (Object)SoundType.f_244174_);
        Registry.m_122961_(SOUND_TYPES, (String)"nether_wood_hanging_sign", (Object)SoundType.f_256908_);
        Registry.m_122961_(SOUND_TYPES, (String)"bamboo_wood_hanging_sign", (Object)SoundType.f_256995_);
        Registry.m_122961_(SOUND_TYPES, (String)"bamboo_wood", (Object)SoundType.f_243772_);
        Registry.m_122961_(SOUND_TYPES, (String)"nether_wood", (Object)SoundType.f_244244_);
        Registry.m_122961_(SOUND_TYPES, (String)"cherry_wood", (Object)SoundType.f_271497_);
        Registry.m_122961_(SOUND_TYPES, (String)"cherry_sapling", (Object)SoundType.f_271370_);
        Registry.m_122961_(SOUND_TYPES, (String)"cherry_leaves", (Object)SoundType.f_271239_);
        Registry.m_122961_(SOUND_TYPES, (String)"cherry_wood_hanging_sign", (Object)SoundType.f_271094_);
        Registry.m_122961_(SOUND_TYPES, (String)"chiseled_bookshelf", (Object)SoundType.f_256956_);
        Registry.m_122961_(SOUND_TYPES, (String)"suspicious_sand", (Object)SoundType.f_271168_);
        Registry.m_122961_(SOUND_TYPES, (String)"decorated_pot", (Object)SoundType.f_271215_);
    }

    static {
        ThingRegistries.registerArmorMaterials();
        ThingRegistries.registerFoods();
        ThingRegistries.registerProperties();
        ThingRegistries.registerDynamicShapes();
        ThingRegistries.registerSoundTypes();
        PropertyTypes.init();
        FlexBlockType.init();
        FlexItemType.init();
        MapColors.init();
        FlexFluidType.init();
    }
}

