/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class SmithingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object template;
    public final Object base;
    public final Object addition;
    public final Object output;
    public final int count;

    public SmithingRecipeSerializer(ResourceLocation key, Object template, Object base, Object addition, Object output, int count) {
        this.key = Objects.requireNonNull(key);
        this.template = template;
        this.base = base;
        this.addition = addition;
        this.output = output;
        this.count = count;
    }

    @Override
    public JsonElement get() {
        Ingredient templateIng = MiscHelper.INSTANCE.getIngredient(this.template);
        if (templateIng == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.template);
        }
        Ingredient baseIng = MiscHelper.INSTANCE.getIngredient(this.base);
        if (baseIng == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.base);
        }
        Ingredient additionIng = MiscHelper.INSTANCE.getIngredient(this.addition);
        if (additionIng == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.addition);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.count);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "minecraft:smithing");
        json.add("template", templateIng.m_43942_());
        json.add("base", baseIng.m_43942_());
        json.add("addition", additionIng.m_43942_());
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        return json;
    }
}

