/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.fluids;

import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import thelm.jaopca.api.fluids.IBucketItemCreator;
import thelm.jaopca.api.fluids.IFluidBlockCreator;
import thelm.jaopca.api.fluids.IFluidCreator;
import thelm.jaopca.api.fluids.IFluidFormSettings;
import thelm.jaopca.api.fluids.IFluidTypeCreator;
import thelm.jaopca.api.forms.IFormType;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.fluids.FluidFormType;
import thelm.jaopca.fluids.JAOPCABucketItem;
import thelm.jaopca.fluids.JAOPCAFluid;
import thelm.jaopca.fluids.JAOPCAFluidBlock;
import thelm.jaopca.fluids.JAOPCAFluidType;

class FluidFormSettings
implements IFluidFormSettings {
    private IFluidCreator fluidCreator = JAOPCAFluid::new;
    private ToIntFunction<IMaterial> maxLevelFunction = material -> 8;
    private ToIntFunction<IMaterial> tickRateFunction = material -> 5;
    private ToDoubleFunction<IMaterial> explosionResistanceFunction = material -> 100.0;
    private IFluidTypeCreator fluidTypeCreator = JAOPCAFluidType::new;
    private ToIntFunction<IMaterial> lightValueFunction = material -> 0;
    private ToIntFunction<IMaterial> densityFunction = material -> 1000;
    private ToIntFunction<IMaterial> temperatureFunction = material -> 300;
    private ToIntFunction<IMaterial> viscosityFunction = material -> this.tickRateFunction.applyAsInt((IMaterial)material) * 200;
    private Function<IMaterial, Rarity> displayRarityFunction = material -> Rarity.COMMON;
    private Supplier<SoundEvent> fillSoundSupplier = () -> SoundEvents.f_11781_;
    private Supplier<SoundEvent> emptySoundSupplier = () -> SoundEvents.f_11778_;
    private Supplier<SoundEvent> vaporizeSoundSupplier = () -> SoundEvents.f_11937_;
    private ToDoubleFunction<IMaterial> motionScaleFunction = material -> 0.014;
    private Predicate<IMaterial> canPushEntityFunction = material -> true;
    private Predicate<IMaterial> canSwimFunction = material -> true;
    private ToDoubleFunction<IMaterial> fallDistanceModifierFunction = material -> 0.5;
    private Predicate<IMaterial> canExtinguishFunction = material -> false;
    private Predicate<IMaterial> canDrownFunction = material -> true;
    private Predicate<IMaterial> supportsBoatingFunction = material -> false;
    private Predicate<IMaterial> canHydrateFunction = material -> false;
    private Predicate<IMaterial> canConvertToSourceFunction = material -> false;
    private Function<IMaterial, BlockPathTypes> pathTypeFunction = material -> BlockPathTypes.WATER;
    private Function<IMaterial, BlockPathTypes> adjacentPathTypeFunction = material -> BlockPathTypes.WATER_BORDER;
    private IFluidBlockCreator fluidBlockCreator = JAOPCAFluidBlock::new;
    private ToIntFunction<IMaterial> levelDecreasePerBlockFunction = material -> 1;
    private Function<IMaterial, MapColor> mapColorFunction = material -> MapColor.f_283864_;
    private ToDoubleFunction<IMaterial> blockHardnessFunction = material -> 100.0;
    private ToIntFunction<IMaterial> flammabilityFunction = material -> 0;
    private ToIntFunction<IMaterial> fireSpreadSpeedFunction = material -> 0;
    private Predicate<IMaterial> isFireSourceFunction = material -> false;
    private ToIntFunction<IMaterial> fireTimeFunction = material -> -1;
    private IBucketItemCreator bucketItemCreator = JAOPCABucketItem::new;
    private ToIntFunction<IMaterial> maxStackSizeFunction = material -> 1;
    private Predicate<IMaterial> hasEffectFunction = material -> material.hasEffect();
    private ToIntFunction<IMaterial> burnTimeFunction = material -> -1;

    FluidFormSettings() {
    }

    @Override
    public IFormType getType() {
        return FluidFormType.INSTANCE;
    }

    @Override
    public IFluidFormSettings setFluidCreator(IFluidCreator fluidCreator) {
        this.fluidCreator = fluidCreator;
        return this;
    }

    @Override
    public IFluidCreator getFluidCreator() {
        return this.fluidCreator;
    }

    @Override
    public IFluidFormSettings setMaxLevelFunction(ToIntFunction<IMaterial> maxLevelFunction) {
        this.maxLevelFunction = maxLevelFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getMaxLevelFunction() {
        return this.maxLevelFunction;
    }

    @Override
    public IFluidFormSettings setTickRateFunction(ToIntFunction<IMaterial> tickRateFunction) {
        this.tickRateFunction = tickRateFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getTickRateFunction() {
        return this.tickRateFunction;
    }

    @Override
    public IFluidFormSettings setExplosionResistanceFunction(ToDoubleFunction<IMaterial> explosionResistanceFunction) {
        this.explosionResistanceFunction = explosionResistanceFunction;
        return this;
    }

    @Override
    public ToDoubleFunction<IMaterial> getExplosionResistanceFunction() {
        return this.explosionResistanceFunction;
    }

    @Override
    public IFluidFormSettings setFluidTypeCreator(IFluidTypeCreator fluidTypeCreator) {
        this.fluidTypeCreator = fluidTypeCreator;
        return this;
    }

    @Override
    public IFluidTypeCreator getFluidTypeCreator() {
        return this.fluidTypeCreator;
    }

    @Override
    public IFluidFormSettings setDensityFunction(ToIntFunction<IMaterial> densityFunction) {
        this.densityFunction = densityFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getDensityFunction() {
        return this.densityFunction;
    }

    @Override
    public IFluidFormSettings setViscosityFunction(ToIntFunction<IMaterial> viscosityFunction) {
        this.viscosityFunction = viscosityFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getViscosityFunction() {
        return this.viscosityFunction;
    }

    @Override
    public IFluidFormSettings setTemperatureFunction(ToIntFunction<IMaterial> temperatureFunction) {
        this.temperatureFunction = temperatureFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getTemperatureFunction() {
        return this.temperatureFunction;
    }

    @Override
    public IFluidFormSettings setDisplayRarityFunction(Function<IMaterial, Rarity> displayRarityFunction) {
        this.displayRarityFunction = displayRarityFunction;
        return this;
    }

    @Override
    public Function<IMaterial, Rarity> getDisplayRarityFunction() {
        return this.displayRarityFunction;
    }

    @Override
    public IFluidFormSettings setFillSoundSupplier(Supplier<SoundEvent> fillSoundSupplier) {
        this.fillSoundSupplier = fillSoundSupplier;
        return this;
    }

    @Override
    public Supplier<SoundEvent> getFillSoundSupplier() {
        return this.fillSoundSupplier;
    }

    @Override
    public IFluidFormSettings setEmptySoundSupplier(Supplier<SoundEvent> emptySoundSupplier) {
        this.emptySoundSupplier = emptySoundSupplier;
        return this;
    }

    @Override
    public Supplier<SoundEvent> getEmptySoundSupplier() {
        return this.emptySoundSupplier;
    }

    @Override
    public IFluidFormSettings setVaporizeSoundSupplier(Supplier<SoundEvent> vaporizeSoundSupplier) {
        this.vaporizeSoundSupplier = vaporizeSoundSupplier;
        return this;
    }

    @Override
    public Supplier<SoundEvent> getVaporizeSoundSupplier() {
        return this.vaporizeSoundSupplier;
    }

    @Override
    public IFluidFormSettings setMotionScaleFunction(ToDoubleFunction<IMaterial> motionScaleFunction) {
        this.motionScaleFunction = motionScaleFunction;
        return this;
    }

    @Override
    public ToDoubleFunction<IMaterial> getMotionScaleFunction() {
        return this.motionScaleFunction;
    }

    @Override
    public IFluidFormSettings setCanPushEntityFunction(Predicate<IMaterial> canPushEntityFunction) {
        this.canPushEntityFunction = canPushEntityFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getCanPushEntityFunction() {
        return this.canPushEntityFunction;
    }

    @Override
    public IFluidFormSettings setCanSwimFunction(Predicate<IMaterial> canSwimFunction) {
        this.canSwimFunction = canSwimFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getCanSwimFunction() {
        return this.canSwimFunction;
    }

    @Override
    public IFluidFormSettings setFallDistanceModifierFunction(ToDoubleFunction<IMaterial> fallDistanceModifierFunction) {
        this.fallDistanceModifierFunction = fallDistanceModifierFunction;
        return this;
    }

    @Override
    public ToDoubleFunction<IMaterial> getFallDistanceModifierFunction() {
        return this.fallDistanceModifierFunction;
    }

    @Override
    public IFluidFormSettings setCanExtinguishFunction(Predicate<IMaterial> canExtinguishFunction) {
        this.canExtinguishFunction = canExtinguishFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getCanExtinguishFunction() {
        return this.canExtinguishFunction;
    }

    @Override
    public IFluidFormSettings setCanDrownFunction(Predicate<IMaterial> canDrownFunction) {
        this.canDrownFunction = canDrownFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getCanDrownFunction() {
        return this.canDrownFunction;
    }

    @Override
    public IFluidFormSettings setSupportsBoatingFunction(Predicate<IMaterial> supportsBoatingFunction) {
        this.supportsBoatingFunction = supportsBoatingFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getSupportsBoatingFunction() {
        return this.supportsBoatingFunction;
    }

    @Override
    public IFluidFormSettings setCanHydrateFunction(Predicate<IMaterial> canHydrateFunction) {
        this.canHydrateFunction = canHydrateFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getCanHydrateFunction() {
        return this.canHydrateFunction;
    }

    @Override
    public IFluidFormSettings setCanConvertToSourceFunction(Predicate<IMaterial> canConvertToSourceFunction) {
        this.canConvertToSourceFunction = canConvertToSourceFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getCanConvertToSourceFunction() {
        return this.canConvertToSourceFunction;
    }

    @Override
    public IFluidFormSettings setPathTypeFunction(Function<IMaterial, BlockPathTypes> pathTypeFunction) {
        this.pathTypeFunction = pathTypeFunction;
        return this;
    }

    @Override
    public Function<IMaterial, BlockPathTypes> getPathTypeFunction() {
        return this.pathTypeFunction;
    }

    @Override
    public IFluidFormSettings setAdjacentPathTypeFunction(Function<IMaterial, BlockPathTypes> adjacentPathTypeFunction) {
        this.adjacentPathTypeFunction = adjacentPathTypeFunction;
        return this;
    }

    @Override
    public Function<IMaterial, BlockPathTypes> getAdjacentPathTypeFunction() {
        return this.adjacentPathTypeFunction;
    }

    @Override
    public IFluidFormSettings setFluidBlockCreator(IFluidBlockCreator fluidBlockCreator) {
        this.fluidBlockCreator = fluidBlockCreator;
        return this;
    }

    @Override
    public IFluidBlockCreator getFluidBlockCreator() {
        return this.fluidBlockCreator;
    }

    @Override
    public IFluidFormSettings setLevelDecreasePerBlockFunction(ToIntFunction<IMaterial> levelDecreasePerBlockFunction) {
        this.levelDecreasePerBlockFunction = levelDecreasePerBlockFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getLevelDecreasePerBlockFunction() {
        return this.levelDecreasePerBlockFunction;
    }

    @Override
    public IFluidFormSettings setMapColorFunction(Function<IMaterial, MapColor> mapColorFunction) {
        this.mapColorFunction = mapColorFunction;
        return this;
    }

    @Override
    public Function<IMaterial, MapColor> getMapColorFunction() {
        return this.mapColorFunction;
    }

    @Override
    public IFluidFormSettings setLightValueFunction(ToIntFunction<IMaterial> lightValueFunction) {
        this.lightValueFunction = lightValueFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getLightValueFunction() {
        return this.lightValueFunction;
    }

    @Override
    public IFluidFormSettings setBlockHardnessFunction(ToDoubleFunction<IMaterial> blockHardnessFunction) {
        this.blockHardnessFunction = blockHardnessFunction;
        return this;
    }

    @Override
    public ToDoubleFunction<IMaterial> getBlockHardnessFunction() {
        return this.blockHardnessFunction;
    }

    @Override
    public IFluidFormSettings setFlammabilityFunction(ToIntFunction<IMaterial> flammabilityFunction) {
        this.flammabilityFunction = flammabilityFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getFlammabilityFunction() {
        return this.flammabilityFunction;
    }

    @Override
    public IFluidFormSettings setFireSpreadSpeedFunction(ToIntFunction<IMaterial> fireSpreadSpeedFunction) {
        this.fireSpreadSpeedFunction = fireSpreadSpeedFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getFireSpreadSpeedFunction() {
        return this.fireSpreadSpeedFunction;
    }

    @Override
    public IFluidFormSettings setIsFireSourceFunction(Predicate<IMaterial> isFireSourceFunction) {
        this.isFireSourceFunction = isFireSourceFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getIsFireSourceFunction() {
        return this.isFireSourceFunction;
    }

    @Override
    public IFluidFormSettings setFireTimeFunction(ToIntFunction<IMaterial> fireTimeFunction) {
        this.fireTimeFunction = fireTimeFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getFireTimeFunction() {
        return this.fireTimeFunction;
    }

    @Override
    public IFluidFormSettings setBucketItemCreator(IBucketItemCreator bucketItemCreator) {
        this.bucketItemCreator = bucketItemCreator;
        return this;
    }

    @Override
    public IBucketItemCreator getBucketItemCreator() {
        return this.bucketItemCreator;
    }

    @Override
    public IFluidFormSettings setMaxStackSizeFunction(ToIntFunction<IMaterial> maxStackSizeFunction) {
        this.maxStackSizeFunction = maxStackSizeFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getMaxStackSizeFunction() {
        return this.maxStackSizeFunction;
    }

    @Override
    public IFluidFormSettings setHasEffectFunction(Predicate<IMaterial> hasEffectFunction) {
        this.hasEffectFunction = hasEffectFunction;
        return this;
    }

    @Override
    public Predicate<IMaterial> getHasEffectFunction() {
        return this.hasEffectFunction;
    }

    @Override
    public IFluidFormSettings setBurnTimeFunction(ToIntFunction<IMaterial> burnTimeFunction) {
        this.burnTimeFunction = burnTimeFunction;
        return this;
    }

    @Override
    public ToIntFunction<IMaterial> getBurnTimeFunction() {
        return this.burnTimeFunction;
    }
}

