/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.custom.utils;

import com.google.common.collect.HashBiMap;
import java.util.Locale;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.material.MapColor;

public class BlockDeserializationHelper {
    public static final BlockDeserializationHelper INSTANCE = new BlockDeserializationHelper();
    private static final HashBiMap<String, MapColor> MAP_COLORS = HashBiMap.create();
    private static final HashBiMap<String, SoundType> SOUND_TYPES = HashBiMap.create();

    private BlockDeserializationHelper() {
    }

    public MapColor getMapColor(String name) {
        return (MapColor)MAP_COLORS.get((Object)name.toLowerCase(Locale.US));
    }

    public String getMapColorName(MapColor color) {
        return (String)MAP_COLORS.inverse().get((Object)color);
    }

    public void putMapColor(String name, MapColor color) {
        MAP_COLORS.put((Object)name.toLowerCase(Locale.US), (Object)color);
    }

    public SoundType getSoundType(String name) {
        return (SoundType)SOUND_TYPES.get((Object)name.toLowerCase(Locale.US));
    }

    public String getSoundTypeName(SoundType sound) {
        return (String)SOUND_TYPES.inverse().get((Object)sound);
    }

    public void putSoundType(String name, SoundType sound) {
        SOUND_TYPES.put((Object)name.toLowerCase(Locale.US), (Object)sound);
    }

    static {
        INSTANCE.putMapColor("none", MapColor.f_283808_);
        INSTANCE.putMapColor("grass", MapColor.f_283824_);
        INSTANCE.putMapColor("sand", MapColor.f_283761_);
        INSTANCE.putMapColor("wool", MapColor.f_283930_);
        INSTANCE.putMapColor("fire", MapColor.f_283816_);
        INSTANCE.putMapColor("ice", MapColor.f_283828_);
        INSTANCE.putMapColor("metal", MapColor.f_283906_);
        INSTANCE.putMapColor("plant", MapColor.f_283915_);
        INSTANCE.putMapColor("snow", MapColor.f_283811_);
        INSTANCE.putMapColor("clay", MapColor.f_283744_);
        INSTANCE.putMapColor("dirt", MapColor.f_283762_);
        INSTANCE.putMapColor("stone", MapColor.f_283947_);
        INSTANCE.putMapColor("water", MapColor.f_283864_);
        INSTANCE.putMapColor("wood", MapColor.f_283825_);
        INSTANCE.putMapColor("quartz", MapColor.f_283942_);
        INSTANCE.putMapColor("color_orange", MapColor.f_283750_);
        INSTANCE.putMapColor("color_magenta", MapColor.f_283931_);
        INSTANCE.putMapColor("color_light_blue", MapColor.f_283869_);
        INSTANCE.putMapColor("color_yellow", MapColor.f_283832_);
        INSTANCE.putMapColor("color_light_green", MapColor.f_283916_);
        INSTANCE.putMapColor("color_pink", MapColor.f_283765_);
        INSTANCE.putMapColor("color_gray", MapColor.f_283818_);
        INSTANCE.putMapColor("color_light_gray", MapColor.f_283779_);
        INSTANCE.putMapColor("color_cyan", MapColor.f_283772_);
        INSTANCE.putMapColor("color_purple", MapColor.f_283889_);
        INSTANCE.putMapColor("color_blue", MapColor.f_283743_);
        INSTANCE.putMapColor("color_brown", MapColor.f_283748_);
        INSTANCE.putMapColor("color_green", MapColor.f_283784_);
        INSTANCE.putMapColor("color_red", MapColor.f_283913_);
        INSTANCE.putMapColor("color_black", MapColor.f_283927_);
        INSTANCE.putMapColor("gold", MapColor.f_283757_);
        INSTANCE.putMapColor("diamond", MapColor.f_283821_);
        INSTANCE.putMapColor("lapis", MapColor.f_283933_);
        INSTANCE.putMapColor("emerald", MapColor.f_283812_);
        INSTANCE.putMapColor("podzol", MapColor.f_283819_);
        INSTANCE.putMapColor("nether", MapColor.f_283820_);
        INSTANCE.putMapColor("terracotta_white", MapColor.f_283919_);
        INSTANCE.putMapColor("terracotta_orange", MapColor.f_283895_);
        INSTANCE.putMapColor("terracotta_magenta", MapColor.f_283850_);
        INSTANCE.putMapColor("terracotta_light_blue", MapColor.f_283791_);
        INSTANCE.putMapColor("terracotta_yellow", MapColor.f_283843_);
        INSTANCE.putMapColor("terracotta_light_green", MapColor.f_283778_);
        INSTANCE.putMapColor("terracotta_pink", MapColor.f_283870_);
        INSTANCE.putMapColor("terracotta_gray", MapColor.f_283861_);
        INSTANCE.putMapColor("terracotta_light_gray", MapColor.f_283907_);
        INSTANCE.putMapColor("terracotta_cyan", MapColor.f_283846_);
        INSTANCE.putMapColor("terracotta_purple", MapColor.f_283892_);
        INSTANCE.putMapColor("terracotta_blue", MapColor.f_283908_);
        INSTANCE.putMapColor("terracotta_brown", MapColor.f_283774_);
        INSTANCE.putMapColor("terracotta_green", MapColor.f_283856_);
        INSTANCE.putMapColor("terracotta_red", MapColor.f_283798_);
        INSTANCE.putMapColor("terracotta_black", MapColor.f_283771_);
        INSTANCE.putMapColor("crimson_nylium", MapColor.f_283909_);
        INSTANCE.putMapColor("crimson_stem", MapColor.f_283804_);
        INSTANCE.putMapColor("crimson_hyphae", MapColor.f_283883_);
        INSTANCE.putMapColor("warped_nylium", MapColor.f_283745_);
        INSTANCE.putMapColor("warped_stem", MapColor.f_283749_);
        INSTANCE.putMapColor("warped_hyphae", MapColor.f_283807_);
        INSTANCE.putMapColor("warped_wart_block", MapColor.f_283898_);
        INSTANCE.putMapColor("deepslate", MapColor.f_283875_);
        INSTANCE.putMapColor("raw_iron", MapColor.f_283877_);
        INSTANCE.putMapColor("glow_lichen", MapColor.f_283769_);
        INSTANCE.putSoundType("empty", SoundType.f_279557_);
        INSTANCE.putSoundType("wood", SoundType.f_56736_);
        INSTANCE.putSoundType("gravel", SoundType.f_56739_);
        INSTANCE.putSoundType("grass", SoundType.f_56740_);
        INSTANCE.putSoundType("lily_pad", SoundType.f_56741_);
        INSTANCE.putSoundType("stone", SoundType.f_56742_);
        INSTANCE.putSoundType("metal", SoundType.f_56743_);
        INSTANCE.putSoundType("glass", SoundType.f_56744_);
        INSTANCE.putSoundType("wool", SoundType.f_56745_);
        INSTANCE.putSoundType("sand", SoundType.f_56746_);
        INSTANCE.putSoundType("snow", SoundType.f_56747_);
        INSTANCE.putSoundType("powder_snow", SoundType.f_154681_);
        INSTANCE.putSoundType("ladder", SoundType.f_56748_);
        INSTANCE.putSoundType("anvil", SoundType.f_56749_);
        INSTANCE.putSoundType("slime_block", SoundType.f_56750_);
        INSTANCE.putSoundType("honey_block", SoundType.f_56751_);
        INSTANCE.putSoundType("wet_grass", SoundType.f_56752_);
        INSTANCE.putSoundType("coral_block", SoundType.f_56753_);
        INSTANCE.putSoundType("bamboo", SoundType.f_56754_);
        INSTANCE.putSoundType("bamboo_sapling", SoundType.f_56755_);
        INSTANCE.putSoundType("scaffolding", SoundType.f_56756_);
        INSTANCE.putSoundType("sweet_berry_bush", SoundType.f_56757_);
        INSTANCE.putSoundType("crop", SoundType.f_56758_);
        INSTANCE.putSoundType("hard_crop", SoundType.f_56759_);
        INSTANCE.putSoundType("vine", SoundType.f_56760_);
        INSTANCE.putSoundType("nether_wart", SoundType.f_56761_);
        INSTANCE.putSoundType("lantern", SoundType.f_56762_);
        INSTANCE.putSoundType("stem", SoundType.f_56763_);
        INSTANCE.putSoundType("nylium", SoundType.f_56710_);
        INSTANCE.putSoundType("fungus", SoundType.f_56711_);
        INSTANCE.putSoundType("roots", SoundType.f_56712_);
        INSTANCE.putSoundType("shroomlight", SoundType.f_56713_);
        INSTANCE.putSoundType("weeping_vines", SoundType.f_56714_);
        INSTANCE.putSoundType("twisting_vines", SoundType.f_56715_);
        INSTANCE.putSoundType("soul_sand", SoundType.f_56716_);
        INSTANCE.putSoundType("soul_soil", SoundType.f_56717_);
        INSTANCE.putSoundType("basalt", SoundType.f_56718_);
        INSTANCE.putSoundType("wart_block", SoundType.f_56719_);
        INSTANCE.putSoundType("netherrack", SoundType.f_56720_);
        INSTANCE.putSoundType("nether_bricks", SoundType.f_56721_);
        INSTANCE.putSoundType("nether_sprouts", SoundType.f_56722_);
        INSTANCE.putSoundType("nether_ore", SoundType.f_56723_);
        INSTANCE.putSoundType("bone_block", SoundType.f_56724_);
        INSTANCE.putSoundType("netherite_block", SoundType.f_56725_);
        INSTANCE.putSoundType("ancient_debris", SoundType.f_56726_);
        INSTANCE.putSoundType("lodestone", SoundType.f_56727_);
        INSTANCE.putSoundType("chain", SoundType.f_56728_);
        INSTANCE.putSoundType("nether_gold_ore", SoundType.f_56729_);
        INSTANCE.putSoundType("gilded_blackstone", SoundType.f_56730_);
        INSTANCE.putSoundType("candle", SoundType.f_154653_);
        INSTANCE.putSoundType("amethyst", SoundType.f_154654_);
        INSTANCE.putSoundType("amethyst_cluster", SoundType.f_154655_);
        INSTANCE.putSoundType("small_amethyst_bud", SoundType.f_154656_);
        INSTANCE.putSoundType("medium_amethyst_bud", SoundType.f_154657_);
        INSTANCE.putSoundType("large_amethyst_bud", SoundType.f_154658_);
        INSTANCE.putSoundType("tuff", SoundType.f_154659_);
        INSTANCE.putSoundType("calcite", SoundType.f_154660_);
        INSTANCE.putSoundType("dripstone_block", SoundType.f_154661_);
        INSTANCE.putSoundType("pointed_dripstone", SoundType.f_154662_);
        INSTANCE.putSoundType("copper", SoundType.f_154663_);
        INSTANCE.putSoundType("cave_vines", SoundType.f_154664_);
        INSTANCE.putSoundType("spore_blossom", SoundType.f_154665_);
        INSTANCE.putSoundType("azalea", SoundType.f_154666_);
        INSTANCE.putSoundType("flowering_azalea", SoundType.f_154667_);
        INSTANCE.putSoundType("moss_carpet", SoundType.f_154668_);
        INSTANCE.putSoundType("pink_petals", SoundType.f_271137_);
        INSTANCE.putSoundType("moss", SoundType.f_154669_);
        INSTANCE.putSoundType("big_dripleaf", SoundType.f_154670_);
        INSTANCE.putSoundType("small_dripleaf", SoundType.f_154671_);
        INSTANCE.putSoundType("rooted_dirt", SoundType.f_154672_);
        INSTANCE.putSoundType("hanging_roots", SoundType.f_154673_);
        INSTANCE.putSoundType("azalea_leaves", SoundType.f_154674_);
        INSTANCE.putSoundType("sculk_sensor", SoundType.f_154675_);
        INSTANCE.putSoundType("sculk_catalyst", SoundType.f_222472_);
        INSTANCE.putSoundType("sculk", SoundType.f_222473_);
        INSTANCE.putSoundType("sculk_vein", SoundType.f_222474_);
        INSTANCE.putSoundType("sculk_shrieker", SoundType.f_222475_);
        INSTANCE.putSoundType("glow_lichen", SoundType.f_154676_);
        INSTANCE.putSoundType("deepslate", SoundType.f_154677_);
        INSTANCE.putSoundType("deepslate_bricks", SoundType.f_154678_);
        INSTANCE.putSoundType("deepslate_tiles", SoundType.f_154679_);
        INSTANCE.putSoundType("polished_deepslate", SoundType.f_154680_);
        INSTANCE.putSoundType("froglight", SoundType.f_222465_);
        INSTANCE.putSoundType("frogspawn", SoundType.f_222466_);
        INSTANCE.putSoundType("mangrove_roots", SoundType.f_222467_);
        INSTANCE.putSoundType("muddy_mangrove_roots", SoundType.f_222468_);
        INSTANCE.putSoundType("mud", SoundType.f_222469_);
        INSTANCE.putSoundType("mud_bricks", SoundType.f_222470_);
        INSTANCE.putSoundType("packed_mud", SoundType.f_222471_);
        INSTANCE.putSoundType("hanging_sign", SoundType.f_244174_);
        INSTANCE.putSoundType("nether_wood_hanging_sign", SoundType.f_256908_);
        INSTANCE.putSoundType("bamboo_wood_hanging_sign", SoundType.f_256995_);
        INSTANCE.putSoundType("bamboo_wood", SoundType.f_243772_);
        INSTANCE.putSoundType("nether_wood", SoundType.f_244244_);
        INSTANCE.putSoundType("cherry_wood", SoundType.f_271497_);
        INSTANCE.putSoundType("cherry_sapling", SoundType.f_271370_);
        INSTANCE.putSoundType("cherry_leaves", SoundType.f_271239_);
        INSTANCE.putSoundType("cherry_wood_hanging_sign", SoundType.f_271094_);
        INSTANCE.putSoundType("chiseled_bookshelf", SoundType.f_256956_);
        INSTANCE.putSoundType("suspicious_sand", SoundType.f_271168_);
        INSTANCE.putSoundType("suspicious_gravel", SoundType.f_276658_);
        INSTANCE.putSoundType("decorated_pot", SoundType.f_271215_);
        INSTANCE.putSoundType("decorated_pot_cracked", SoundType.f_276571_);
    }
}

