/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.config;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.electronwill.nightconfig.core.EnumGetMethod;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.utils.CommentedConfigWrapper;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.function.DoublePredicate;
import java.util.function.IntPredicate;
import java.util.function.LongPredicate;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.config.IDynamicSpecConfig;

public class DynamicSpecConfig
extends CommentedConfigWrapper<CommentedConfig>
implements IDynamicSpecConfig {
    private static final Logger LOGGER = LogManager.getLogger();
    final CommentedConfig config;

    public DynamicSpecConfig(CommentedConfig config) {
        super(config);
        this.config = config;
        if (config instanceof FileConfig) {
            FileConfig fileConfig = (FileConfig)config;
            try {
                fileConfig.load();
            }
            catch (ParsingException e) {
                Path path = fileConfig.getNioPath();
                LOGGER.warn("Config with path {} is malformed, moving", (Object)path);
                try {
                    Files.move(path, path.resolveSibling(path.getFileName() + ".bak"), StandardCopyOption.REPLACE_EXISTING);
                }
                catch (Exception e1) {
                    LOGGER.error("Unable to move config with path {}", (Object)path, (Object)e1);
                }
            }
        }
    }

    @Override
    public String getDefinedString(String path, String defaultValue, String comment) {
        return this.getDefinedString(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public String getDefinedString(List<String> path, String defaultValue, String comment) {
        return this.getDefinedString(path, defaultValue, (Predicate<String>)Predicates.alwaysTrue(), comment);
    }

    @Override
    public String getDefinedString(String path, String defaultValue, Collection<String> validValues, String comment) {
        return this.getDefinedString(DynamicSpecConfig.split(path), defaultValue, validValues, comment);
    }

    @Override
    public String getDefinedString(List<String> path, String defaultValue, Collection<String> validValues, String comment) {
        return this.getDefinedString(path, defaultValue, validValues::contains, comment);
    }

    @Override
    public String getDefinedString(String path, String defaultValue, Predicate<String> validator, String comment) {
        return this.getDefinedString(DynamicSpecConfig.split(path), defaultValue, validator, comment);
    }

    @Override
    public String getDefinedString(List<String> path, String defaultValue, Predicate<String> validator, String comment) {
        if (!this.config.contains(path) || !validator.test("" + this.config.get(path))) {
            this.config.set(path, (Object)defaultValue);
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return "" + this.config.get(path);
    }

    @Override
    public List<String> getDefinedStringList(String path, List<String> defaultValue, String comment) {
        return this.getDefinedStringList(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public List<String> getDefinedStringList(List<String> path, List<String> defaultValue, String comment) {
        return this.getDefinedStringList(path, defaultValue, (Predicate<String>)Predicates.alwaysTrue(), comment);
    }

    @Override
    public List<String> getDefinedStringList(String path, List<String> defaultValue, Collection<String> validValues, String comment) {
        return this.getDefinedStringList(DynamicSpecConfig.split(path), defaultValue, validValues, comment);
    }

    @Override
    public List<String> getDefinedStringList(List<String> path, List<String> defaultValue, Collection<String> validValues, String comment) {
        return this.getDefinedStringList(path, defaultValue, validValues::contains, comment);
    }

    @Override
    public List<String> getDefinedStringList(String path, List<String> defaultValue, Predicate<String> elementValidator, String comment) {
        return this.getDefinedStringList(DynamicSpecConfig.split(path), defaultValue, elementValidator, comment);
    }

    @Override
    public List<String> getDefinedStringList(List<String> path, List<String> defaultValue, Predicate<String> elementValidator, String comment) {
        if (!this.config.contains(path) || !(this.config.get(path) instanceof List)) {
            this.config.set(path, defaultValue);
        }
        List list = (List)this.config.get(path);
        list.removeIf(obj -> !elementValidator.test("" + obj));
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return list.stream().map(Object::toString).collect(Collectors.toCollection(ArrayList::new));
    }

    @Override
    public boolean getDefinedBoolean(String path, boolean defaultValue, String comment) {
        return this.getDefinedBoolean(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public boolean getDefinedBoolean(List<String> path, boolean defaultValue, String comment) {
        if (!this.config.contains(path) || !(this.config.get(path) instanceof Boolean)) {
            this.config.set(path, (Object)defaultValue);
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return (Boolean)this.config.get(path);
    }

    @Override
    public int getDefinedInt(String path, int defaultValue, String comment) {
        return this.getDefinedInt(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public int getDefinedInt(List<String> path, int defaultValue, String comment) {
        return this.getDefinedInt(path, defaultValue, (int value) -> true, comment);
    }

    @Override
    public int getDefinedInt(String path, int defaultValue, int min, int max, String comment) {
        return this.getDefinedInt(DynamicSpecConfig.split(path), defaultValue, min, max, comment);
    }

    @Override
    public int getDefinedInt(List<String> path, int defaultValue, int min, int max, String comment) {
        return this.getDefinedInt(path, defaultValue, (int value) -> value >= min && value <= max, comment);
    }

    @Override
    public int getDefinedInt(String path, int defaultValue, IntPredicate validator, String comment) {
        return this.getDefinedInt(DynamicSpecConfig.split(path), defaultValue, validator, comment);
    }

    @Override
    public int getDefinedInt(List<String> path, int defaultValue, IntPredicate validator, String comment) {
        if (!(this.config.contains(path) && this.config.get(path) instanceof Number && validator.test(this.config.getInt(path)))) {
            this.config.set(path, (Object)defaultValue);
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return this.config.getInt(path);
    }

    @Override
    public long getDefinedLong(String path, long defaultValue, String comment) {
        return this.getDefinedLong(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public long getDefinedLong(List<String> path, long defaultValue, String comment) {
        return this.getDefinedLong(path, defaultValue, (long value) -> true, comment);
    }

    @Override
    public long getDefinedLong(String path, long defaultValue, long min, long max, String comment) {
        return this.getDefinedLong(DynamicSpecConfig.split(path), defaultValue, min, max, comment);
    }

    @Override
    public long getDefinedLong(List<String> path, long defaultValue, long min, long max, String comment) {
        return this.getDefinedLong(path, defaultValue, (long value) -> value >= min && value <= max, comment);
    }

    @Override
    public long getDefinedLong(String path, long defaultValue, LongPredicate validator, String comment) {
        return this.getDefinedLong(DynamicSpecConfig.split(path), defaultValue, validator, comment);
    }

    @Override
    public long getDefinedLong(List<String> path, long defaultValue, LongPredicate validator, String comment) {
        if (!(this.config.contains(path) && this.config.get(path) instanceof Number && validator.test(this.config.getLong(path)))) {
            this.config.set(path, (Object)defaultValue);
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return this.config.getLong(path);
    }

    @Override
    public float getDefinedFloat(String path, float defaultValue, String comment) {
        return this.getDefinedFloat(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public float getDefinedFloat(List<String> path, float defaultValue, String comment) {
        return this.getDefinedFloat(path, defaultValue, (Predicate<Float>)Predicates.alwaysTrue(), comment);
    }

    @Override
    public float getDefinedFloat(String path, float defaultValue, float min, float max, String comment) {
        return this.getDefinedFloat(DynamicSpecConfig.split(path), defaultValue, min, max, comment);
    }

    @Override
    public float getDefinedFloat(List<String> path, float defaultValue, float min, float max, String comment) {
        return this.getDefinedFloat(path, defaultValue, (Float value) -> value.floatValue() >= min && value.floatValue() <= max, comment);
    }

    @Override
    public float getDefinedFloat(String path, float defaultValue, Predicate<Float> validator, String comment) {
        return this.getDefinedFloat(DynamicSpecConfig.split(path), defaultValue, validator, comment);
    }

    @Override
    public float getDefinedFloat(List<String> path, float defaultValue, Predicate<Float> validator, String comment) {
        if (!(this.config.contains(path) && this.config.get(path) instanceof Number && validator.test(Float.valueOf(((Number)this.config.getRaw(path)).floatValue())))) {
            this.config.set(path, (Object)defaultValue);
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return ((Number)this.config.getRaw(path)).floatValue();
    }

    @Override
    public double getDefinedDouble(String path, double defaultValue, String comment) {
        return this.getDefinedDouble(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public double getDefinedDouble(List<String> path, double defaultValue, String comment) {
        return this.getDefinedDouble(path, defaultValue, (double value) -> true, comment);
    }

    @Override
    public double getDefinedDouble(String path, double defaultValue, double min, double max, String comment) {
        return this.getDefinedDouble(DynamicSpecConfig.split(path), defaultValue, min, max, comment);
    }

    @Override
    public double getDefinedDouble(List<String> path, double defaultValue, double min, double max, String comment) {
        return this.getDefinedDouble(path, defaultValue, (double value) -> value >= min && value <= max, comment);
    }

    @Override
    public double getDefinedDouble(String path, double defaultValue, DoublePredicate validator, String comment) {
        return this.getDefinedDouble(DynamicSpecConfig.split(path), defaultValue, validator, comment);
    }

    @Override
    public double getDefinedDouble(List<String> path, double defaultValue, DoublePredicate validator, String comment) {
        if (!(this.config.contains(path) && this.config.get(path) instanceof Number && validator.test(((Number)this.config.getRaw(path)).doubleValue()))) {
            this.config.set(path, (Object)defaultValue);
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return ((Number)this.config.getRaw(path)).doubleValue();
    }

    @Override
    public byte getDefinedByte(String path, byte defaultValue, String comment) {
        return this.getDefinedByte(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public byte getDefinedByte(List<String> path, byte defaultValue, String comment) {
        return this.getDefinedByte(path, defaultValue, (Predicate<Byte>)Predicates.alwaysTrue(), comment);
    }

    @Override
    public byte getDefinedByte(String path, byte defaultValue, byte min, byte max, String comment) {
        return this.getDefinedByte(DynamicSpecConfig.split(path), defaultValue, min, max, comment);
    }

    @Override
    public byte getDefinedByte(List<String> path, byte defaultValue, byte min, byte max, String comment) {
        return this.getDefinedByte(path, defaultValue, (Byte value) -> value >= min && value <= max, comment);
    }

    @Override
    public byte getDefinedByte(String path, byte defaultValue, Predicate<Byte> validator, String comment) {
        return this.getDefinedByte(DynamicSpecConfig.split(path), defaultValue, validator, comment);
    }

    @Override
    public byte getDefinedByte(List<String> path, byte defaultValue, Predicate<Byte> validator, String comment) {
        if (!(this.config.contains(path) && this.config.get(path) instanceof Number && validator.test(this.config.getByte(path)))) {
            this.config.set(path, (Object)defaultValue);
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return this.config.getByte(path);
    }

    @Override
    public short getDefinedShort(String path, short defaultValue, String comment) {
        return this.getDefinedShort(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public short getDefinedShort(List<String> path, short defaultValue, String comment) {
        return this.getDefinedShort(path, defaultValue, (Predicate<Short>)Predicates.alwaysTrue(), comment);
    }

    @Override
    public short getDefinedShort(String path, short defaultValue, short min, short max, String comment) {
        return this.getDefinedShort(DynamicSpecConfig.split(path), defaultValue, min, max, comment);
    }

    @Override
    public short getDefinedShort(List<String> path, short defaultValue, short min, short max, String comment) {
        return this.getDefinedShort(path, defaultValue, (Short value) -> value >= min && value <= max, comment);
    }

    @Override
    public short getDefinedShort(String path, short defaultValue, Predicate<Short> validator, String comment) {
        return this.getDefinedShort(DynamicSpecConfig.split(path), defaultValue, validator, comment);
    }

    @Override
    public short getDefinedShort(List<String> path, short defaultValue, Predicate<Short> validator, String comment) {
        if (!(this.config.contains(path) && this.config.get(path) instanceof Number && validator.test(this.config.getShort(path)))) {
            this.config.set(path, (Object)defaultValue);
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return this.config.getShort(path);
    }

    @Override
    public char getDefinedChar(String path, char defaultValue, String comment) {
        return this.getDefinedChar(DynamicSpecConfig.split(path), defaultValue, comment);
    }

    @Override
    public char getDefinedChar(List<String> path, char defaultValue, String comment) {
        return this.getDefinedChar(path, defaultValue, (Predicate<Character>)Predicates.alwaysTrue(), comment);
    }

    @Override
    public char getDefinedChar(String path, char defaultValue, Collection<Character> validValues, String comment) {
        return this.getDefinedChar(DynamicSpecConfig.split(path), defaultValue, validValues, comment);
    }

    @Override
    public char getDefinedChar(List<String> path, char defaultValue, Collection<Character> validValues, String comment) {
        return this.getDefinedChar(path, defaultValue, validValues::contains, comment);
    }

    @Override
    public char getDefinedChar(String path, char defaultValue, Predicate<Character> validator, String comment) {
        return this.getDefinedChar(DynamicSpecConfig.split(path), defaultValue, validator, comment);
    }

    @Override
    public char getDefinedChar(List<String> path, char defaultValue, Predicate<Character> validator, String comment) {
        if (!this.config.contains(path) || !(this.config.get(path) instanceof Number) && !(this.config.get(path) instanceof CharSequence) || !validator.test(Character.valueOf(this.config.getChar(path)))) {
            this.config.set(path, (Object)Character.toString(defaultValue));
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return this.config.getChar(path);
    }

    @Override
    public <T extends Enum<T>> T getDefinedEnum(String path, Class<T> enumType, T defaultValue, String comment) {
        return this.getDefinedEnum(DynamicSpecConfig.split(path), enumType, defaultValue, comment);
    }

    @Override
    public <T extends Enum<T>> T getDefinedEnum(List<String> path, Class<T> enumType, T defaultValue, String comment) {
        return this.getDefinedEnum(path, enumType, defaultValue, (Predicate<T>)Predicates.alwaysTrue(), comment);
    }

    @Override
    public <T extends Enum<T>> T getDefinedEnum(String path, Class<T> enumType, T defaultValue, Collection<T> validValues, String comment) {
        return this.getDefinedEnum(DynamicSpecConfig.split(path), enumType, defaultValue, validValues, comment);
    }

    @Override
    public <T extends Enum<T>> T getDefinedEnum(List<String> path, Class<T> enumType, T defaultValue, Collection<T> validValues, String comment) {
        return (T)this.getDefinedEnum(path, enumType, defaultValue, validValues::contains, comment);
    }

    @Override
    public <T extends Enum<T>> T getDefinedEnum(String path, Class<T> enumType, T defaultValue, Predicate<T> validator, String comment) {
        return this.getDefinedEnum(DynamicSpecConfig.split(path), enumType, defaultValue, validator, comment);
    }

    @Override
    public <T extends Enum<T>> T getDefinedEnum(List<String> path, Class<T> enumType, T defaultValue, Predicate<T> validator, String comment) {
        if (!this.config.contains(path) || !(this.config.get(path) instanceof CharSequence) && !(this.config.get(path) instanceof Number) || !validator.test(this.config.getEnum(path, enumType, EnumGetMethod.ORDINAL_OR_NAME_IGNORECASE))) {
            this.config.set(path, (Object)defaultValue.name().toLowerCase(Locale.US));
        }
        if (comment != null) {
            this.config.setComment(path, comment);
        }
        return (T)this.config.getEnum(path, enumType, EnumGetMethod.ORDINAL_OR_NAME_IGNORECASE);
    }

    static List<String> split(String str) {
        return Lists.newArrayList((Object[])StringUtils.split((String)str, (char)'.'));
    }
}

