/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.voluminousenergy.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class CompressingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final int inputCount;
    public final Object output;
    public final int outputCount;
    public final int time;

    public CompressingRecipeSerializer(ResourceLocation key, Object input, int inputCount, Object output, int outputCount, int time) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.inputCount = inputCount;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "voluminousenergy:compressing");
        JsonObject ingJson = MiscHelper.INSTANCE.wrapIngredient(ing).m_43942_().getAsJsonObject();
        ingJson.addProperty("count", (Number)this.inputCount);
        json.add("ingredient", (JsonElement)ingJson);
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        json.addProperty("process_time", (Number)this.time);
        return json;
    }
}

