/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.usefulmachinery.recipes;

import com.google.common.base.Strings;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final String group;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondOutputChance;
    public final int time;

    public CrushingRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, int time) {
        this(key, "", input, output, outputCount, ItemStack.f_41583_, 0, 0.0f, time);
    }

    public CrushingRecipeSerializer(ResourceLocation key, String group, Object input, Object output, int outputCount, int time) {
        this(key, group, input, output, outputCount, ItemStack.f_41583_, 0, 0.0f, time);
    }

    public CrushingRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondOutputChance, int time) {
        this(key, "", input, output, outputCount, secondOutput, secondOutputCount, secondOutputChance, time);
    }

    public CrushingRecipeSerializer(ResourceLocation key, String group, Object input, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondOutputChance, int time) {
        this.key = Objects.requireNonNull(key);
        this.group = Strings.nullToEmpty((String)group);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondOutputChance = secondOutputChance;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        JsonObject json = new JsonObject();
        json.addProperty("type", "usefulmachinery:crushing");
        if (!this.group.isEmpty()) {
            json.addProperty("group", this.group);
        }
        json.add("ingredient", ing.m_43942_());
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        if (!secondStack.m_41619_()) {
            JsonObject secondaryJson = MiscHelper.INSTANCE.serializeItemStack(stack);
            secondaryJson.addProperty("chance", (Number)Float.valueOf(this.secondOutputChance));
            json.add("secondary", (JsonElement)secondaryJson);
        }
        json.addProperty("processingtime", (Number)this.time);
        return json;
    }
}

