/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.theurgy.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.klikli_dev.theurgy.content.recipe.ingredient.FluidIngredient;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.theurgy.TheurgyHelper;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class LiquefactionRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object output;
    public final int outputCount;
    public final int time;

    public LiquefactionRecipeSerializer(ResourceLocation key, Object itemInput, Object fluidInput, int fluidInputAmount, Object output, int outputCount, int time) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.time = time;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.itemInput);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.itemInput);
        }
        FluidIngredient fluidIng = TheurgyHelper.INSTANCE.getFluidIngredient(this.fluidInput);
        if (fluidIng == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + fluidIng);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "theurgy:liquefaction");
        json.add("ingredient", ing.m_43942_());
        json.add("solvent", fluidIng.m_43942_());
        json.addProperty("solvent_amount", (Number)this.fluidInputAmount);
        json.add("result", (JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        json.addProperty("liquefaction_time", (Number)this.time);
        return json;
    }
}

