/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.theurgy;

import com.google.gson.JsonElement;
import com.klikli_dev.theurgy.content.recipe.ingredient.FluidIngredient;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.compat.theurgy.recipes.IncubationRecipeSerializer;
import thelm.jaopca.compat.theurgy.recipes.LiquefactionRecipeSerializer;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class TheurgyHelper {
    public static final TheurgyHelper INSTANCE = new TheurgyHelper();

    private TheurgyHelper() {
    }

    public FluidIngredient getFluidIngredient(Object obj) {
        return (FluidIngredient)this.getFluidIngredientResolved(obj).getLeft();
    }

    public Pair<FluidIngredient, Set<Fluid>> getFluidIngredientResolved(Object obj) {
        FluidIngredient ing = null;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        MiscHelper helper = MiscHelper.INSTANCE;
        if (obj instanceof Supplier) {
            Pair<FluidIngredient, Set<Fluid>> pair = this.getFluidIngredientResolved(((Supplier)obj).get());
            ing = (FluidIngredient)pair.getLeft();
            fluids.addAll((Collection)pair.getRight());
        } else if (obj instanceof FluidIngredient) {
            ing = (FluidIngredient)obj;
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = FluidIngredient.ofFluid(helper.getFluidTagKey(location));
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = FluidIngredient.ofFluid(helper.getFluidTagKey(location));
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = FluidIngredient.ofFluid((TagKey)key);
            fluids.addAll(helper.getFluidTagValues(key.f_203868_()));
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            if (!stack.isEmpty()) {
                ing = FluidIngredient.ofFluid((FluidStack[])new FluidStack[]{stack});
                fluids.add(stack.getFluid());
            }
        } else if (obj instanceof FluidStack[]) {
            FluidStack[] stacks = (FluidStack[])obj;
            List<FluidStack> nonEmpty = Arrays.stream(stacks).filter(s -> !s.isEmpty()).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidIngredient.ofFluid(nonEmpty.stream());
                nonEmpty.stream().map(FluidStack::getFluid).forEach(fluids::add);
            }
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            if (fluid != Fluids.f_76191_) {
                ing = FluidIngredient.ofFluid((Fluid[])new Fluid[]{fluid});
                fluids.add(fluid);
            }
        } else if (obj instanceof Fluid[]) {
            Fluid[] fluidz = (Fluid[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidIngredient.ofFluid((Fluid[])((Fluid[])nonEmpty.toArray(Fluid[]::new)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof IFluidLike) {
            IFluidLike fluid = (IFluidLike)obj;
            if (fluid.asFluid() != Fluids.f_76191_) {
                ing = FluidIngredient.ofFluid((Fluid[])new Fluid[]{fluid.asFluid()});
                fluids.add(fluid.asFluid());
            }
        } else if (obj instanceof IFluidLike[]) {
            IFluidLike[] fluidz = (IFluidLike[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).map(IFluidLike::asFluid).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidIngredient.ofFluid((Fluid[])((Fluid[])nonEmpty.toArray(Fluid[]::new)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof JsonElement) {
            ing = FluidIngredient.fromJson((JsonElement)((JsonElement)obj));
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        }
        fluids.remove(Fluids.f_76191_);
        return Pair.of((Object)(fluids.isEmpty() ? null : ing), fluids);
    }

    public boolean registerLiquefactionRecipe(ResourceLocation key, Object itemInput, Object fluidInput, int fluidInputAmount, Object output, int outputCount, int time) {
        return ApiImpl.INSTANCE.registerRecipe(key, new LiquefactionRecipeSerializer(key, itemInput, fluidInput, fluidInputAmount, output, outputCount, time));
    }

    public boolean registerIncubationRecipe(ResourceLocation key, Object mercury, Object salt, Object sulfur, Object output, int outputCount, int time) {
        return ApiImpl.INSTANCE.registerRecipe(key, new IncubationRecipeSerializer(key, mercury, salt, sulfur, output, outputCount, time));
    }
}

