/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.thermalexpansion;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.thermalexpansion.ThermalExpansionHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"thermal_expansion"})
public class ThermalExpansionCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(List.of("apatite", "bronze", "cinnabar", "constantan", "copper", "diamond", "electrum", "emerald", "ender_pearl", "enderium", "gold", "invar", "iron", "lapis", "lead", "lumium", "netherite", "nickel", "niter", "quartz", "ruby", "sapphire", "signalum", "silver", "sulfur", "tin"));
    private static final Set<String> DUST_TO_INGOT_BLACKLIST = new TreeSet<String>(List.of("bronze", "constantan", "copper", "electrum", "enderium", "gold", "invar", "iron", "lead", "lumium", "netherite", "nickel", "signalum", "silver", "tin"));
    private static final Set<String> TO_PLATE_BLACKLIST = new TreeSet<String>(List.of("bronze", "constantan", "copper", "electrum", "enderium", "gold", "invar", "iron", "lead", "lumium", "netherite", "nickel", "signalum", "silver", "tin"));
    private static final Set<String> TO_GEAR_BLACKLIST = new TreeSet<String>(List.of("bronze", "constantan", "copper", "electrum", "enderium", "gold", "invar", "iron", "lead", "lumium", "netherite", "nickel", "signalum", "silver", "tin"));
    private static final Set<String> TO_COIN_BLACKLIST = new TreeSet<String>(List.of("bronze", "constantan", "copper", "electrum", "enderium", "gold", "invar", "iron", "lead", "lumium", "netherite", "nickel", "signalum", "silver", "tin"));
    private static final Set<String> PACKING_STORAGE_BLOCK_BLACKLIST = new TreeSet<String>(List.of("amethyst", "apatite", "bronze", "charcoal", "cinnabar", "coal_coke", "coal", "constantan", "copper", "diamond", "electrum", "emerald", "enderium", "glowstone", "gold", "gunpowder", "invar", "iron", "lapis", "lead", "lumium", "netherite", "nickel", "niter", "quartz", "redstone", "ruby", "sapphire", "signalum", "silver", "sulfur", "wood"));
    private static final Set<String> PACKING_NUGGET_BLACKLIST = new TreeSet<String>(List.of("bronze", "constantan", "copper", "electrum", "enderium", "gold", "invar", "iron", "lead", "lumium", "netherite", "nickel", "signalum", "silver", "tin"));
    private static final Set<String> PACKING_RAW_STORAGE_BLOCK_BLACKLIST = new TreeSet<String>(List.of("copper", "gold", "iron", "lead", "nickel", "silver", "tin"));
    private static final Set<String> MOLTEN_TO_INGOT_BLACKLIST = new TreeSet<String>();
    private static final Set<String> TO_ROD_BLACKLIST = new TreeSet<String>();
    private static final Set<String> CREATE_BLACKLIST = new TreeSet<String>();
    private static Set<String> configToDustBlacklist = new TreeSet<String>();
    private static Set<String> configDustToIngotBlacklist = new TreeSet<String>();
    private static Set<String> configToPlateBlacklist = new TreeSet<String>();
    private static Set<String> configToGearBlacklist = new TreeSet<String>();
    private static Set<String> configMaterialToCoinBlacklist = new TreeSet<String>();
    private static Set<String> configNuggetToCoinBlacklist = new TreeSet<String>();
    private static Set<String> configToStorageBlockBlacklist = new TreeSet<String>();
    private static Set<String> configNuggetToMaterialBlacklist = new TreeSet<String>();
    private static Set<String> configToRawStorageBlockBlacklist = new TreeSet<String>();
    private static Set<String> configStorageBlockToMaterialBlacklist = new TreeSet<String>();
    private static Set<String> configToNuggetBlacklist = new TreeSet<String>();
    private static Set<String> configToRawMaterialBlacklist = new TreeSet<String>();
    private static Set<String> configMoltenToIngotBlacklist = new TreeSet<String>();
    private static Set<String> configToRodBlacklist = new TreeSet<String>();
    private static Set<String> configCreateToNuggetBlacklist = new TreeSet<String>();
    private static Set<String> configCreateToIngotBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "thermal_expansion_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have pulverizer to dust recipes added."), configToDustBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.dustToIngotMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have smelter to ingot recipes added."), configDustToIngotBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toPlateMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to plate recipes added."), configToPlateBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toGearMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press to gear recipes added."), configToGearBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.materialToCoinMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press material to coin recipes added."), configMaterialToCoinBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.nuggetToCoinMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press nugget to coin recipes added."), configNuggetToCoinBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toStorageBlockMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press material to storage block recipes added."), configToStorageBlockBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.nuggetToMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press nugget to material recipes added."), configNuggetToMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toRawStorageBlockMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press raw material to raw storage block recipes added."), configToRawStorageBlockBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.storageBlockToMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press storage block to material recipes added."), configStorageBlockToMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toNuggetMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press material to nugget recipes added."), configToNuggetBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toRawMaterialMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have press raw storage block to raw material recipes added."), configToRawMaterialBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.moltenToIngotMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have chiller to ingot recipes added."), configMoltenToIngotBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toRodMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have chiller to rod recipes added."), configToRodBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.createToNuggetMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have create centrifuge compat recipes added."), configCreateToNuggetBlacklist);
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.createToIngotMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have create smelter compat recipes added."), configCreateToIngotBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        ThermalExpansionHelper helper = ThermalExpansionHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        Set<ResourceLocation> itemTags = ((JAOPCAApi)api).getItemTags();
        Set<ResourceLocation> fluidTags = ((JAOPCAApi)api).getFluidTags();
        Item gearDie = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:press_gear_die"));
        Item coinDie = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:press_coin_die"));
        Item packingDie = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:press_packing_3x3_die"));
        Item smallPackingDie = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:press_packing_2x2_die"));
        Item unpackingDie = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:press_unpacking_die"));
        Item ingotCast = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:chiller_ingot_cast"));
        Item rodCast = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation("thermal:chiller_rod_cast"));
        for (IMaterial material : moduleData.getMaterials()) {
            ResourceLocation moltenLocation;
            ResourceLocation nuggetLocation;
            ResourceLocation nuggetLocation2;
            ResourceLocation coinLocation;
            ResourceLocation materialLocation;
            ResourceLocation materialLocation2;
            MaterialType type = material.getType();
            String name = material.getName();
            if (!(type.isDust() || TO_DUST_BLACKLIST.contains(name) || configToDustBlacklist.contains(name))) {
                materialLocation2 = miscHelper.getTagLocation(type.getFormName(), name);
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", name);
                if (itemTags.contains(dustLocation)) {
                    helper.registerPulverizerRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_dust." + name), materialLocation2, 1, new Object[]{dustLocation}, 2000, 0.0f);
                }
            }
            if (type.isIngot() && !DUST_TO_INGOT_BLACKLIST.contains(name) && !configDustToIngotBlacklist.contains(name)) {
                ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", name);
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                if (itemTags.contains(dustLocation)) {
                    helper.registerSmelterRecipe(new ResourceLocation("jaopca", "thermal_expansion.dust_to_material." + name), new Object[]{dustLocation}, new Object[]{materialLocation}, 1600, 0.0f);
                }
            }
            if (type.isIngot() && !TO_PLATE_BLACKLIST.contains(name) && !configToPlateBlacklist.contains(name)) {
                materialLocation2 = miscHelper.getTagLocation(type.getFormName(), name);
                ResourceLocation plateLocation = miscHelper.getTagLocation("plates", name);
                if (itemTags.contains(plateLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_plate." + name), materialLocation2, 1, plateLocation, 1, 2400, 0.0f);
                }
            }
            if (type.isIngot() && !TO_GEAR_BLACKLIST.contains(name) && !configToGearBlacklist.contains(name)) {
                materialLocation2 = miscHelper.getTagLocation(type.getFormName(), name);
                ResourceLocation gearLocation = miscHelper.getTagLocation("gears", name);
                if (itemTags.contains(gearLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_gear." + name), materialLocation2, 4, gearDie, 1, gearLocation, 1, 2400, 0.0f);
                }
            }
            if (type.isIngot() && !TO_COIN_BLACKLIST.contains(name) && !configMaterialToCoinBlacklist.contains(name)) {
                materialLocation2 = miscHelper.getTagLocation(type.getFormName(), name);
                coinLocation = miscHelper.getTagLocation("coins", name);
                if (itemTags.contains(coinLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_coin." + name), materialLocation2, 1, coinDie, 1, coinLocation, 3, 2400, 0.0f);
                }
            }
            if (type.isIngot() && !TO_COIN_BLACKLIST.contains(name) && !configNuggetToCoinBlacklist.contains(name)) {
                nuggetLocation2 = miscHelper.getTagLocation("nuggets", name);
                coinLocation = miscHelper.getTagLocation("coins", name);
                if (itemTags.contains(nuggetLocation2) && itemTags.contains(coinLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.nugget_to_coin." + name), nuggetLocation2, 3, coinDie, 1, coinLocation, 1, 800, 0.0f);
                }
            }
            if (!PACKING_STORAGE_BLOCK_BLACKLIST.contains(name) && !configToStorageBlockBlacklist.contains(name)) {
                materialLocation2 = miscHelper.getTagLocation(type.getFormName(), name);
                ResourceLocation storageBlockLocation = miscHelper.getTagLocation("storage_blocks", name);
                if (itemTags.contains(storageBlockLocation)) {
                    if (material.isSmallStorageBlock()) {
                        helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_storage_block." + name), materialLocation2, 4, smallPackingDie, 1, storageBlockLocation, 1, 400, 0.0f);
                    } else {
                        helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_storage_block." + name), materialLocation2, 9, packingDie, 1, storageBlockLocation, 1, 400, 0.0f);
                    }
                }
            }
            if (!PACKING_NUGGET_BLACKLIST.contains(name) && !configNuggetToMaterialBlacklist.contains(name)) {
                nuggetLocation2 = miscHelper.getTagLocation("nuggets", name);
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                if (itemTags.contains(nuggetLocation2)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.nugget_to_material." + name), nuggetLocation2, 9, packingDie, 1, materialLocation, 1, 400, 0.0f);
                }
            }
            if (!PACKING_RAW_STORAGE_BLOCK_BLACKLIST.contains(name) && !configToRawStorageBlockBlacklist.contains(name)) {
                ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", name);
                ResourceLocation rawStorageBlockLocation = miscHelper.getTagLocation("storage_blocks/raw", name, "_");
                if (itemTags.contains(rawMaterialLocation) && itemTags.contains(rawStorageBlockLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.raw_material_to_raw_storage_block." + name), rawMaterialLocation, 9, packingDie, 1, rawStorageBlockLocation, 1, 400, 0.0f);
                }
            }
            if (!PACKING_STORAGE_BLOCK_BLACKLIST.contains(name) && !configStorageBlockToMaterialBlacklist.contains(name)) {
                ResourceLocation storageBlockLocation = miscHelper.getTagLocation("storage_blocks", name);
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                if (itemTags.contains(storageBlockLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.storage_block_to_material." + name), storageBlockLocation, 1, unpackingDie, 1, materialLocation, material.isSmallStorageBlock() ? 4 : 9, 400, 0.0f);
                }
            }
            if (!PACKING_STORAGE_BLOCK_BLACKLIST.contains(name) && !configStorageBlockToMaterialBlacklist.contains(name)) {
                materialLocation2 = miscHelper.getTagLocation(type.getFormName(), name);
                nuggetLocation = miscHelper.getTagLocation("nuggets", name);
                if (itemTags.contains(nuggetLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.material_to_nugget." + name), materialLocation2, 1, unpackingDie, 1, nuggetLocation, 9, 400, 0.0f);
                }
            }
            if (!PACKING_RAW_STORAGE_BLOCK_BLACKLIST.contains(name) && !configToRawMaterialBlacklist.contains(name)) {
                ResourceLocation rawStorageBlockLocation = miscHelper.getTagLocation("storage_blocks/raw", name, "_");
                ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", name);
                if (itemTags.contains(rawMaterialLocation) && itemTags.contains(rawStorageBlockLocation)) {
                    helper.registerPressRecipe(new ResourceLocation("jaopca", "thermal_expansion.raw_storage_block_to_raw_material." + name), rawStorageBlockLocation, 1, unpackingDie, 1, rawMaterialLocation, 9, 400, 0.0f);
                }
            }
            if (type.isIngot() && !MOLTEN_TO_INGOT_BLACKLIST.contains(name) && !configMoltenToIngotBlacklist.contains(name)) {
                moltenLocation = miscHelper.getTagLocation("molten", name, "_");
                materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
                if (fluidTags.contains(moltenLocation)) {
                    helper.registerChillerRecipe(new ResourceLocation("jaopca", "thermal_expansion.molten_to_material." + name), moltenLocation, 90, ingotCast, 1, materialLocation, 1, 4800, 0.0f);
                }
            }
            if (!TO_ROD_BLACKLIST.contains(name) && !configToRodBlacklist.contains(name)) {
                moltenLocation = miscHelper.getTagLocation("molten", name, "_");
                ResourceLocation rodLocation = miscHelper.getTagLocation("rods", name);
                if (fluidTags.contains(moltenLocation) && itemTags.contains(rodLocation)) {
                    helper.registerChillerRecipe(new ResourceLocation("jaopca", "thermal_expansion.molten_to_rod." + name), moltenLocation, type.isIngot() ? 45 : 50, rodCast, 1, rodLocation, 1, 2400, 0.0f);
                }
            }
            if (type.isIngot() && !CREATE_BLACKLIST.contains(name) && !configCreateToNuggetBlacklist.contains(name)) {
                ResourceLocation crushedOreLocation = miscHelper.getTagLocation("create:crushed_raw_materials", name);
                nuggetLocation = miscHelper.getTagLocation("nuggets", name);
                if (itemTags.contains(crushedOreLocation) && itemTags.contains(nuggetLocation)) {
                    helper.registerCentrifugeRecipe(new ResourceLocation("jaopca", "thermal_expansion.create_crushed_to_nugget." + name), crushedOreLocation, 1, new Object[]{nuggetLocation, 9}, 1600, 0.0f);
                }
            }
            if (!type.isIngot() || CREATE_BLACKLIST.contains(name) || configCreateToIngotBlacklist.contains(name)) continue;
            ResourceLocation crushedLocation = miscHelper.getTagLocation("create:crushed_raw_materials", name);
            materialLocation = miscHelper.getTagLocation(type.getFormName(), name);
            if (!itemTags.contains(crushedLocation)) continue;
            helper.registerSmelterRecipe(new ResourceLocation("jaopca", "thermal_expansion.create_crushed_to_material." + name), new Object[]{crushedLocation, 1}, new Object[]{materialLocation, 1}, 1600, 0.1f);
        }
    }

    static {
        if (ModList.get().isLoaded("alltheores")) {
            Collections.addAll(TO_DUST_BLACKLIST, "osmium", "platinum", "zinc");
        }
        if (ModList.get().isLoaded("thermal_integration")) {
            Collections.addAll(TO_DUST_BLACKLIST, "rose_gold", "steel");
            Collections.addAll(DUST_TO_INGOT_BLACKLIST, "rose_gold", "steel");
            Collections.addAll(TO_PLATE_BLACKLIST, "rose_gold", "steel");
            Collections.addAll(TO_GEAR_BLACKLIST, "rose_gold", "steel");
            Collections.addAll(TO_COIN_BLACKLIST, "rose_gold", "steel");
            Collections.addAll(PACKING_STORAGE_BLOCK_BLACKLIST, "rose_gold", "steel");
            Collections.addAll(PACKING_NUGGET_BLACKLIST, "rose_gold", "steel");
            if (ModList.get().isLoaded("create")) {
                Collections.addAll(PACKING_STORAGE_BLOCK_BLACKLIST, "zinc");
                Collections.addAll(PACKING_NUGGET_BLACKLIST, "zinc");
                Collections.addAll(PACKING_RAW_STORAGE_BLOCK_BLACKLIST, "zinc");
                Collections.addAll(CREATE_BLACKLIST, "copper", "gold", "iron", "lead", "nickel", "silver", "tin", "zinc");
                if (ModList.get().isLoaded("immersiveengineering")) {
                    Collections.addAll(CREATE_BLACKLIST, "aluminium", "aluminum", "uranium");
                }
            }
            if (ModList.get().isLoaded("immersiveengineering")) {
                Collections.addAll(TO_DUST_BLACKLIST, "aluminium", "aluminum", "uranium");
                Collections.addAll(DUST_TO_INGOT_BLACKLIST, "aluminium", "aluminum", "uranium");
                Collections.addAll(TO_PLATE_BLACKLIST, "aluminium", "aluminum", "steel", "uranium");
                Collections.addAll(PACKING_STORAGE_BLOCK_BLACKLIST, "aluminium", "aluminum", "uranium");
                Collections.addAll(PACKING_NUGGET_BLACKLIST, "aluminium", "aluminum", "uranium");
                Collections.addAll(PACKING_RAW_STORAGE_BLOCK_BLACKLIST, "aluminium", "aluminum", "uranium");
            }
            if (ModList.get().isLoaded("mekanism")) {
                Collections.addAll(TO_DUST_BLACKLIST, "fluorite");
                Collections.addAll(PACKING_STORAGE_BLOCK_BLACKLIST, "fluorite", "osmium", "refined_glowstone", "refined_obsidian", "salt", "uranium");
                Collections.addAll(PACKING_NUGGET_BLACKLIST, "osmium", "refined_glowstone", "refined_obsidian", "uranium");
                Collections.addAll(PACKING_RAW_STORAGE_BLOCK_BLACKLIST, "osmium", "uranium");
            }
            if (ModList.get().isLoaded("tconstruct")) {
                Collections.addAll(MOLTEN_TO_INGOT_BLACKLIST, "amethyst_bronze", "bronze", "cobalt", "constantan", "copper", "debris", "electrum", "gold", "hepatizon", "invar", "iron", "knightslime", "lead", "manyullyn", "netherite", "netherite_scrap", "nickel", "pig_iron", "queens_slime", "rose_gold", "silver", "slimesteel", "steel", "tin");
                Collections.addAll(PACKING_STORAGE_BLOCK_BLACKLIST, "amethyst_bronze", "cobalt", "hepatizon", "manyullyn", "pig_iron", "queens_slime", "rose_gold", "slimesteel");
                Collections.addAll(PACKING_NUGGET_BLACKLIST, "amethyst_bronze", "cobalt", "hepatizon", "manyullyn", "pig_iron", "queens_slime", "rose_gold", "slimesteel");
                Collections.addAll(PACKING_RAW_STORAGE_BLOCK_BLACKLIST, new String[0]);
                if (ModList.get().isLoaded("immersiveengineering")) {
                    Collections.addAll(MOLTEN_TO_INGOT_BLACKLIST, "aluminium", "aluminum");
                    Collections.addAll(TO_ROD_BLACKLIST, "aluminium", "aluminum", "iron", "steel");
                }
            }
        }
    }
}

