/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.indreb.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class OreWashingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final int itemInputCount;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object output;
    public final int outputCount;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondChance;
    public final int time;
    public final int power;
    public final float experience;

    public OreWashingRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputCount, int time, int power, float experience) {
        this(key, itemInput, itemInputCount, fluidInput, fluidInputAmount, output, outputCount, ItemStack.f_41583_, 0, 0.0f, time, power, experience);
    }

    public OreWashingRecipeSerializer(ResourceLocation key, Object itemInput, int itemInputCount, Object fluidInput, int fluidInputAmount, Object output, int outputCount, Object secondOutput, int secondOutputCount, float secondChance, int time, int power, float experience) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.itemInputCount = itemInputCount;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.output = output;
        this.outputCount = outputCount;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondChance = secondChance;
        this.time = time;
        this.power = power;
        this.experience = experience;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.itemInput);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.itemInput);
        }
        FluidStack fluidIng = MiscHelper.INSTANCE.getFluidStack(this.fluidInput, this.fluidInputAmount);
        if (fluidIng.isEmpty()) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.fluidInput);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        JsonObject json = new JsonObject();
        json.addProperty("type", "indreb:ore_washing");
        JsonArray ingsJson = new JsonArray();
        JsonObject ingJson = MiscHelper.INSTANCE.wrapIngredient(ing).m_43942_().getAsJsonObject();
        ingJson.addProperty("count", (Number)this.itemInputCount);
        ingsJson.add((JsonElement)ingJson);
        json.add("ingredients", (JsonElement)ingsJson);
        json.add("fluid_input", (JsonElement)MiscHelper.INSTANCE.serializeFluidStack(fluidIng));
        JsonObject resultJson = MiscHelper.INSTANCE.serializeItemStack(stack);
        json.add("result", (JsonElement)resultJson);
        JsonArray chanceJson = new JsonArray();
        if (!secondStack.m_41619_()) {
            JsonObject secondJson = MiscHelper.INSTANCE.serializeItemStack(secondStack);
            secondJson.addProperty("chance", (Number)Float.valueOf(this.secondChance));
            chanceJson.add((JsonElement)secondJson);
        }
        json.add("chance_result", (JsonElement)chanceJson);
        json.addProperty("duration", (Number)this.time);
        json.addProperty("tick_energy_cost", (Number)this.power);
        json.addProperty("experience", (Number)Float.valueOf(this.experience));
        return json;
    }
}

