/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.factorium;

import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Multimap;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.forms.IForm;
import thelm.jaopca.api.forms.IFormRequest;
import thelm.jaopca.api.items.IItemInfo;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.factorium.FactoriumHelper;
import thelm.jaopca.items.ItemFormType;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"factorium"})
public class FactoriumModule
implements IModule {
    private static final Set<String> BLACKLIST = new TreeSet<String>(List.of("copper", "gold", "iron", "lead", "nickel", "platinum", "silver", "tin", "zinc"));
    private final IForm chunkForm = ApiImpl.INSTANCE.newForm(this, "factorium_chunks", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT, MaterialType.INGOT_LEGACY).setSecondaryName("factorium:chunks").setDefaultMaterialBlacklist(BLACKLIST);
    private final IForm powderForm = ApiImpl.INSTANCE.newForm(this, "factorium_powders", ItemFormType.INSTANCE).setMaterialTypes(MaterialType.INGOT, MaterialType.INGOT_LEGACY).setSecondaryName("factorium:powders").setDefaultMaterialBlacklist(BLACKLIST);
    private final IFormRequest formRequest = ApiImpl.INSTANCE.newFormRequest(this, this.chunkForm, this.powderForm).setGrouped(true);

    @Override
    public String getName() {
        return "factorium";
    }

    @Override
    public Multimap<Integer, String> getModuleDependencies() {
        ImmutableSetMultimap.Builder builder = ImmutableSetMultimap.builder();
        builder.put((Object)0, (Object)"dusts");
        return builder.build();
    }

    @Override
    public List<IFormRequest> getFormRequests() {
        return List.of(this.formRequest);
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.of(MaterialType.INGOT, MaterialType.INGOT_LEGACY);
    }

    @Override
    public Set<String> getDefaultMaterialBlacklist() {
        return BLACKLIST;
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        FactoriumHelper helper = FactoriumHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ItemFormType itemFormType = ItemFormType.INSTANCE;
        for (IMaterial material : this.formRequest.getMaterials()) {
            IItemInfo chunkInfo = itemFormType.getMaterialFormInfo(this.chunkForm, material);
            ResourceLocation chunkLocation = miscHelper.getTagLocation("factorium:chunks", material.getName());
            IItemInfo powderInfo = itemFormType.getMaterialFormInfo(this.powderForm, material);
            ResourceLocation powderLocation = miscHelper.getTagLocation("factorium:powders", material.getName());
            ResourceLocation oreLocation = miscHelper.getTagLocation("ores", material.getName());
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            helper.registerCrusherRecipe(new ResourceLocation("jaopca", "factorium.ore_to_chunk." + material.getName()), oreLocation, chunkInfo, 2, 1.0f, Items.f_41832_, 1, 0.1f, ItemStack.f_41583_, 0, 0.0f);
            if (material.getType() == MaterialType.INGOT) {
                ResourceLocation rawMaterialLocation = miscHelper.getTagLocation("raw_materials", material.getName());
                helper.registerCrusherRecipe(new ResourceLocation("jaopca", "factorium.raw_material_to_chunk." + material.getName()), rawMaterialLocation, chunkInfo, 2, 1.0f);
            }
            helper.registerGrinderRecipe(new ResourceLocation("jaopca", "factorium.chunk_to_powder." + material.getName()), chunkLocation, powderInfo, 1, 1.0f, ItemStack.f_41583_, 0, 0.0f, powderInfo, 1, 0.25f);
            ((JAOPCAApi)api).registerSmeltingRecipe(new ResourceLocation("jaopca", "factorium.chunk_to_material." + material.getName()), chunkLocation, materialLocation, 1, 0.7f, 200);
            ((JAOPCAApi)api).registerBlastingRecipe(new ResourceLocation("jaopca", "factorium.chunk_to_material_blasting." + material.getName()), chunkLocation, materialLocation, 1, 0.7f, 100);
            ((JAOPCAApi)api).registerSmeltingRecipe(new ResourceLocation("jaopca", "factorium.powder_to_material." + material.getName()), powderLocation, materialLocation, 1, 0.7f, 200);
            ((JAOPCAApi)api).registerBlastingRecipe(new ResourceLocation("jaopca", "factorium.powder_to_material_blasting." + material.getName()), powderLocation, materialLocation, 1, 0.7f, 100);
            helper.registerPulverizerRecipe(new ResourceLocation("jaopca", "factorium.powder_to_dust." + material.getName()), powderLocation, dustLocation, 1, 1.0f, ItemStack.f_41583_, 0, 0.0f, dustLocation, 1, 0.25f);
        }
    }
}

