/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.embers;

import com.google.gson.JsonElement;
import com.rekindled.embers.recipe.FluidIngredient;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.api.fluids.IFluidLike;
import thelm.jaopca.compat.embers.recipes.MeltingRecipeSerializer;
import thelm.jaopca.compat.embers.recipes.StampingRecipeSerializer;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class EmbersHelper {
    public static final EmbersHelper INSTANCE = new EmbersHelper();

    private EmbersHelper() {
    }

    public FluidIngredient getFluidIngredient(Object obj, int amount) {
        return (FluidIngredient)this.getFluidIngredientResolved(obj, amount).getLeft();
    }

    public Pair<FluidIngredient, Set<Fluid>> getFluidIngredientResolved(Object obj, int amount) {
        FluidIngredient ing = null;
        HashSet<Fluid> fluids = new HashSet<Fluid>();
        MiscHelper helper = MiscHelper.INSTANCE;
        if (obj instanceof Supplier) {
            Pair<FluidIngredient, Set<Fluid>> pair = this.getFluidIngredientResolved(((Supplier)obj).get(), amount);
            ing = (FluidIngredient)pair.getLeft();
            fluids.addAll((Collection)pair.getRight());
        } else if (obj instanceof FluidIngredient) {
            ing = (FluidIngredient)obj;
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            ing = FluidIngredient.of(helper.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            ing = FluidIngredient.of(helper.getFluidTagKey(location), (int)amount);
            fluids.addAll(helper.getFluidTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            ing = FluidIngredient.of((TagKey)key, (int)amount);
            fluids.addAll(helper.getFluidTagValues(key.f_203868_()));
        } else if (obj instanceof FluidStack) {
            FluidStack stack = (FluidStack)obj;
            if (!stack.isEmpty()) {
                ing = FluidIngredient.of((FluidStack)stack);
                fluids.add(stack.getFluid());
            }
        } else if (obj instanceof FluidStack[]) {
            FluidStack[] stacks = (FluidStack[])obj;
            List<FluidStack> nonEmpty = Arrays.stream(stacks).filter(s -> !s.isEmpty()).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidIngredient.of((FluidIngredient[])((FluidIngredient[])nonEmpty.stream().map(FluidIngredient::of).toArray(FluidIngredient[]::new)));
                nonEmpty.stream().map(FluidStack::getFluid).forEach(fluids::add);
            }
        } else if (obj instanceof Fluid) {
            Fluid fluid = (Fluid)obj;
            if (fluid != Fluids.f_76191_) {
                ing = FluidIngredient.of((Fluid)fluid, (int)amount);
                fluids.add(fluid);
            }
        } else if (obj instanceof Fluid[]) {
            Fluid[] fluidz = (Fluid[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidIngredient.of((FluidIngredient[])((FluidIngredient[])nonEmpty.stream().map(f -> FluidIngredient.of((Fluid)f, (int)amount)).toArray(FluidIngredient[]::new)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof IFluidLike) {
            IFluidLike fluid = (IFluidLike)obj;
            if (fluid.asFluid() != Fluids.f_76191_) {
                ing = FluidIngredient.of((Fluid)fluid.asFluid(), (int)amount);
                fluids.add(fluid.asFluid());
            }
        } else if (obj instanceof IFluidLike[]) {
            IFluidLike[] fluidz = (IFluidLike[])obj;
            List<Fluid> nonEmpty = Arrays.stream(fluidz).map(IFluidLike::asFluid).filter(f -> f != Fluids.f_76191_).toList();
            if (!nonEmpty.isEmpty()) {
                ing = FluidIngredient.of((FluidIngredient[])((FluidIngredient[])nonEmpty.stream().map(f -> FluidIngredient.of((Fluid)f, (int)amount)).toArray(FluidIngredient[]::new)));
                fluids.addAll(nonEmpty);
            }
        } else if (obj instanceof JsonElement) {
            ing = FluidIngredient.deserialize((JsonElement)((JsonElement)obj), (String)"");
            fluids.addAll(ForgeRegistries.FLUIDS.getValues());
        }
        fluids.remove(Fluids.f_76191_);
        return Pair.of((Object)(fluids.isEmpty() ? null : ing), fluids);
    }

    public boolean registerMeltingRecipe(ResourceLocation key, Object input, Object output, int outputAmount, Object secondOutput, int secondOutputAmount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeSerializer(key, input, output, outputAmount, secondOutput, secondOutputAmount));
    }

    public boolean registerMeltingRecipe(ResourceLocation key, Object input, Object output, int outputAmount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeSerializer(key, input, output, outputAmount));
    }

    public boolean registerStampingRecipe(ResourceLocation key, Object stamp, Object itemInput, Object fluidInput, int fluidInputAmount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new StampingRecipeSerializer(key, stamp, itemInput, fluidInput, fluidInputAmount, output, outputCount));
    }

    public boolean registerStampingRecipe(ResourceLocation key, Object stamp, Object itemInput, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new StampingRecipeSerializer(key, stamp, itemInput, output, outputCount));
    }

    public boolean registerStampingRecipe(ResourceLocation key, Object stamp, Object fluidInput, int fluidInputAmount, Object output, int outputCount) {
        return ApiImpl.INSTANCE.registerRecipe(key, new StampingRecipeSerializer(key, stamp, fluidInput, fluidInputAmount, output, outputCount));
    }
}

