/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.createmetallurgy.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.simibubi.create.foundation.fluid.FluidIngredient;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.fluids.FluidStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.compat.create.CreateHelper;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class MeltingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object itemInput;
    public final Object fluidInput;
    public final int fluidInputAmount;
    public final Object secondFluidInput;
    public final int secondFluidInputAmount;
    public final Object itemOutput;
    public final int itemOutputCount;
    public final Object fluidOutput;
    public final int fluidOutputAmount;
    public final int time;
    public final int heatLevel;

    public MeltingRecipeSerializer(ResourceLocation key, Object itemInput, Object fluidOutput, int fluidOutputAmount, int time, int heatLevel) {
        this(key, itemInput, FluidStack.EMPTY, 0, FluidStack.EMPTY, 0, ItemStack.f_41583_, 0, fluidOutput, fluidOutputAmount, time, heatLevel);
    }

    public MeltingRecipeSerializer(ResourceLocation key, Object itemInput, Object itemOutput, int itemOutputCount, Object fluidOutput, int fluidOutputAmount, int time, int heatLevel) {
        this(key, itemInput, FluidStack.EMPTY, 0, FluidStack.EMPTY, 0, itemOutput, itemOutputCount, fluidOutput, fluidOutputAmount, time, heatLevel);
    }

    public MeltingRecipeSerializer(ResourceLocation key, Object itemInput, Object fluidInput, int fluidInputAmount, Object secondFluidInput, int secondFluidInputAmount, Object itemOutput, int itemOutputCount, Object fluidOutput, int fluidOutputAmount, int time, int heatLevel) {
        this.key = Objects.requireNonNull(key);
        this.itemInput = itemInput;
        this.fluidInput = fluidInput;
        this.fluidInputAmount = fluidInputAmount;
        this.secondFluidInput = secondFluidInput;
        this.secondFluidInputAmount = secondFluidInputAmount;
        this.itemOutput = itemOutput;
        this.itemOutputCount = itemOutputCount;
        this.fluidOutput = fluidOutput;
        this.fluidOutputAmount = fluidOutputAmount;
        this.time = time;
        this.heatLevel = heatLevel;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.itemInput);
        FluidIngredient fluidIng1 = CreateHelper.INSTANCE.getFluidIngredient(this.fluidInput, this.fluidInputAmount);
        FluidIngredient fluidIng2 = CreateHelper.INSTANCE.getFluidIngredient(this.secondFluidInput, this.secondFluidInputAmount);
        if (ing == EmptyIngredient.INSTANCE && fluidIng1 == null && fluidIng2 == null) {
            throw new IllegalArgumentException("Empty ingredients in recipe " + this.key + ": " + this.itemInput + ", " + this.fluidInput + ", " + this.secondFluidInput + ", ");
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.itemOutput, this.itemOutputCount);
        FluidStack fluidStack = MiscHelper.INSTANCE.getFluidStack(this.fluidOutput, this.fluidOutputAmount);
        if (stack.m_41619_() && fluidStack.isEmpty()) {
            throw new IllegalArgumentException("Empty outputs in recipe " + this.key + ": " + this.itemOutput + ", " + this.fluidOutput);
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "createmetallurgy:melting");
        JsonArray ingJson = new JsonArray();
        if (ing != EmptyIngredient.INSTANCE) {
            ingJson.add(ing.m_43942_());
        }
        if (fluidIng1 != null) {
            ingJson.add((JsonElement)fluidIng1.serialize());
        }
        if (fluidIng2 != null) {
            ingJson.add((JsonElement)fluidIng2.serialize());
        }
        json.add("ingredients", (JsonElement)ingJson);
        JsonArray resultJson = new JsonArray();
        if (!stack.m_41619_()) {
            resultJson.add((JsonElement)MiscHelper.INSTANCE.serializeItemStack(stack));
        }
        if (!fluidStack.isEmpty()) {
            resultJson.add((JsonElement)MiscHelper.INSTANCE.serializeFluidStack(fluidStack));
        }
        json.add("results", (JsonElement)resultJson);
        json.addProperty("processingTime", (Number)this.time);
        json.addProperty("heatRequirement", switch (this.heatLevel) {
            default -> "none";
            case 1 -> "heated";
            case 2 -> "superheated";
        });
        return json;
    }
}

