/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.createmetallurgy;

import fr.lucreeper74.createmetallurgy.content.casting.recipe.CastingOutput;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.commons.lang3.tuple.Pair;
import thelm.jaopca.compat.createmetallurgy.recipes.CastingBasinRecipeSerializer;
import thelm.jaopca.compat.createmetallurgy.recipes.CastingTableRecipeSerializer;
import thelm.jaopca.compat.createmetallurgy.recipes.MeltingRecipeSerializer;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

public class CreateMetallurgyHelper {
    public static final CreateMetallurgyHelper INSTANCE = new CreateMetallurgyHelper();

    private CreateMetallurgyHelper() {
    }

    public CastingOutput getCastingOutput(Object obj, int count) {
        return (CastingOutput)this.getCastingOutputResolved(obj, count).getLeft();
    }

    public Pair<CastingOutput, Set<Item>> getCastingOutputResolved(Object obj, int count) {
        CastingOutput out = CastingOutput.fromStack((ItemStack)ItemStack.f_41583_);
        HashSet<Item> items = new HashSet<Item>();
        if (obj instanceof Supplier) {
            Pair<CastingOutput, Set<Item>> pair = this.getCastingOutputResolved(((Supplier)obj).get(), count);
            out = (CastingOutput)pair.getLeft();
            items.addAll((Collection)pair.getRight());
        } else if (obj instanceof CastingOutput) {
            out = (CastingOutput)obj;
            items.addAll(ForgeRegistries.ITEMS.getValues());
        } else if (obj instanceof ItemStack) {
            ItemStack stack = (ItemStack)obj;
            if (!stack.m_41619_()) {
                out = CastingOutput.fromStack((ItemStack)stack);
                items.add(stack.m_41720_());
            }
        } else if (obj instanceof ItemLike) {
            ItemLike item = (ItemLike)obj;
            if (item.m_5456_() != Items.f_41852_) {
                out = CastingOutput.fromStack((ItemStack)new ItemStack(item, count));
                items.add(item.m_5456_());
            }
        } else if (obj instanceof String) {
            ResourceLocation location = new ResourceLocation((String)obj);
            out = CastingOutput.fromTag(MiscHelper.INSTANCE.getItemTagKey(location), (int)count);
            items.addAll(MiscHelper.INSTANCE.getItemTagValues(location));
        } else if (obj instanceof ResourceLocation) {
            ResourceLocation location = (ResourceLocation)obj;
            out = CastingOutput.fromTag(MiscHelper.INSTANCE.getItemTagKey(location), (int)count);
            items.addAll(MiscHelper.INSTANCE.getItemTagValues(location));
        } else if (obj instanceof TagKey) {
            TagKey key = (TagKey)obj;
            out = CastingOutput.fromTag((TagKey)key, (int)count);
            items.addAll(MiscHelper.INSTANCE.getItemTagValues(key.f_203868_()));
        }
        items.remove(Items.f_41852_);
        return Pair.of((Object)(items.isEmpty() ? null : out), items);
    }

    public boolean registerMeltingRecipe(ResourceLocation key, Object itemInput, Object fluidInput, int fluidInputAmount, Object secondFluidInput, int secondFluidInputAmount, Object itemOutput, int itemOutputCount, Object fluidOutput, int fluidOutputAmount, int time, int heatLevel) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeSerializer(key, itemInput, fluidInput, fluidInputAmount, secondFluidInput, secondFluidInputAmount, itemOutput, itemOutputCount, fluidOutput, fluidOutputAmount, time, heatLevel));
    }

    public boolean registerMeltingRecipe(ResourceLocation key, Object itemInput, Object itemOutput, int itemOutputCount, Object fluidOutput, int fluidOutputAmount, int time, int heatLevel) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeSerializer(key, itemInput, itemOutput, itemOutputCount, fluidOutput, fluidOutputAmount, time, heatLevel));
    }

    public boolean registerMeltingRecipe(ResourceLocation key, Object itemInput, Object fluidOutput, int fluidOutputAmount, int time, int heatLevel) {
        return ApiImpl.INSTANCE.registerRecipe(key, new MeltingRecipeSerializer(key, itemInput, fluidOutput, fluidOutputAmount, time, heatLevel));
    }

    public boolean registerCastingTableRecipe(ResourceLocation key, Object mold, Object input, int inputAmount, Object output, int outputCount, int time, boolean consumeMold) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingTableRecipeSerializer(key, mold, input, inputAmount, output, outputCount, time, consumeMold));
    }

    public boolean registerCastingBasinRecipe(ResourceLocation key, Object mold, Object input, int inputAmount, Object output, int outputCount, int time, boolean consumeMold) {
        return ApiImpl.INSTANCE.registerRecipe(key, new CastingBasinRecipeSerializer(key, mold, input, inputAmount, output, outputCount, time, consumeMold));
    }
}

