/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.createdd.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.ingredients.EmptyIngredient;
import thelm.jaopca.utils.MiscHelper;

public class SeethingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object[] output;

    public SeethingRecipeSerializer(ResourceLocation key, Object input, Object ... output) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == EmptyIngredient.INSTANCE) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ArrayList<Pair> outputs = new ArrayList<Pair>();
        int i = 0;
        while (i < this.output.length) {
            ItemStack stack;
            Object out = this.output[i];
            Integer count = 1;
            if (++i < this.output.length && this.output[i] instanceof Integer) {
                count = (Integer)this.output[i];
                ++i;
            }
            Float chance = Float.valueOf(1.0f);
            if (i < this.output.length && this.output[i] instanceof Float) {
                chance = (Float)this.output[i];
                ++i;
            }
            if ((stack = MiscHelper.INSTANCE.getItemStack(out, count)).m_41619_()) {
                LOGGER.warn("Empty output in recipe {}: {}", (Object)this.key, out);
                continue;
            }
            outputs.add(Pair.of((Object)stack, (Object)chance));
        }
        if (outputs.isEmpty()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + Arrays.deepToString(this.output));
        }
        JsonObject json = new JsonObject();
        json.addProperty("type", "create_dd:seething");
        JsonArray ingJson = new JsonArray();
        ingJson.add(ing.m_43942_());
        json.add("ingredients", (JsonElement)ingJson);
        JsonArray resultJson = new JsonArray();
        for (Pair pair : outputs) {
            JsonObject outputJson = MiscHelper.INSTANCE.serializeItemStack((ItemStack)pair.getLeft());
            outputJson.addProperty("chance", (Number)pair.getRight());
            resultJson.add((JsonElement)outputJson);
        }
        json.add("results", (JsonElement)resultJson);
        return json;
    }
}

