/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.bloodmagic;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import thelm.jaopca.api.JAOPCAApi;
import thelm.jaopca.api.config.IDynamicSpecConfig;
import thelm.jaopca.api.materials.IMaterial;
import thelm.jaopca.api.materials.MaterialType;
import thelm.jaopca.api.modules.IModule;
import thelm.jaopca.api.modules.IModuleData;
import thelm.jaopca.api.modules.JAOPCAModule;
import thelm.jaopca.compat.bloodmagic.BloodMagicHelper;
import thelm.jaopca.utils.ApiImpl;
import thelm.jaopca.utils.MiscHelper;

@JAOPCAModule(modDependencies={"bloodmagic"})
public class BloodMagicCompatModule
implements IModule {
    private static final Set<String> TO_DUST_BLACKLIST = new TreeSet<String>(List.of("copper", "gold", "hellforged", "iron", "netherite_scrap"));
    private static Set<String> configToDustBlacklist = new TreeSet<String>();

    @Override
    public String getName() {
        return "bloodmagic_compat";
    }

    @Override
    public Set<MaterialType> getMaterialTypes() {
        return EnumSet.allOf(MaterialType.class);
    }

    @Override
    public void defineModuleConfig(IModuleData moduleData, IDynamicSpecConfig config) {
        MiscHelper helper = MiscHelper.INSTANCE;
        helper.caclulateMaterialSet(config.getDefinedStringList("recipes.toDustMaterialBlacklist", new ArrayList<String>(), helper.configMaterialPredicate(), "The materials that should not have ARC to dust recipes added."), configToDustBlacklist);
    }

    @Override
    public void onCommonSetup(IModuleData moduleData, FMLCommonSetupEvent event) {
        ApiImpl api = ApiImpl.INSTANCE;
        BloodMagicHelper helper = BloodMagicHelper.INSTANCE;
        MiscHelper miscHelper = MiscHelper.INSTANCE;
        ResourceLocation explosiveLocation = new ResourceLocation("bloodmagic:arc/explosive");
        for (IMaterial material : moduleData.getMaterials()) {
            MaterialType type = material.getType();
            String name = material.getName();
            if (!type.isIngot() || TO_DUST_BLACKLIST.contains(name) || configToDustBlacklist.contains(name)) continue;
            ResourceLocation materialLocation = miscHelper.getTagLocation(material.getType().getFormName(), material.getName());
            ResourceLocation dustLocation = miscHelper.getTagLocation("dusts", material.getName());
            if (!((JAOPCAApi)api).getItemTags().contains(dustLocation)) continue;
            helper.registerARCRecipe(new ResourceLocation("jaopca", "bloodmagic.material_to_dust." + material.getName()), materialLocation, 1, explosiveLocation, new Object[]{dustLocation, 1}, false);
        }
    }
}

