/*
 * Decompiled with CFR 0.152.
 */
package thelm.jaopca.compat.actuallyadditions.recipes;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.Objects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import thelm.jaopca.api.recipes.IRecipeSerializer;
import thelm.jaopca.utils.MiscHelper;

public class CrushingRecipeSerializer
implements IRecipeSerializer {
    private static final Logger LOGGER = LogManager.getLogger();
    public final ResourceLocation key;
    public final Object input;
    public final Object output;
    public final int outputCount;
    public final float outputChance;
    public final Object secondOutput;
    public final int secondOutputCount;
    public final float secondChance;

    public CrushingRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, float outputChance) {
        this(key, input, output, outputCount, outputChance, ItemStack.f_41583_, 0, 0.0f);
    }

    public CrushingRecipeSerializer(ResourceLocation key, Object input, Object output, int outputCount, float outputChance, Object secondOutput, int secondOutputCount, float secondChance) {
        this.key = Objects.requireNonNull(key);
        this.input = input;
        this.output = output;
        this.outputCount = outputCount;
        this.outputChance = outputChance;
        this.secondOutput = secondOutput;
        this.secondOutputCount = secondOutputCount;
        this.secondChance = secondChance;
    }

    @Override
    public JsonElement get() {
        Ingredient ing = MiscHelper.INSTANCE.getIngredient(this.input);
        if (ing == null) {
            throw new IllegalArgumentException("Empty ingredient in recipe " + this.key + ": " + this.input);
        }
        ItemStack stack = MiscHelper.INSTANCE.getItemStack(this.output, this.outputCount);
        if (stack.m_41619_()) {
            throw new IllegalArgumentException("Empty output in recipe " + this.key + ": " + this.output);
        }
        ItemStack secondStack = MiscHelper.INSTANCE.getItemStack(this.secondOutput, this.secondOutputCount);
        JsonObject json = new JsonObject();
        json.addProperty("type", "actuallyadditions:crushing");
        json.add("ingredient", ing.m_43942_());
        JsonArray resultJson = new JsonArray();
        JsonObject firstJson = new JsonObject();
        firstJson.addProperty("chance", (Number)Float.valueOf(this.outputChance));
        firstJson.add("result", (JsonElement)ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)stack).get().orThrow());
        resultJson.add((JsonElement)firstJson);
        if (!secondStack.m_41619_()) {
            JsonObject secondJson = new JsonObject();
            secondJson.addProperty("chance", (Number)Float.valueOf(this.secondChance));
            secondJson.add("result", (JsonElement)ItemStack.f_41582_.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)secondStack).get().orThrow());
            resultJson.add((JsonElement)secondJson);
        }
        json.add("result", (JsonElement)resultJson);
        return json;
    }
}

