/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client;

import blusunrize.immersiveengineering.common.blocks.IEBlockInterfaces;
import blusunrize.immersiveengineering.common.items.IEItemInterfaces;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import blusunrize.immersiveengineering.common.register.IEItems;
import javax.annotation.Nullable;
import net.minecraft.client.color.block.BlockColor;
import net.minecraft.client.color.item.ItemColor;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RegisterColorHandlersEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.RegistryObject;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="immersiveengineering", bus=Mod.EventBusSubscriber.Bus.MOD)
public class IEDefaultColourHandlers
implements ItemColor,
BlockColor {
    public static IEDefaultColourHandlers INSTANCE = new IEDefaultColourHandlers();

    @SubscribeEvent
    public static void registerItemColors(RegisterColorHandlersEvent.Item ev) {
        for (RegistryObject itemRO : IEItems.REGISTER.getEntries()) {
            Item item = (Item)itemRO.get();
            if (!(item instanceof IEItemInterfaces.IColouredItem)) continue;
            ev.register((ItemColor)INSTANCE, new ItemLike[]{item});
        }
    }

    @SubscribeEvent
    public static void registerBlockColors(RegisterColorHandlersEvent.Block ev) {
        for (IEBlocks.BlockEntry<?> blockEntry : IEBlocks.BlockEntry.ALL_ENTRIES) {
            IEBlockInterfaces.IColouredBlock colouredBlock;
            Object block = blockEntry.get();
            if (!(block instanceof IEBlockInterfaces.IColouredBlock) || !(colouredBlock = (IEBlockInterfaces.IColouredBlock)block).hasCustomBlockColours()) continue;
            ev.register((BlockColor)INSTANCE, new Block[]{block});
        }
    }

    public int m_92566_(BlockState state, @Nullable BlockAndTintGetter worldIn, @Nullable BlockPos pos, int tintIndex) {
        Block block = state.m_60734_();
        if (block instanceof IEBlockInterfaces.IColouredBlock) {
            IEBlockInterfaces.IColouredBlock colouredBlock = (IEBlockInterfaces.IColouredBlock)block;
            return colouredBlock.getRenderColour(state, (BlockGetter)worldIn, pos, tintIndex);
        }
        return 0xFFFFFF;
    }

    public int m_92671_(ItemStack stack, int tintIndex) {
        Item item = stack.m_41720_();
        if (item instanceof IEItemInterfaces.IColouredItem) {
            IEItemInterfaces.IColouredItem colouredItem = (IEItemInterfaces.IColouredItem)item;
            return colouredItem.getColourForIEItem(stack, tintIndex);
        }
        return 0xFFFFFF;
    }
}

