/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import java.util.Random;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Rotation;

public class RotationHelper {
    private static final PivotRotation[] ROTATION_MAP = new PivotRotation[6];
    private static final Direction[] DIRECTIONS = Direction.values();
    private static final Direction[][][] ROTATION_MATRIX = new Direction[][][]{{{Direction.DOWN, Direction.NORTH, Direction.UP, Direction.SOUTH}, {Direction.DOWN}, {Direction.DOWN, Direction.EAST, Direction.UP, Direction.WEST}}, {{Direction.UP, Direction.SOUTH, Direction.DOWN, Direction.NORTH}, {Direction.UP}, {Direction.UP, Direction.WEST, Direction.DOWN, Direction.EAST}}, {{Direction.NORTH, Direction.UP, Direction.SOUTH, Direction.DOWN}, {Direction.NORTH, Direction.EAST, Direction.SOUTH, Direction.WEST}, {Direction.NORTH}}, {{Direction.SOUTH, Direction.DOWN, Direction.NORTH, Direction.UP}, {Direction.SOUTH, Direction.WEST, Direction.NORTH, Direction.EAST}, {Direction.SOUTH}}, {{Direction.WEST}, {Direction.WEST, Direction.NORTH, Direction.EAST, Direction.SOUTH}, {Direction.WEST, Direction.DOWN, Direction.EAST, Direction.UP}}, {{Direction.EAST}, {Direction.EAST, Direction.SOUTH, Direction.WEST, Direction.NORTH}, {Direction.EAST, Direction.UP, Direction.WEST, Direction.DOWN}}};

    public static Direction rotate(Direction dir, Direction.Axis axis, Direction.AxisDirection axisDir, Rotation rotate) {
        int nextIdx;
        Direction[][] mat = ROTATION_MATRIX[dir.ordinal()];
        Direction[] rot = mat[axis.ordinal()];
        for (nextIdx = rotate.ordinal() * axisDir.m_122540_(); nextIdx < 0; nextIdx += rot.length) {
        }
        while (nextIdx >= rot.length) {
            nextIdx -= rot.length;
        }
        return rot[nextIdx];
    }

    public static PivotRotation getRotationFromHorizontal(Direction horizontal) {
        return ROTATION_MAP[horizontal.ordinal()];
    }

    public static BlockPos rotateAroundPivot(BlockPos pivot, Direction horizontal, BlockPos relative) {
        return ROTATION_MAP[horizontal.ordinal()].transform(pivot, relative);
    }

    public static enum PivotRotation {
        Y_0(Direction.NORTH, (pivot, pos) -> pos.m_7949_()),
        Y_90(Direction.WEST, (pivot, pos) -> new BlockPos(pivot.m_123341_() + (pos.m_123343_() - pivot.m_123343_()), pos.m_123342_(), pivot.m_123343_() - (pos.m_123341_() - pivot.m_123341_()))),
        Y_180(Direction.SOUTH, (pivot, pos) -> new BlockPos(pivot.m_123341_() - (pos.m_123341_() - pivot.m_123341_()), pos.m_123342_(), pivot.m_123343_() - (pos.m_123343_() - pivot.m_123343_()))),
        Y_270(Direction.EAST, (pivot, pos) -> new BlockPos(pivot.m_123341_() - (pos.m_123343_() - pivot.m_123343_()), pos.m_123342_(), pivot.m_123343_() + (pos.m_123341_() - pivot.m_123341_())));

        private static final PivotRotation[] VALUES;
        final Direction face;
        final BiFunction<BlockPos, BlockPos, BlockPos> transformer;

        public static PivotRotation rand(Random rng) {
            return VALUES[rng.nextInt(VALUES.length)];
        }

        private PivotRotation(Direction face, BiFunction<BlockPos, BlockPos, BlockPos> transformer) {
            this.face = face;
            this.transformer = transformer;
            RotationHelper.ROTATION_MAP[face.ordinal()] = this;
        }

        public BlockPos transform(BlockPos pivot, BlockPos pos) {
            return this.transformer.apply(pivot, pos);
        }

        public Direction toHorizontal() {
            return this.face;
        }

        static {
            VALUES = PivotRotation.values();
        }
    }
}

