/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import it.unimi.dsi.fastutil.objects.Object2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilder;
import org.zeith.hammerlib.util.shaded.json.JSONObject;
import org.zeith.hammerlib.util.shaded.json.JSONTokener;

public class RecipeRegistrationContext {
    public static final Logger LOG = LogManager.getLogger(RecipeRegistrationContext.class);
    private final Path file;
    private boolean changed;
    private final Map<String, RecipesData> allRecipes = new HashMap<String, RecipesData>();
    protected final Runnable markChanged = this::markChanged;

    public RecipeRegistrationContext(Path file) {
        this.file = file;
    }

    private void markChanged() {
        this.changed = true;
    }

    protected RecipesData create(String key) {
        return new RecipesData(key, (Object2BooleanMap<String>)new Object2BooleanArrayMap(), new HashSet<String>(), this.markChanged);
    }

    public boolean enableRecipe(RecipeType<?> type, ResourceLocation id) {
        String idKey = id.toString();
        ResourceLocation rt = ForgeRegistries.RECIPE_TYPES.getKey(type);
        String key = rt == null ? "<unknown>" : rt.toString();
        RecipesData unknown = this.allRecipes.get("<unknown>");
        RecipesData data = this.allRecipes.computeIfAbsent(key, this::create);
        if (unknown != null && unknown.active.containsKey((Object)idKey)) {
            data.active.put((Object)idKey, unknown.active.removeBoolean((Object)idKey));
        }
        return data.enableRecipe(idKey);
    }

    public <RES, T extends RecipeBuilder<T, RES>> Optional<T> register(RecipeType<?> type, @NotNull T builder) {
        if (this.enableRecipe(type, builder.getIdentifier())) {
            builder.register();
            return Optional.of(builder);
        }
        return Optional.empty();
    }

    public static RecipeRegistrationContext load(String modid) {
        Path recipes = FMLPaths.CONFIGDIR.get().resolve("hammerlib").resolve("recipes").resolve("modded").resolve(modid + ".json");
        RecipeRegistrationContext ctx = new RecipeRegistrationContext(recipes);
        try {
            Files.createDirectories(recipes.getParent(), new FileAttribute[0]);
            if (Files.isRegularFile(recipes, new LinkOption[0])) {
                new JSONTokener(Files.readString(recipes)).nextValueOBJ().ifPresent(obj -> {
                    int vers = obj.optInt("version");
                    if (vers == 0) {
                        JSONObject[] objs;
                        Object2BooleanArrayMap toResolve = new Object2BooleanArrayMap();
                        for (JSONObject $ : objs = new JSONObject[]{obj.getJSONObject("active"), obj.getJSONObject("unregistered")}) {
                            for (String key : $.keySet()) {
                                toResolve.put((Object)key, $.optBoolean(key, true));
                            }
                        }
                        ctx.allRecipes.computeIfAbsent((String)"<unknown>", (Function<String, RecipesData>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, create(java.lang.String ), (Ljava/lang/String;)Lorg/zeith/hammerlib/util/mcf/RecipeRegistrationContext$RecipesData;)((RecipeRegistrationContext)ctx)).active.putAll((Map)toResolve);
                        ctx.markChanged();
                        LOG.info("Upgrade recipe registration context of {} to v2", (Object)recipes.getFileName());
                        return;
                    }
                    if (vers == 2) {
                        JSONObject[] objs;
                        for (JSONObject $ : objs = new JSONObject[]{obj.getJSONObject("active"), obj.getJSONObject("unregistered")}) {
                            for (String type : $.keySet()) {
                                RecipesData storage = ctx.allRecipes.computeIfAbsent(type, ctx::create);
                                JSONObject $$ = $.optJSONObject(type);
                                if ($$ == null) continue;
                                for (String key : $$.keySet()) {
                                    storage.active.put((Object)key, $$.optBoolean(key, true));
                                }
                            }
                        }
                    }
                });
            }
        }
        catch (IOException err) {
            err.printStackTrace();
        }
        return ctx;
    }

    public void save() {
        if (this.changed) {
            JSONObject activeGlob = new JSONObject();
            JSONObject disabledGlob = new JSONObject();
            Function<String, JSONObject> activeByType = type -> {
                if (activeGlob.has((String)type)) {
                    return activeGlob.getJSONObject((String)type);
                }
                return activeGlob.put((String)type, new JSONObject()).getJSONObject((String)type);
            };
            Function<String, JSONObject> disabledByType = type -> {
                if (disabledGlob.has((String)type)) {
                    return disabledGlob.getJSONObject((String)type);
                }
                return disabledGlob.put((String)type, new JSONObject()).getJSONObject((String)type);
            };
            for (Map.Entry<String, RecipesData> entry : this.allRecipes.entrySet()) {
                RecipesData e = entry.getValue();
                if (e.active.isEmpty()) continue;
                LazyOptional active = LazyOptional.of(() -> (JSONObject)activeByType.apply((String)entry.getKey()));
                LazyOptional disabled = LazyOptional.of(() -> (JSONObject)disabledByType.apply((String)entry.getKey()));
                for (Object2BooleanMap.Entry st : e.active.object2BooleanEntrySet()) {
                    (e.usedKeys.contains(st.getKey()) ? active : disabled).resolve().orElse(new JSONObject()).put((String)st.getKey(), st.getBooleanValue());
                }
            }
            try {
                Files.createDirectories(this.file.getParent(), new FileAttribute[0]);
                Files.writeString(this.file, (CharSequence)new JSONObject().put("version", 2).put("active", activeGlob).put("unregistered", disabledGlob).toString(4), new OpenOption[0]);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected record RecipesData(String type, Object2BooleanMap<String> active, Set<String> usedKeys, Runnable changed) {
        public boolean enableRecipe(String id) {
            this.usedKeys.add(id);
            if (!this.active.containsKey((Object)id)) {
                this.active.put((Object)id, true);
                this.changed.run();
            }
            return this.active.getBoolean((Object)id);
        }
    }
}

