/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.util.List;
import java.util.Random;
import java.util.function.Consumer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class AABBUtils {
    public static boolean almostEqual(double a, double b) {
        return Math.abs(a - b) < 1.0E-4;
    }

    public static Vec3 randomPosWithin(AABB aabb, Random rng) {
        return new Vec3(Mth.m_14139_((double)rng.nextDouble(), (double)aabb.f_82288_, (double)aabb.f_82291_), Mth.m_14139_((double)rng.nextDouble(), (double)aabb.f_82289_, (double)aabb.f_82292_), Mth.m_14139_((double)rng.nextDouble(), (double)aabb.f_82290_, (double)aabb.f_82293_));
    }

    public static Vec3 randomPosWithin(AABB aabb, RandomSource rng) {
        return new Vec3(Mth.m_14139_((double)rng.m_188500_(), (double)aabb.f_82288_, (double)aabb.f_82291_), Mth.m_14139_((double)rng.m_188500_(), (double)aabb.f_82289_, (double)aabb.f_82292_), Mth.m_14139_((double)rng.m_188500_(), (double)aabb.f_82290_, (double)aabb.f_82293_));
    }

    public static AABB rotate(AABB aabb, Rotation rotationIn) {
        return switch (rotationIn) {
            default -> aabb;
            case Rotation.CLOCKWISE_90 -> new AABB(-aabb.f_82288_, aabb.f_82289_, aabb.f_82290_, -aabb.f_82291_, aabb.f_82292_, aabb.f_82293_);
            case Rotation.CLOCKWISE_180 -> new AABB(-aabb.f_82288_, aabb.f_82289_, -aabb.f_82290_, -aabb.f_82291_, aabb.f_82292_, -aabb.f_82293_);
            case Rotation.COUNTERCLOCKWISE_90 -> new AABB(aabb.f_82288_, aabb.f_82289_, -aabb.f_82290_, aabb.f_82291_, aabb.f_82292_, -aabb.f_82293_);
        };
    }

    public static AABB normalize(AABB aabb) {
        return aabb.m_82386_(-aabb.f_82288_, -aabb.f_82289_, -aabb.f_82290_);
    }

    public static AABB lerp(AABB prev, AABB cur, float pv) {
        return new AABB(Mth.m_14139_((double)pv, (double)prev.f_82288_, (double)cur.f_82288_), Mth.m_14139_((double)pv, (double)prev.f_82289_, (double)cur.f_82289_), Mth.m_14139_((double)pv, (double)prev.f_82290_, (double)cur.f_82290_), Mth.m_14139_((double)pv, (double)prev.f_82291_, (double)cur.f_82291_), Mth.m_14139_((double)pv, (double)prev.f_82292_, (double)cur.f_82292_), Mth.m_14139_((double)pv, (double)prev.f_82293_, (double)cur.f_82293_));
    }

    public static AABB extrudeGravity(AABB aabb, float ySpeed) {
        float ay = Math.abs(ySpeed);
        return aabb.m_82377_((double)(-ay) * (aabb.f_82291_ - aabb.f_82288_) / 2.0, (double)ay * (aabb.f_82292_ - aabb.f_82289_) / 2.0, (double)(-ay) * (aabb.f_82293_ - aabb.f_82290_) / 2.0).m_82386_(0.0, (double)(-ySpeed) * (aabb.f_82292_ - aabb.f_82289_) / 2.0, 0.0);
    }

    public static void cut(AABB box, AABB knife, List<AABB> intoList) {
        AABBUtils.cut(box, knife, intoList::add);
    }

    public static void cut(AABB box, AABB knife, Consumer<AABB> intoList) {
        boolean ea2;
        boolean ea1;
        if (!box.m_82381_(knife)) {
            intoList.accept(box);
            return;
        }
        AABB inter = box.m_82323_(knife);
        if (!AABBUtils.almostEqual(box.f_82289_, inter.f_82289_)) {
            intoList.accept(new AABB(box.f_82288_, box.f_82289_, box.f_82290_, box.f_82291_, inter.f_82289_, box.f_82293_));
        }
        if (!AABBUtils.almostEqual(box.f_82292_, inter.f_82292_)) {
            intoList.accept(new AABB(box.f_82288_, inter.f_82292_, box.f_82290_, box.f_82291_, box.f_82292_, box.f_82293_));
        }
        if (ea1 = !AABBUtils.almostEqual(box.f_82291_, inter.f_82291_)) {
            intoList.accept(new AABB(inter.f_82291_, inter.f_82289_, box.f_82290_, box.f_82291_, inter.f_82292_, inter.f_82293_));
        }
        if (ea2 = !AABBUtils.almostEqual(box.f_82293_, inter.f_82293_)) {
            intoList.accept(new AABB(box.f_82288_, inter.f_82289_, inter.f_82293_, inter.f_82291_, inter.f_82292_, box.f_82293_));
        }
        if (ea1 && ea2) {
            intoList.accept(new AABB(inter.f_82291_, inter.f_82289_, inter.f_82293_, box.f_82291_, inter.f_82292_, box.f_82293_));
        }
        if (ea1 = !AABBUtils.almostEqual(box.f_82290_, inter.f_82290_)) {
            intoList.accept(new AABB(inter.f_82288_, inter.f_82289_, box.f_82290_, inter.f_82291_, inter.f_82292_, inter.f_82290_));
        }
        if (ea2 = !AABBUtils.almostEqual(box.f_82288_, inter.f_82288_)) {
            intoList.accept(new AABB(box.f_82288_, inter.f_82289_, inter.f_82290_, inter.f_82288_, inter.f_82292_, inter.f_82293_));
        }
        if (ea1 || ea2) {
            intoList.accept(new AABB(box.f_82288_, inter.f_82289_, box.f_82290_, inter.f_82288_, inter.f_82292_, inter.f_82290_));
        }
    }

    @Deprecated
    public static Vec3 getCenter(AABB aabb) {
        return aabb.m_82399_();
    }
}

