/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter.recipe;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.core.adapter.recipe.RecipeBuilderMC;
import org.zeith.hammerlib.core.recipes.HLShapelessRecipe;
import org.zeith.hammerlib.core.recipes.replacers.IRemainingItemReplacer;
import org.zeith.hammerlib.core.recipes.replacers.RemainingReplacerRegistrar;
import org.zeith.hammerlib.util.mcf.itf.IRecipeRegistrationEvent;

public class ShapelessRecipeBuilder
extends RecipeBuilderMC<ShapelessRecipeBuilder> {
    protected final NonNullList<Ingredient> ingredients = NonNullList.m_122779_();
    protected final List<ResourceLocation> replacers = new ArrayList<ResourceLocation>();
    protected CraftingBookCategory category = CraftingBookCategory.MISC;

    public ShapelessRecipeBuilder(IRecipeRegistrationEvent<Recipe<?>> event) {
        super(event);
    }

    public ShapelessRecipeBuilder replacers(IRemainingItemReplacer ... replacers) {
        Stream.of(replacers).map(RemainingReplacerRegistrar::key).filter(Objects::nonNull).forEach(this.replacers::add);
        return this;
    }

    public ShapelessRecipeBuilder category(CraftingBookCategory cat) {
        this.category = cat;
        return this;
    }

    public ShapelessRecipeBuilder add(Object ingredient) {
        this.ingredients.add((Object)RecipeHelper.fromComponent(ingredient));
        return this;
    }

    public ShapelessRecipeBuilder addAll(Object ... ingredients) {
        for (Object ingredient : ingredients) {
            this.ingredients.add((Object)RecipeHelper.fromComponent(ingredient));
        }
        return this;
    }

    public ShapelessRecipeBuilder addAll(Iterable<Object> ingredients) {
        for (Object ingredient : ingredients) {
            this.ingredients.add((Object)RecipeHelper.fromComponent(ingredient));
        }
        return this;
    }

    @Override
    public void register() {
        this.validate();
        if (!this.event.enableRecipe(RecipeType.f_44107_, this.getIdentifier())) {
            return;
        }
        if (this.ingredients.isEmpty()) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " does not have any defined ingredients!");
        }
        ResourceLocation id = this.getIdentifier();
        HLShapelessRecipe rec = new HLShapelessRecipe(id, this.group, this.category, this.ingredients, this.result);
        rec.addReplacers(this.replacers);
        this.event.register(id, rec);
    }
}

