/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.recipes;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.zeith.hammerlib.abstractions.recipes.IVisualizedRecipe;
import org.zeith.hammerlib.client.render.IGuiDrawable;
import org.zeith.hammerlib.util.java.reflection.Accessor;

public interface IRecipeVisualizer<T extends Recipe<?>, VIS extends IVisualizedRecipe<T>> {
    public VisualizedRecipeGroup getGroup();

    public Class<VIS> getVisualizedType();

    public VIS visualize(T var1);

    public static <T extends Recipe<?>, VIS extends IVisualizedRecipe<T>> IRecipeVisualizer<T, VIS> simple(final Class<VIS> baseVisType, final VisualizedRecipeGroup group, final Function<T, VIS> fun) {
        return new IRecipeVisualizer<T, VIS>(){

            @Override
            public VisualizedRecipeGroup getGroup() {
                return group;
            }

            @Override
            public Class<VIS> getVisualizedType() {
                return baseVisType;
            }

            @Override
            public VIS visualize(T recipe) {
                return (IVisualizedRecipe)fun.apply(recipe);
            }
        };
    }

    public static VisualizedRecipeGroupBuilder groupBuilder() {
        return new VisualizedRecipeGroupBuilder();
    }

    public record VisualizedRecipeGroup(Component title, int width, int height, IGuiDrawable icon, List<ItemStack> catalyst, List<ClickArea> clickAreas) {
    }

    public static class VisualizedRecipeGroupBuilder {
        protected Component title = Component.m_237113_((String)"");
        protected int width = 116;
        protected int height = 54;
        protected IGuiDrawable icon = IGuiDrawable.EMPTY;
        protected List<ItemStack> catalysts = new ArrayList<ItemStack>();
        protected List<ClickArea> clickAreas = new ArrayList<ClickArea>();

        public VisualizedRecipeGroupBuilder clickArea(ClickArea area) {
            this.clickAreas.add(area);
            return this;
        }

        public VisualizedRecipeGroupBuilder title(Component title) {
            this.title = title;
            return this;
        }

        public VisualizedRecipeGroupBuilder size(int width, int height) {
            this.width = width;
            this.height = height;
            return this;
        }

        public VisualizedRecipeGroupBuilder icon(IGuiDrawable icon) {
            this.icon = icon;
            return this;
        }

        public VisualizedRecipeGroupBuilder catalyst(ItemStack ... items) {
            this.catalysts.addAll(List.of(items));
            return this;
        }

        public VisualizedRecipeGroupBuilder catalyst(Collection<ItemStack> items) {
            this.catalysts.addAll(List.copyOf(items));
            return this;
        }

        public VisualizedRecipeGroup build() {
            return new VisualizedRecipeGroup(this.title, this.width, this.height, this.icon, this.catalysts, this.clickAreas);
        }
    }

    public record ClickArea(Class<? extends AbstractContainerScreen<?>> menu, int x, int y, int width, int height) {
    }

    public record AssignedClickArea(RecipeType<?> type, ClickArea area) {
    }

    public record JeiBasedClickArea(Accessor type, ClickArea area) {
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.FIELD})
    public static @interface JEIClickArea {
    }
}

