/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import com.google.common.collect.ImmutableList;
import fi.dy.masa.litematica.render.schematic.WorldRendererSchematic;
import fi.dy.masa.litematica.world.ChunkManagerSchematic;
import fi.dy.masa.litematica.world.ChunkSchematic;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.ticks.BlackholeTickAccess;
import net.minecraft.world.ticks.LevelTickAccess;
import org.jetbrains.annotations.Nullable;

public class WorldSchematic
extends Level {
    protected static final ResourceKey<Level> REGISTRY_KEY = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation("forgematica", "schematic_world"));
    protected final Minecraft mc = Minecraft.m_91087_();
    protected final ChunkManagerSchematic chunkManagerSchematic;
    protected final Holder<Biome> biome;
    @Nullable
    protected final WorldRendererSchematic worldRenderer;
    protected int nextEntityId;
    protected int entityCount;

    public WorldSchematic(WritableLevelData properties, Holder<DimensionType> dimension, Supplier<ProfilerFiller> supplier, @Nullable WorldRendererSchematic worldRenderer) {
        super(properties, REGISTRY_KEY, Minecraft.m_91087_().m_91403_().m_105152_(), dimension, supplier, true, false, 0L, 0);
        this.worldRenderer = worldRenderer;
        this.chunkManagerSchematic = new ChunkManagerSchematic(this);
        this.biome = this.mc.f_91073_.m_9598_().m_175515_(Registries.f_256952_).m_246971_(Biomes.f_48202_);
    }

    public ChunkManagerSchematic getChunkProvider() {
        return this.chunkManagerSchematic;
    }

    public ChunkManagerSchematic getChunkManager() {
        return this.chunkManagerSchematic;
    }

    public LevelTickAccess<Block> m_183326_() {
        return BlackholeTickAccess.m_193145_();
    }

    public LevelTickAccess<Fluid> m_183324_() {
        return BlackholeTickAccess.m_193145_();
    }

    public int getRegularEntityCount() {
        return this.entityCount;
    }

    public LevelChunk m_46745_(BlockPos pos) {
        return this.getChunk(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
    }

    public ChunkSchematic getChunk(int chunkX, int chunkZ) {
        return this.chunkManagerSchematic.getChunk(chunkX, chunkZ);
    }

    public ChunkAccess m_6522_(int chunkX, int chunkZ, ChunkStatus status, boolean required) {
        return this.getChunk(chunkX, chunkZ);
    }

    public Holder<Biome> m_203675_(int biomeX, int biomeY, int biomeZ) {
        return this.biome;
    }

    public boolean m_7731_(BlockPos pos, BlockState newState, int flags) {
        if (pos.m_123342_() < this.m_141937_() || pos.m_123342_() >= this.m_151558_()) {
            return false;
        }
        return this.getChunk(pos.m_123341_() >> 4, pos.m_123343_() >> 4).m_6978_(pos, newState, false) != null;
    }

    public boolean m_7967_(Entity entity) {
        int chunkZ;
        int chunkX = Mth.m_14107_((double)(entity.m_20185_() / 16.0));
        if (!this.chunkManagerSchematic.m_5563_(chunkX, chunkZ = Mth.m_14107_((double)(entity.m_20189_() / 16.0)))) {
            return false;
        }
        entity.m_20234_(this.nextEntityId++);
        this.chunkManagerSchematic.getChunk(chunkX, chunkZ).m_6286_(entity);
        ++this.entityCount;
        return true;
    }

    public void unloadedEntities(int count) {
        this.entityCount -= count;
    }

    @Nullable
    public Entity m_6815_(int id) {
        return null;
    }

    public List<? extends Player> m_6907_() {
        return ImmutableList.of();
    }

    public long m_46467_() {
        return this.mc.f_91073_ != null ? this.mc.f_91073_.m_46467_() : 0L;
    }

    @Nullable
    public MapItemSavedData m_7489_(String id) {
        return null;
    }

    public void m_142325_(String name, MapItemSavedData mapState) {
    }

    public int m_7354_() {
        return 0;
    }

    public Scoreboard m_6188_() {
        return this.mc.f_91073_ != null ? this.mc.f_91073_.m_6188_() : null;
    }

    public RecipeManager m_7465_() {
        return this.mc.f_91073_ != null ? this.mc.f_91073_.m_7465_() : null;
    }

    protected LevelEntityGetter<Entity> m_142646_() {
        return null;
    }

    public List<Entity> m_6249_(@Nullable Entity except, AABB box, Predicate<? super Entity> predicate) {
        ArrayList<Entity> entities = new ArrayList<Entity>();
        List<ChunkSchematic> chunks = this.getChunksWithinBox(box);
        for (ChunkSchematic chunk : chunks) {
            chunk.getEntityList().forEach(e -> {
                if (e != except && box.m_82381_(e.m_20191_()) && predicate.test((Entity)e)) {
                    entities.add((Entity)e);
                }
            });
        }
        return entities;
    }

    public <T extends Entity> List<T> m_142425_(EntityTypeTest<Entity, T> arg, AABB box, Predicate<? super T> predicate) {
        ArrayList<Entity> list = new ArrayList<Entity>();
        for (Entity e2 : this.m_6249_(null, box, e -> true)) {
            Entity t = (Entity)arg.m_141992_((Object)e2);
            if (t == null || !predicate.test(t)) continue;
            list.add(t);
        }
        return list;
    }

    public List<ChunkSchematic> getChunksWithinBox(AABB box) {
        int minX = Mth.m_14107_((double)(box.f_82288_ / 16.0));
        int minZ = Mth.m_14107_((double)(box.f_82290_ / 16.0));
        int maxX = Mth.m_14107_((double)(box.f_82291_ / 16.0));
        int maxZ = Mth.m_14107_((double)(box.f_82293_ / 16.0));
        ArrayList<ChunkSchematic> chunks = new ArrayList<ChunkSchematic>();
        for (int cx = minX; cx <= maxX; ++cx) {
            for (int cz = minZ; cz <= maxZ; ++cz) {
                ChunkSchematic chunk = this.chunkManagerSchematic.getChunkIfExists(cx, cz);
                if (chunk == null) continue;
                chunks.add(chunk);
            }
        }
        return chunks;
    }

    public void m_6550_(BlockPos pos, BlockState stateOld, BlockState stateNew) {
        if (stateNew != stateOld) {
            this.scheduleChunkRenders(pos.m_123341_() >> 4, pos.m_123343_() >> 4);
        }
    }

    public void scheduleChunkRenders(int chunkX, int chunkZ) {
        if (this.worldRenderer != null) {
            this.worldRenderer.scheduleChunkRenders(chunkX, chunkZ);
        }
    }

    public int m_141937_() {
        return this.mc.f_91073_ != null ? this.mc.f_91073_.m_141937_() : -64;
    }

    public int m_141928_() {
        return this.mc.f_91073_ != null ? this.mc.f_91073_.m_141928_() : 384;
    }

    public int m_151558_() {
        return this.m_141937_() + this.m_141928_();
    }

    public int m_151560_() {
        return this.m_141937_() >> 4;
    }

    public int m_151561_() {
        return this.m_151558_() >> 4;
    }

    public int m_151559_() {
        return this.m_151561_() - this.m_151560_();
    }

    public boolean m_151570_(BlockPos pos) {
        return this.m_151562_(pos.m_123342_());
    }

    public boolean m_151562_(int y) {
        return y < this.m_141937_() || y >= this.m_151558_();
    }

    public int m_151564_(int y) {
        return (y >> 4) - (this.m_141937_() >> 4);
    }

    public int m_151566_(int coord) {
        return coord - (this.m_141937_() >> 4);
    }

    public int m_151568_(int index) {
        return index + (this.m_141937_() >> 4);
    }

    public float m_7717_(Direction direction, boolean shaded) {
        return 0.0f;
    }

    public int m_45517_(LightLayer type, BlockPos pos) {
        return 15;
    }

    public int m_45524_(BlockPos pos, int defaultValue) {
        return 15;
    }

    public void m_7260_(BlockPos blockPos_1, BlockState blockState_1, BlockState blockState_2, int flags) {
    }

    public void m_6801_(int entityId, BlockPos pos, int progress) {
    }

    public void m_6798_(int eventId, BlockPos pos, int data) {
    }

    public void m_5898_(@Nullable Player entity, int id, BlockPos pos, int data) {
    }

    public void m_214171_(GameEvent event, Vec3 pos, @Nullable GameEvent.Context emitter) {
    }

    public void m_214150_(@Nullable Player except, double x, double y, double z, SoundEvent sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void m_213890_(@javax.annotation.Nullable Player except, Entity entity, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void m_142346_(@Nullable Entity entity, GameEvent event, BlockPos pos) {
    }

    public void m_7106_(ParticleOptions particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void m_6493_(ParticleOptions particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void m_7107_(ParticleOptions particleParameters_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void m_6485_(ParticleOptions particleParameters_1, boolean boolean_1, double double_1, double double_2, double double_3, double double_4, double double_5, double double_6) {
    }

    public void m_7785_(double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch, boolean distanceDelay) {
    }

    public void m_5594_(Player player, BlockPos pos, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
    }

    public void m_262808_(@javax.annotation.Nullable Player except, double x, double y, double z, Holder<SoundEvent> sound, SoundSource category, float volume, float pitch, long seed) {
    }

    public void m_6263_(Player player, double x, double y, double z, SoundEvent soundIn, SoundSource category, float volume, float pitch) {
    }

    public void m_6269_(@Nullable Player player, Entity entity, SoundEvent sound, SoundSource category, float volume, float pitch) {
    }

    public RegistryAccess m_9598_() {
        return this.mc.f_91073_.m_9598_();
    }

    public FeatureFlagSet m_246046_() {
        return this.mc.f_91073_.m_246046_();
    }

    public String m_46464_() {
        return "Chunks[SCH] W: " + this.getChunkManager().m_6754_() + " E: " + this.getRegularEntityCount();
    }
}

