/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.world;

import fi.dy.masa.litematica.world.ChunkSchematic;
import fi.dy.masa.litematica.world.WorldSchematic;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.lighting.LevelLightEngine;

public class ChunkManagerSchematic
extends ChunkSource {
    private final WorldSchematic world;
    private final Long2ObjectMap<ChunkSchematic> loadedChunks = new Long2ObjectOpenHashMap(8192);
    private final ChunkSchematic blankChunk;
    private final LevelLightEngine lightingProvider;

    public ChunkManagerSchematic(WorldSchematic world) {
        this.world = world;
        this.blankChunk = new ChunkSchematic(world, new ChunkPos(0, 0));
        this.lightingProvider = new LevelLightEngine((LightChunkGetter)this, true, world.m_6042_().f_223549_());
    }

    public WorldSchematic getWorld() {
        return this.world;
    }

    public void loadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = new ChunkSchematic(this.world, new ChunkPos(chunkX, chunkZ));
        this.loadedChunks.put(ChunkPos.m_45589_((int)chunkX, (int)chunkZ), (Object)chunk);
    }

    public boolean m_5563_(int chunkX, int chunkZ) {
        return this.loadedChunks.containsKey(ChunkPos.m_45589_((int)chunkX, (int)chunkZ));
    }

    public String m_6754_() {
        return "Schematic Chunk Cache: " + this.m_8482_();
    }

    public int m_8482_() {
        return this.loadedChunks.size();
    }

    public Long2ObjectMap<ChunkSchematic> getLoadedChunks() {
        return this.loadedChunks;
    }

    public LevelChunk getChunk(int chunkX, int chunkZ, ChunkStatus status, boolean fallbackToEmpty) {
        ChunkSchematic chunk = this.getChunk(chunkX, chunkZ);
        return chunk == null && fallbackToEmpty ? this.blankChunk : chunk;
    }

    public ChunkSchematic getChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = (ChunkSchematic)((Object)this.loadedChunks.get(ChunkPos.m_45589_((int)chunkX, (int)chunkZ)));
        return chunk == null ? this.blankChunk : chunk;
    }

    @Nullable
    public ChunkSchematic getChunkIfExists(int chunkX, int chunkZ) {
        return (ChunkSchematic)((Object)this.loadedChunks.get(ChunkPos.m_45589_((int)chunkX, (int)chunkZ)));
    }

    public void unloadChunk(int chunkX, int chunkZ) {
        ChunkSchematic chunk = (ChunkSchematic)((Object)this.loadedChunks.remove(ChunkPos.m_45589_((int)chunkX, (int)chunkZ)));
        if (chunk != null) {
            this.world.unloadedEntities(chunk.getEntityCount());
        }
    }

    public LevelLightEngine m_7827_() {
        return this.lightingProvider;
    }

    public void m_201698_(BooleanSupplier shouldKeepTicking, boolean tickChunks) {
    }
}

