/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.schematic.LitematicaSchematic;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.PositionUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.NBTUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.decoration.Painting;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelTicks;
import net.minecraft.world.ticks.ScheduledTick;

public class SchematicPlacingUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean placeToWorldWithinChunk(Level world, ChunkPos chunkPos, SchematicPlacement schematicPlacement, ReplaceBehavior replace, boolean notifyNeighbors) {
        LitematicaSchematic schematic = schematicPlacement.getSchematic();
        Set<String> regionsTouchingChunk = schematicPlacement.getRegionsTouchingChunk(chunkPos.f_45578_, chunkPos.f_45579_);
        BlockPos origin = schematicPlacement.getOrigin();
        boolean allSuccess = true;
        try {
            if (!notifyNeighbors) {
                WorldUtils.setShouldPreventBlockUpdates(world, true);
            }
            for (String regionName : regionsTouchingChunk) {
                Map<BlockPos, ScheduledTick<Fluid>> scheduledFluidTicks;
                Map<BlockPos, ScheduledTick<Block>> scheduledBlockTicks;
                LitematicaBlockStateContainer container = schematic.getSubRegionContainer(regionName);
                if (container == null) {
                    allSuccess = false;
                    continue;
                }
                SubRegionPlacement placement = schematicPlacement.getRelativeSubRegionPlacement(regionName);
                if (!placement.isEnabled()) continue;
                Map<BlockPos, CompoundTag> blockEntityMap = schematic.getBlockEntityMapForRegion(regionName);
                if (!SchematicPlacingUtils.placeBlocksWithinChunk(world, chunkPos, regionName, container, blockEntityMap, origin, schematicPlacement, placement, scheduledBlockTicks = schematic.getScheduledBlockTicksForRegion(regionName), scheduledFluidTicks = schematic.getScheduledFluidTicksForRegion(regionName), replace, notifyNeighbors)) {
                    allSuccess = false;
                    Litematica.logger.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)schematic.getMetadata().getName(), (Object)regionName);
                }
                List<LitematicaSchematic.EntityInfo> entityList = schematic.getEntityListForRegion(regionName);
                if (schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
                SchematicPlacingUtils.placeEntitiesToWorldWithinChunk(world, chunkPos, entityList, origin, schematicPlacement, placement);
            }
        }
        finally {
            WorldUtils.setShouldPreventBlockUpdates(world, false);
        }
        return allSuccess;
    }

    public static boolean placeBlocksWithinChunk(Level world, ChunkPos chunkPos, String regionName, LitematicaBlockStateContainer container, Map<BlockPos, CompoundTag> blockEntityMap, BlockPos origin, SchematicPlacement schematicPlacement, SubRegionPlacement placement, @Nullable Map<BlockPos, ScheduledTick<Block>> scheduledBlockTicks, @Nullable Map<BlockPos, ScheduledTick<Fluid>> scheduledFluidTicks, ReplaceBehavior replace, boolean notifyNeighbors) {
        BlockPos pos;
        int y;
        IntBoundingBox bounds = schematicPlacement.getBoxWithinChunkForRegion(regionName, chunkPos.f_45578_, chunkPos.f_45579_);
        BlockPos regionSize = schematicPlacement.getSchematic().getAreaSize(regionName);
        if (bounds == null || container == null || blockEntityMap == null || regionSize == null) {
            return false;
        }
        BlockPos regionPos = placement.getPos();
        BlockPos posEndRel = new BlockPos((Vec3i)PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize)).m_121955_((Vec3i)regionPos);
        BlockPos posMinRel = PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos boxMinRel = new BlockPos(bounds.minX - origin.m_123341_() - regionPosTransformed.m_123341_(), 0, bounds.minZ - origin.m_123343_() - regionPosTransformed.m_123343_());
        BlockPos boxMaxRel = new BlockPos(bounds.maxX - origin.m_123341_() - regionPosTransformed.m_123341_(), 0, bounds.maxZ - origin.m_123343_() - regionPosTransformed.m_123343_());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, placement.getMirror(), placement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, placement.getMirror(), placement.getRotation());
        boxMinRel = PositionUtils.getReverseTransformedBlockPos(boxMinRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMaxRel = PositionUtils.getReverseTransformedBlockPos(boxMaxRel, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        boxMinRel = boxMinRel.m_121996_((Vec3i)posMinRel.m_121996_((Vec3i)regionPos));
        boxMaxRel = boxMaxRel.m_121996_((Vec3i)posMinRel.m_121996_((Vec3i)regionPos));
        BlockPos posMin = PositionUtils.getMinCorner(boxMinRel, boxMaxRel);
        BlockPos posMax = PositionUtils.getMaxCorner(boxMinRel, boxMaxRel);
        int startX = posMin.m_123341_();
        int startZ = posMin.m_123343_();
        int endX = posMax.m_123341_();
        int endZ = posMax.m_123343_();
        boolean startY = false;
        int endY = Math.abs(regionSize.m_123342_()) - 1;
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        if (startX < 0 || startZ < 0 || endX >= container.getSize().m_123341_() || endZ >= container.getSize().m_123343_()) {
            System.out.printf("DEBUG ============= OUT OF BOUNDS - region: %s, sx: %d, sz: %d, ex: %d, ez: %d - size x: %d z: %d =============\n", regionName, startX, startZ, endX, endZ, container.getSize().m_123341_(), container.getSize().m_123343_());
            return false;
        }
        Rotation rotationCombined = schematicPlacement.getRotation().m_55952_(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        BlockState barrier = Blocks.f_50375_.m_49966_();
        Mirror mirrorSub = placement.getMirror();
        boolean ignoreInventories = Configs.Generic.PASTE_IGNORE_INVENTORY.getBooleanValue();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        int posMinRelMinusRegX = posMinRel.m_123341_() - regionPos.m_123341_();
        int posMinRelMinusRegY = posMinRel.m_123342_() - regionPos.m_123342_();
        int posMinRelMinusRegZ = posMinRel.m_123343_() - regionPos.m_123343_();
        for (y = 0; y <= endY; ++y) {
            for (int z = startZ; z <= endZ; ++z) {
                for (int x = startX; x <= endX; ++x) {
                    BlockEntity te;
                    Object state = container.get(x, y, z);
                    if (state.m_60734_() == Blocks.f_50454_) continue;
                    posMutable.m_122178_(x, y, z);
                    CompoundTag compoundTag = blockEntityMap.get(posMutable);
                    posMutable.m_122178_(posMinRelMinusRegX + x, posMinRelMinusRegY + y, posMinRelMinusRegZ + z);
                    pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos = pos.m_121955_((Vec3i)regionPosTransformed).m_121955_((Vec3i)origin);
                    BlockState stateOld = world.m_8055_(pos);
                    if (replace == ReplaceBehavior.NONE && !stateOld.m_60795_() || replace == ReplaceBehavior.WITH_NON_AIR && state.m_60795_()) continue;
                    if (mirrorMain != Mirror.NONE) {
                        state = state.m_60715_(mirrorMain);
                    }
                    if (mirrorSub != Mirror.NONE) {
                        state = state.m_60715_(mirrorSub);
                    }
                    if (rotationCombined != Rotation.NONE) {
                        state = state.m_60717_(rotationCombined);
                    }
                    if ((te = world.m_7702_(pos)) != null) {
                        if (te instanceof Container) {
                            ((Container)te).m_6211_();
                        }
                        world.m_7731_(pos, barrier, 20);
                    }
                    if (!world.m_7731_(pos, (BlockState)state, 18) || compoundTag == null || (te = world.m_7702_(pos)) == null) continue;
                    CompoundTag compoundTag2 = compoundTag.m_6426_();
                    compoundTag2.m_128405_("x", pos.m_123341_());
                    compoundTag2.m_128405_("y", pos.m_123342_());
                    compoundTag2.m_128405_("z", pos.m_123343_());
                    if (ignoreInventories) {
                        compoundTag2.m_128473_("Items");
                    }
                    try {
                        te.m_142466_(compoundTag2);
                        if (!ignoreInventories || !(te instanceof Container)) continue;
                        ((Container)te).m_6211_();
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("Failed to load BlockEntity data for {} @ {}", state, (Object)pos);
                    }
                }
            }
        }
        if (world instanceof ServerLevel) {
            ScheduledTick tick;
            ServerLevel serverWorld = (ServerLevel)world;
            IntBoundingBox box = new IntBoundingBox(startX, 0, startZ, endX, endY, endZ);
            if (scheduledBlockTicks != null && !scheduledBlockTicks.isEmpty()) {
                LevelTicks scheduler = serverWorld.m_183326_();
                for (Map.Entry entry : scheduledBlockTicks.entrySet()) {
                    pos = (BlockPos)entry.getKey();
                    if (!box.containsPos((Vec3i)pos)) continue;
                    posMutable.m_122178_(posMinRelMinusRegX + pos.m_123341_(), posMinRelMinusRegY + pos.m_123342_(), posMinRelMinusRegZ + pos.m_123343_());
                    pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos = pos.m_121955_((Vec3i)regionPosTransformed).m_121955_((Vec3i)origin);
                    tick = (ScheduledTick)entry.getValue();
                    if (world.m_8055_(pos).m_60734_() != tick.f_193376_()) continue;
                    scheduler.m_183393_(new ScheduledTick((Object)((Block)tick.f_193376_()), pos, tick.f_193378_(), tick.f_193379_(), tick.f_193380_()));
                }
            }
            if (scheduledFluidTicks != null && !scheduledFluidTicks.isEmpty()) {
                LevelTicks scheduler = serverWorld.m_183324_();
                for (Map.Entry entry : scheduledFluidTicks.entrySet()) {
                    pos = (BlockPos)entry.getKey();
                    if (!box.containsPos((Vec3i)pos)) continue;
                    posMutable.m_122178_(posMinRelMinusRegX + pos.m_123341_(), posMinRelMinusRegY + pos.m_123342_(), posMinRelMinusRegZ + pos.m_123343_());
                    pos = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos = pos.m_121955_((Vec3i)regionPosTransformed).m_121955_((Vec3i)origin);
                    tick = (ScheduledTick)entry.getValue();
                    if (world.m_8055_(pos).m_60819_().m_76152_() != tick.f_193376_()) continue;
                    scheduler.m_183393_(new ScheduledTick((Object)((Fluid)tick.f_193376_()), pos, tick.f_193378_(), tick.f_193379_(), tick.f_193380_()));
                }
            }
        }
        if (notifyNeighbors) {
            for (y = 0; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        posMutable.m_122178_(posMinRelMinusRegX + x, posMinRelMinusRegY + y, posMinRelMinusRegZ + z);
                        BlockPos pos2 = PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                        pos2 = pos2.m_121955_((Vec3i)regionPosTransformed).m_121955_((Vec3i)origin);
                        world.m_6289_(pos2, world.m_8055_(pos2).m_60734_());
                    }
                }
            }
        }
        return true;
    }

    public static void placeEntitiesToWorldWithinChunk(Level world, ChunkPos chunkPos, List<LitematicaSchematic.EntityInfo> entityList, BlockPos origin, SchematicPlacement schematicPlacement, SubRegionPlacement placement) {
        BlockPos regionPos = placement.getPos();
        if (entityList == null) {
            return;
        }
        BlockPos regionPosRelTransformed = PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.m_123341_() + origin.m_123341_();
        int offY = regionPosRelTransformed.m_123342_() + origin.m_123342_();
        int offZ = regionPosRelTransformed.m_123343_() + origin.m_123343_();
        double minX = chunkPos.f_45578_ << 4;
        double minZ = chunkPos.f_45579_ << 4;
        double maxX = (chunkPos.f_45578_ << 4) + 16;
        double maxZ = (chunkPos.f_45579_ << 4) + 16;
        Rotation rotationCombined = schematicPlacement.getRotation().m_55952_(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (LitematicaSchematic.EntityInfo info : entityList) {
            ItemFrame frameEntity;
            LivingEntity living;
            Vec3 pos = info.posVec;
            pos = PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.f_82479_ + (double)offX;
            double y = pos.f_82480_ + (double)offY;
            double z = pos.f_82481_ + (double)offZ;
            float[] origRot = new float[2];
            if (!(x >= minX) || !(x < maxX) || !(z >= minZ) || !(z < maxZ)) continue;
            CompoundTag tag = info.nbt.m_6426_();
            String id = tag.m_128461_("id");
            if (id.equals("minecraft:glow_item_frame") || id.equals("minecraft:item_frame") || id.equals("minecraft:leash_knot") || id.equals("minecraft:painting")) {
                Vec3 p = NBTUtils.readEntityPositionFromTag((CompoundTag)tag);
                if (p == null) {
                    p = new Vec3(x, y, z);
                    NBTUtils.writeEntityPositionToTag((Vec3)p, (CompoundTag)tag);
                }
                tag.m_128405_("TileX", (int)p.f_82479_);
                tag.m_128405_("TileY", (int)p.f_82480_);
                tag.m_128405_("TileZ", (int)p.f_82481_);
            }
            ListTag rotation = tag.m_128437_("Rotation", 5);
            origRot[0] = rotation.m_128775_(0);
            origRot[1] = rotation.m_128775_(1);
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(tag, world);
            if (entity == null) continue;
            SchematicPlacingUtils.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            if (entity instanceof LivingEntity && (living = (LivingEntity)entity).m_5803_()) {
                living.m_21250_(BlockPos.m_274561_((double)x, (double)y, (double)z));
            }
            if (entity instanceof Painting) {
                Painting paintingEntity = (Painting)entity;
                Direction right = paintingEntity.m_6350_().m_122428_();
                if (paintingEntity.m_7076_() % 32 == 0 && right.m_122421_() == Direction.AxisDirection.POSITIVE) {
                    x -= 1.0 * (double)right.m_122429_();
                    z -= 1.0 * (double)right.m_122431_();
                }
                if (paintingEntity.m_7068_() % 32 == 0) {
                    y -= 1.0;
                }
                entity.m_6034_(x, y, z);
            }
            if (entity instanceof ItemFrame && (frameEntity = (ItemFrame)entity).m_146908_() != origRot[0] && (frameEntity.m_146909_() == 90.0f || frameEntity.m_146909_() == -90.0f)) {
                frameEntity.m_146922_(origRot[0]);
            }
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
            if (!(entity instanceof Display)) continue;
            entity.m_8119_();
        }
    }

    public static void rotateEntity(Entity entity, double x, double y, double z, Rotation rotationCombined, Mirror mirrorMain, Mirror mirrorSub) {
        float rotationYaw = entity.m_146908_();
        if (mirrorMain != Mirror.NONE) {
            rotationYaw = entity.m_6961_(mirrorMain);
        }
        if (mirrorSub != Mirror.NONE) {
            rotationYaw = entity.m_6961_(mirrorSub);
        }
        if (rotationCombined != Rotation.NONE) {
            rotationYaw += entity.m_146908_() - entity.m_7890_(rotationCombined);
        }
        entity.m_7678_(x, y, z, rotationYaw, entity.m_146909_());
        EntityUtils.setEntityRotations(entity, rotationYaw, entity.m_146909_());
    }
}

