/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.util;

import com.google.common.collect.ImmutableSet;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.data.DataManager;
import fi.dy.masa.litematica.util.EasyPlaceProtocol;
import fi.dy.masa.malilib.util.BlockUtils;
import java.util.ArrayList;
import java.util.Comparator;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ComparatorBlock;
import net.minecraft.world.level.block.RepeaterBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.ComparatorMode;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.Vec3;

public class PlacementHandler {
    public static final ImmutableSet<Property<?>> WHITELISTED_PROPERTIES = ImmutableSet.of((Object)BlockStateProperties.f_61441_, (Object)BlockStateProperties.f_61446_, (Object)BlockStateProperties.f_61447_, (Object)BlockStateProperties.f_61365_, (Object)BlockStateProperties.f_61402_, (Object)BlockStateProperties.f_61392_, (Object[])new Property[]{BlockStateProperties.f_61393_, BlockStateProperties.f_61394_, BlockStateProperties.f_61397_, BlockStateProperties.f_61398_, BlockStateProperties.f_61376_, BlockStateProperties.f_61412_, BlockStateProperties.f_61413_, BlockStateProperties.f_61424_, BlockStateProperties.f_61390_});

    public static EasyPlaceProtocol getEffectiveProtocolVersion() {
        EasyPlaceProtocol protocol = (EasyPlaceProtocol)Configs.Generic.EASY_PLACE_PROTOCOL.getOptionListValue();
        if (protocol == EasyPlaceProtocol.AUTO) {
            if (Minecraft.m_91087_().m_91090_()) {
                return EasyPlaceProtocol.V3;
            }
            if (DataManager.isCarpetServer()) {
                return EasyPlaceProtocol.V2;
            }
            return EasyPlaceProtocol.SLAB_ONLY;
        }
        return protocol;
    }

    @Nullable
    public static BlockState applyPlacementProtocolToPlacementState(BlockState state, UseContext context) {
        EasyPlaceProtocol protocol = PlacementHandler.getEffectiveProtocolVersion();
        if (protocol == EasyPlaceProtocol.V3) {
            return PlacementHandler.applyPlacementProtocolV3(state, context);
        }
        if (protocol == EasyPlaceProtocol.V2) {
            return PlacementHandler.applyPlacementProtocolV2(state, context);
        }
        return state;
    }

    public static BlockState applyPlacementProtocolV2(BlockState state, UseContext context) {
        int protocolValue = (int)(context.getHitVec().f_82479_ - (double)context.getPos().m_123341_()) - 2;
        if (protocolValue < 0) {
            return state;
        }
        DirectionProperty property = BlockUtils.getFirstDirectionProperty((BlockState)state);
        if (property != null) {
            if ((state = PlacementHandler.applyDirectionProperty(state, context, property, protocolValue)) == null) {
                return null;
            }
        } else if (state.m_61138_((Property)BlockStateProperties.f_61365_)) {
            Direction.Axis axis = Direction.Axis.f_122448_[(protocolValue >> 1 & 3) % 3];
            if (BlockStateProperties.f_61365_.m_6908_().contains(axis)) {
                state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61365_, (Comparable)axis);
            }
        }
        if ((protocolValue >>>= 5) > 0) {
            Block block = state.m_60734_();
            if (block instanceof RepeaterBlock) {
                Integer delay = protocolValue;
                if (RepeaterBlock.f_55798_.m_6908_().contains(delay)) {
                    state = (BlockState)state.m_61124_((Property)RepeaterBlock.f_55798_, (Comparable)delay);
                }
            } else if (block instanceof ComparatorBlock) {
                state = (BlockState)state.m_61124_((Property)ComparatorBlock.f_51854_, (Comparable)ComparatorMode.SUBTRACT);
            }
        }
        if (state.m_61138_((Property)BlockStateProperties.f_61402_)) {
            state = (BlockState)state.m_61124_((Property)BlockStateProperties.f_61402_, (Comparable)(protocolValue > 0 ? Half.TOP : Half.BOTTOM));
        }
        return state;
    }

    public static <T extends Comparable<T>> BlockState applyPlacementProtocolV3(BlockState state, UseContext context) {
        int protocolValue = (int)(context.getHitVec().f_82479_ - (double)context.getPos().m_123341_()) - 2;
        if (protocolValue < 0) {
            return state;
        }
        DirectionProperty property = BlockUtils.getFirstDirectionProperty((BlockState)state);
        if (property != null && property != BlockStateProperties.f_155997_) {
            if ((state = PlacementHandler.applyDirectionProperty(state, context, property, protocolValue)) == null) {
                return null;
            }
            protocolValue >>>= 3;
        }
        protocolValue >>>= 1;
        ArrayList<Property> propList = new ArrayList<Property>(state.m_60734_().m_49965_().m_61092_());
        propList.sort(Comparator.comparing(Property::m_61708_));
        try {
            for (Property p : propList) {
                if (p instanceof DirectionProperty || !WHITELISTED_PROPERTIES.contains((Object)p)) continue;
                Property prop = p;
                ArrayList list = new ArrayList(prop.m_6908_());
                list.sort(Comparable::compareTo);
                int requiredBits = Mth.m_14173_((int)Mth.m_14125_((int)list.size()));
                int bitMask = ~(-1 << requiredBits);
                int valueIndex = protocolValue & bitMask;
                if (valueIndex < 0 || valueIndex >= list.size()) continue;
                Comparable value = (Comparable)list.get(valueIndex);
                if (!state.m_61143_(prop).equals(value) && value != SlabType.DOUBLE) {
                    state = (BlockState)state.m_61124_(prop, value);
                }
                protocolValue >>>= requiredBits;
            }
        }
        catch (Exception e) {
            Litematica.logger.warn("Exception trying to apply placement protocol value", (Throwable)e);
        }
        return state;
    }

    private static BlockState applyDirectionProperty(BlockState state, UseContext context, DirectionProperty property, int protocolValue) {
        Direction facingOrig;
        Direction facing = facingOrig = (Direction)state.m_61143_((Property)property);
        int decodedFacingIndex = (protocolValue & 0xF) >> 1;
        if (decodedFacingIndex == 6) {
            facing = facing.m_122424_();
        } else if (decodedFacingIndex >= 0 && decodedFacingIndex <= 5) {
            facing = Direction.m_122376_((int)decodedFacingIndex);
            if (!property.m_6908_().contains(facing)) {
                facing = context.getEntity().m_6350_().m_122424_();
            }
        }
        if (facing != facingOrig && property.m_6908_().contains(facing)) {
            if (state.m_60734_() instanceof BedBlock) {
                BlockPos headPos = context.pos.m_121945_(facing);
                BlockPlaceContext ctx = context.getItemPlacementContext();
                if (!context.getWorld().m_8055_(headPos).m_60629_(ctx)) {
                    return null;
                }
            }
            state = (BlockState)state.m_61124_((Property)property, (Comparable)facing);
        }
        return state;
    }

    public static class UseContext {
        private final Level world;
        private final BlockPos pos;
        private final Direction side;
        private final Vec3 hitVec;
        private final LivingEntity entity;
        private final InteractionHand hand;
        @Nullable
        private final BlockPlaceContext itemPlacementContext;

        private UseContext(Level world, BlockPos pos, Direction side, Vec3 hitVec, LivingEntity entity, InteractionHand hand, @Nullable BlockPlaceContext itemPlacementContext) {
            this.world = world;
            this.pos = pos;
            this.side = side;
            this.hitVec = hitVec;
            this.entity = entity;
            this.hand = hand;
            this.itemPlacementContext = itemPlacementContext;
        }

        public static UseContext from(BlockPlaceContext ctx, InteractionHand hand) {
            Vec3 pos = ctx.m_43720_();
            return new UseContext(ctx.m_43725_(), ctx.m_8083_(), ctx.m_43719_(), new Vec3(pos.f_82479_, pos.f_82480_, pos.f_82481_), (LivingEntity)ctx.m_43723_(), hand, ctx);
        }

        public Level getWorld() {
            return this.world;
        }

        public BlockPos getPos() {
            return this.pos;
        }

        public Direction getSide() {
            return this.side;
        }

        public Vec3 getHitVec() {
            return this.hitVec;
        }

        public LivingEntity getEntity() {
            return this.entity;
        }

        public InteractionHand getHand() {
            return this.hand;
        }

        @Nullable
        public BlockPlaceContext getItemPlacementContext() {
            return this.itemPlacementContext;
        }
    }
}

