/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.litematica.schematic;

import com.google.common.collect.ImmutableMap;
import fi.dy.masa.litematica.Litematica;
import fi.dy.masa.litematica.config.Configs;
import fi.dy.masa.litematica.mixin.IMixinWorldTickScheduler;
import fi.dy.masa.litematica.schematic.SchematicMetadata;
import fi.dy.masa.litematica.schematic.SchematicaSchematic;
import fi.dy.masa.litematica.schematic.container.ILitematicaBlockStatePalette;
import fi.dy.masa.litematica.schematic.container.LitematicaBlockStateContainer;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionFixers;
import fi.dy.masa.litematica.schematic.conversion.SchematicConversionMaps;
import fi.dy.masa.litematica.schematic.conversion.SchematicConverter;
import fi.dy.masa.litematica.schematic.placement.SchematicPlacement;
import fi.dy.masa.litematica.schematic.placement.SubRegionPlacement;
import fi.dy.masa.litematica.selection.AreaSelection;
import fi.dy.masa.litematica.selection.Box;
import fi.dy.masa.litematica.util.BlockUtils;
import fi.dy.masa.litematica.util.EntityUtils;
import fi.dy.masa.litematica.util.FileType;
import fi.dy.masa.litematica.util.NbtUtils;
import fi.dy.masa.litematica.util.ReplaceBehavior;
import fi.dy.masa.litematica.util.SchematicPlacingUtils;
import fi.dy.masa.litematica.util.WorldUtils;
import fi.dy.masa.malilib.gui.Message;
import fi.dy.masa.malilib.interfaces.IStringConsumer;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.InfoUtils;
import fi.dy.masa.malilib.util.IntBoundingBox;
import fi.dy.masa.malilib.util.NBTUtils;
import fi.dy.masa.malilib.util.PositionUtils;
import fi.dy.masa.malilib.util.StringUtils;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.SectionPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.decoration.HangingEntity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.ticks.LevelChunkTicks;
import net.minecraft.world.ticks.ScheduledTick;
import net.minecraft.world.ticks.TickPriority;

public class LitematicaSchematic {
    public static final String FILE_EXTENSION = ".litematic";
    public static final int SCHEMATIC_VERSION_1_13_2 = 5;
    public static final int MINECRAFT_DATA_VERSION_1_12 = 1139;
    public static final int MINECRAFT_DATA_VERSION_1_13_2 = 1631;
    public static final int MINECRAFT_DATA_VERSION = SharedConstants.m_183709_().m_183476_().m_193006_();
    public static final int SCHEMATIC_VERSION = 6;
    public static final int SCHEMATIC_VERSION_SUB = 1;
    private final Map<String, LitematicaBlockStateContainer> blockContainers = new HashMap<String, LitematicaBlockStateContainer>();
    private final Map<String, Map<BlockPos, CompoundTag>> tileEntities = new HashMap<String, Map<BlockPos, CompoundTag>>();
    private final Map<String, Map<BlockPos, ScheduledTick<Block>>> pendingBlockTicks = new HashMap<String, Map<BlockPos, ScheduledTick<Block>>>();
    private final Map<String, Map<BlockPos, ScheduledTick<Fluid>>> pendingFluidTicks = new HashMap<String, Map<BlockPos, ScheduledTick<Fluid>>>();
    private final Map<String, List<EntityInfo>> entities = new HashMap<String, List<EntityInfo>>();
    private final Map<String, BlockPos> subRegionPositions = new HashMap<String, BlockPos>();
    private final Map<String, BlockPos> subRegionSizes = new HashMap<String, BlockPos>();
    private final SchematicMetadata metadata = new SchematicMetadata();
    private final SchematicConverter converter;
    private int totalBlocksReadFromWorld;
    @Nullable
    private final File schematicFile;
    private final FileType schematicType;

    private LitematicaSchematic(@Nullable File file) {
        this(file, FileType.LITEMATICA_SCHEMATIC);
    }

    private LitematicaSchematic(@Nullable File file, FileType schematicType) {
        this.schematicFile = file;
        this.schematicType = schematicType;
        this.converter = SchematicConverter.createForLitematica();
    }

    @Nullable
    public File getFile() {
        return this.schematicFile;
    }

    public Vec3i getTotalSize() {
        return this.metadata.getEnclosingSize();
    }

    public int getTotalBlocksReadFromWorld() {
        return this.totalBlocksReadFromWorld;
    }

    public SchematicMetadata getMetadata() {
        return this.metadata;
    }

    public int getSubRegionCount() {
        return this.blockContainers.size();
    }

    @Nullable
    public BlockPos getSubRegionPosition(String areaName) {
        return this.subRegionPositions.get(areaName);
    }

    public Map<String, BlockPos> getAreaPositions() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    public Map<String, BlockPos> getAreaSizes() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionSizes.keySet()) {
            BlockPos pos = this.subRegionSizes.get(name);
            builder.put((Object)name, (Object)pos);
        }
        return builder.build();
    }

    @Nullable
    public BlockPos getAreaSize(String regionName) {
        return this.subRegionSizes.get(regionName);
    }

    public Map<String, Box> getAreas() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (String name : this.subRegionPositions.keySet()) {
            BlockPos pos = this.subRegionPositions.get(name);
            BlockPos posEndRel = fi.dy.masa.litematica.util.PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)this.subRegionSizes.get(name));
            Box box = new Box(pos, pos.m_121955_((Vec3i)posEndRel), name);
            builder.put((Object)name, (Object)box);
        }
        return builder.build();
    }

    @Nullable
    public static LitematicaSchematic createFromWorld(Level world, AreaSelection area, SchematicSaveInfo info, String author, IStringConsumer feedback) {
        List<Box> boxes = fi.dy.masa.litematica.util.PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            feedback.setString(StringUtils.translate((String)"litematica.error.schematic.create.no_selections", (Object[])new Object[0]));
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(null);
        long time = System.currentTimeMillis();
        BlockPos origin = area.getEffectiveOrigin();
        schematic.setSubRegionPositions(boxes, origin);
        schematic.setSubRegionSizes(boxes);
        schematic.takeBlocksFromWorld(world, boxes, info);
        if (!info.ignoreEntities) {
            schematic.takeEntitiesFromWorld(world, boxes, origin);
        }
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setTimeCreated(time);
        schematic.metadata.setTimeModified(time);
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(fi.dy.masa.litematica.util.PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize((Vec3i)fi.dy.masa.litematica.util.PositionUtils.getEnclosingAreaSize(boxes));
        schematic.metadata.setTotalBlocks(schematic.totalBlocksReadFromWorld);
        return schematic;
    }

    public static LitematicaSchematic createEmptySchematic(AreaSelection area, String author) {
        List<Box> boxes = fi.dy.masa.litematica.util.PositionUtils.getValidBoxes(area);
        if (boxes.isEmpty()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)StringUtils.translate((String)"litematica.error.schematic.create.no_selections", (Object[])new Object[0]), (Object[])new Object[0]);
            return null;
        }
        LitematicaSchematic schematic = new LitematicaSchematic(null);
        schematic.setSubRegionPositions(boxes, area.getEffectiveOrigin());
        schematic.setSubRegionSizes(boxes);
        schematic.metadata.setAuthor(author);
        schematic.metadata.setName(area.getName());
        schematic.metadata.setRegionCount(boxes.size());
        schematic.metadata.setTotalVolume(fi.dy.masa.litematica.util.PositionUtils.getTotalVolume(boxes));
        schematic.metadata.setEnclosingSize((Vec3i)fi.dy.masa.litematica.util.PositionUtils.getEnclosingAreaSize(boxes));
        for (Box box : boxes) {
            String regionName = box.getName();
            BlockPos size = box.getSize();
            int sizeX = Math.abs(size.m_123341_());
            int sizeY = Math.abs(size.m_123342_());
            int sizeZ = Math.abs(size.m_123343_());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            schematic.blockContainers.put(regionName, container);
            schematic.tileEntities.put(regionName, new HashMap());
            schematic.entities.put(regionName, new ArrayList());
            schematic.pendingBlockTicks.put(regionName, new HashMap());
            schematic.pendingFluidTicks.put(regionName, new HashMap());
        }
        return schematic;
    }

    public void takeEntityDataFromSchematicaSchematic(SchematicaSchematic schematic, String subRegionName) {
        this.tileEntities.put(subRegionName, schematic.getTiles());
        this.entities.put(subRegionName, schematic.getEntities());
    }

    public boolean placeToWorld(Level world, SchematicPlacement schematicPlacement, boolean notifyNeighbors) {
        return this.placeToWorld(world, schematicPlacement, notifyNeighbors, false);
    }

    public boolean placeToWorld(Level world, SchematicPlacement schematicPlacement, boolean notifyNeighbors, boolean ignoreEntities) {
        WorldUtils.setShouldPreventBlockUpdates(world, true);
        ImmutableMap<String, SubRegionPlacement> relativePlacements = schematicPlacement.getEnabledRelativeSubRegionPlacements();
        BlockPos origin = schematicPlacement.getOrigin();
        for (String regionName : relativePlacements.keySet()) {
            SubRegionPlacement placement = (SubRegionPlacement)relativePlacements.get((Object)regionName);
            if (!placement.isEnabled()) continue;
            BlockPos regionPos = placement.getPos();
            BlockPos regionSize = this.subRegionSizes.get(regionName);
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<BlockPos, CompoundTag> tileMap = this.tileEntities.get(regionName);
            List<EntityInfo> entityList = this.entities.get(regionName);
            Map<BlockPos, ScheduledTick<Block>> scheduledBlockTicks = this.pendingBlockTicks.get(regionName);
            Map<BlockPos, ScheduledTick<Fluid>> scheduledFluidTicks = this.pendingFluidTicks.get(regionName);
            if (regionPos != null && regionSize != null && container != null && tileMap != null) {
                this.placeBlocksToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, container, tileMap, scheduledBlockTicks, scheduledFluidTicks, notifyNeighbors);
            } else {
                Litematica.logger.warn("Invalid/missing schematic data in schematic '{}' for sub-region '{}'", (Object)this.metadata.getName(), (Object)regionName);
            }
            if (ignoreEntities || schematicPlacement.ignoreEntities() || placement.ignoreEntities() || entityList == null) continue;
            this.placeEntitiesToWorld(world, origin, regionPos, regionSize, schematicPlacement, placement, entityList);
        }
        WorldUtils.setShouldPreventBlockUpdates(world, false);
        return true;
    }

    private boolean placeBlocksToWorld(Level world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, LitematicaBlockStateContainer container, Map<BlockPos, CompoundTag> tileMap, @Nullable Map<BlockPos, ScheduledTick<Block>> scheduledBlockTicks, @Nullable Map<BlockPos, ScheduledTick<Fluid>> scheduledFluidTicks, boolean notifyNeighbors) {
        BlockPos posEndRelSub = fi.dy.masa.litematica.util.PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize);
        BlockPos posEndRel = posEndRelSub.m_121955_((Vec3i)regionPos);
        BlockPos posMinRel = fi.dy.masa.litematica.util.PositionUtils.getMinCorner(regionPos, posEndRel);
        BlockPos regionPosTransformed = fi.dy.masa.litematica.util.PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        BlockPos regionPosAbs = regionPosTransformed.m_121955_((Vec3i)origin);
        int sizeX = Math.abs(regionSize.m_123341_());
        int sizeY = Math.abs(regionSize.m_123342_());
        int sizeZ = Math.abs(regionSize.m_123343_());
        BlockState barrier = Blocks.f_50375_.m_49966_();
        boolean ignoreInventories = Configs.Generic.PASTE_IGNORE_INVENTORY.getBooleanValue();
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos();
        ReplaceBehavior replace = (ReplaceBehavior)Configs.Generic.PASTE_REPLACE_BEHAVIOR.getOptionListValue();
        Rotation rotationCombined = schematicPlacement.getRotation().m_55952_(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        int bottomY = world.m_141937_();
        int topY = world.m_151558_();
        int tmp = posMinRel.m_123342_() - regionPos.m_123342_() + regionPosTransformed.m_123342_() + origin.m_123342_();
        int startY = 0;
        int endY = sizeY;
        if (tmp < bottomY) {
            startY += bottomY - tmp;
        }
        if ((tmp = posMinRel.m_123342_() - regionPos.m_123342_() + regionPosTransformed.m_123342_() + origin.m_123342_() + (endY - 1)) > topY) {
            endY -= tmp - topY;
        }
        for (int y = startY; y < endY; ++y) {
            for (int z = 0; z < sizeZ; ++z) {
                for (int x = 0; x < sizeX; ++x) {
                    BlockEntity te;
                    BlockState state = container.get(x, y, z);
                    if (state.m_60734_() == Blocks.f_50454_) continue;
                    posMutable.m_122178_(x, y, z);
                    CompoundTag teNBT = tileMap.get(posMutable);
                    posMutable.m_122178_(posMinRel.m_123341_() + x - regionPos.m_123341_(), posMinRel.m_123342_() + y - regionPos.m_123342_(), posMinRel.m_123343_() + z - regionPos.m_123343_());
                    BlockPos pos = fi.dy.masa.litematica.util.PositionUtils.getTransformedPlacementPosition((BlockPos)posMutable, schematicPlacement, placement);
                    pos = pos.m_121955_((Vec3i)regionPosTransformed).m_121955_((Vec3i)origin);
                    BlockState stateOld = world.m_8055_(pos);
                    if (replace == ReplaceBehavior.NONE && !stateOld.m_60795_() || replace == ReplaceBehavior.WITH_NON_AIR && state.m_60795_()) continue;
                    if (mirrorMain != Mirror.NONE) {
                        state = state.m_60715_(mirrorMain);
                    }
                    if (mirrorSub != Mirror.NONE) {
                        state = state.m_60715_(mirrorSub);
                    }
                    if (rotationCombined != Rotation.NONE) {
                        state = state.m_60717_(rotationCombined);
                    }
                    if (stateOld == state && !state.m_155947_()) continue;
                    BlockEntity teOld = world.m_7702_(pos);
                    if (teOld != null) {
                        if (teOld instanceof Container) {
                            ((Container)teOld).m_6211_();
                        }
                        world.m_7731_(pos, barrier, 20);
                    }
                    if (!world.m_7731_(pos, state, 18) || teNBT == null || (te = world.m_7702_(pos)) == null) continue;
                    teNBT = teNBT.m_6426_();
                    teNBT.m_128405_("x", pos.m_123341_());
                    teNBT.m_128405_("y", pos.m_123342_());
                    teNBT.m_128405_("z", pos.m_123343_());
                    if (ignoreInventories) {
                        teNBT.m_128473_("Items");
                    }
                    try {
                        te.m_142466_(teNBT);
                        if (!ignoreInventories || !(te instanceof Container)) continue;
                        ((Container)te).m_6211_();
                        continue;
                    }
                    catch (Exception e) {
                        Litematica.logger.warn("Failed to load TileEntity data for {} @ {}", (Object)state, (Object)pos);
                    }
                }
            }
        }
        return true;
    }

    private void placeEntitiesToWorld(Level world, BlockPos origin, BlockPos regionPos, BlockPos regionSize, SchematicPlacement schematicPlacement, SubRegionPlacement placement, List<EntityInfo> entityList) {
        BlockPos regionPosRelTransformed = fi.dy.masa.litematica.util.PositionUtils.getTransformedBlockPos(regionPos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
        int offX = regionPosRelTransformed.m_123341_() + origin.m_123341_();
        int offY = regionPosRelTransformed.m_123342_() + origin.m_123342_();
        int offZ = regionPosRelTransformed.m_123343_() + origin.m_123343_();
        Rotation rotationCombined = schematicPlacement.getRotation().m_55952_(placement.getRotation());
        Mirror mirrorMain = schematicPlacement.getMirror();
        Mirror mirrorSub = placement.getMirror();
        if (mirrorSub != Mirror.NONE && (schematicPlacement.getRotation() == Rotation.CLOCKWISE_90 || schematicPlacement.getRotation() == Rotation.COUNTERCLOCKWISE_90)) {
            mirrorSub = mirrorSub == Mirror.FRONT_BACK ? Mirror.LEFT_RIGHT : Mirror.FRONT_BACK;
        }
        for (EntityInfo info : entityList) {
            Entity entity = EntityUtils.createEntityAndPassengersFromNBT(info.nbt, world);
            if (entity == null) continue;
            Vec3 pos = info.posVec;
            pos = fi.dy.masa.litematica.util.PositionUtils.getTransformedPosition(pos, schematicPlacement.getMirror(), schematicPlacement.getRotation());
            pos = fi.dy.masa.litematica.util.PositionUtils.getTransformedPosition(pos, placement.getMirror(), placement.getRotation());
            double x = pos.f_82479_ + (double)offX;
            double y = pos.f_82480_ + (double)offY;
            double z = pos.f_82481_ + (double)offZ;
            SchematicPlacingUtils.rotateEntity(entity, x, y, z, rotationCombined, mirrorMain, mirrorSub);
            EntityUtils.spawnEntityAndPassengersInWorld(entity, world);
        }
    }

    private void takeEntitiesFromWorld(Level world, List<Box> boxes, BlockPos origin) {
        for (Box box : boxes) {
            AABB bb = fi.dy.masa.litematica.util.PositionUtils.createEnclosingAABB(box.getPos1(), box.getPos2());
            BlockPos regionPosAbs = box.getPos1();
            ArrayList<EntityInfo> list = new ArrayList<EntityInfo>();
            List entities = world.m_6249_(null, bb, EntityUtils.NOT_PLAYER);
            for (Entity entity : entities) {
                CompoundTag tag;
                if (!entity.m_20223_(tag = new CompoundTag())) continue;
                Vec3 posVec = new Vec3(entity.m_20185_() - (double)regionPosAbs.m_123341_(), entity.m_20186_() - (double)regionPosAbs.m_123342_(), entity.m_20189_() - (double)regionPosAbs.m_123343_());
                NBTUtils.writeEntityPositionToTag((Vec3)posVec, (CompoundTag)tag);
                list.add(new EntityInfo(posVec, tag));
            }
            this.entities.put(box.getName(), list);
        }
    }

    public void takeEntitiesFromWorldWithinChunk(Level world, int chunkX, int chunkZ, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes, Set<UUID> existingEntities, BlockPos origin) {
        for (Map.Entry entry : volumes.entrySet()) {
            String regionName = (String)entry.getKey();
            List<EntityInfo> list = this.entities.get(regionName);
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null || list == null) continue;
            AABB bb = fi.dy.masa.litematica.util.PositionUtils.createAABBFrom((IntBoundingBox)entry.getValue());
            List entities = world.m_6249_(null, bb, EntityUtils.NOT_PLAYER);
            BlockPos regionPosAbs = box.getPos1();
            for (Entity entity : entities) {
                CompoundTag tag;
                UUID uuid = entity.m_20148_();
                if (existingEntities.contains(uuid) || !entity.m_20223_(tag = new CompoundTag())) continue;
                Vec3 posVec = new Vec3(entity.m_20185_() - (double)regionPosAbs.m_123341_(), entity.m_20186_() - (double)regionPosAbs.m_123342_(), entity.m_20189_() - (double)regionPosAbs.m_123343_());
                if (entity instanceof HangingEntity) {
                    HangingEntity decorationEntity = (HangingEntity)entity;
                    BlockPos p = decorationEntity.m_31748_();
                    tag.m_128405_("TileX", p.m_123341_() - regionPosAbs.m_123341_());
                    tag.m_128405_("TileY", p.m_123342_() - regionPosAbs.m_123342_());
                    tag.m_128405_("TileZ", p.m_123343_() - regionPosAbs.m_123343_());
                }
                NBTUtils.writeEntityPositionToTag((Vec3)posVec, (CompoundTag)tag);
                list.add(new EntityInfo(posVec, tag));
                existingEntities.add(uuid);
            }
        }
    }

    private void takeBlocksFromWorld(Level world, List<Box> boxes, SchematicSaveInfo info) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        for (Box box : boxes) {
            BlockPos size = box.getSize();
            int sizeX = Math.abs(size.m_123341_());
            int sizeY = Math.abs(size.m_123342_());
            int sizeZ = Math.abs(size.m_123343_());
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(sizeX, sizeY, sizeZ);
            HashMap<BlockPos, CompoundTag> tileEntityMap = new HashMap<BlockPos, CompoundTag>();
            HashMap blockTickMap = new HashMap();
            HashMap fluidTickMap = new HashMap();
            BlockPos minCorner = fi.dy.masa.litematica.util.PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int startX = minCorner.m_123341_();
            int startY = minCorner.m_123342_();
            int startZ = minCorner.m_123343_();
            boolean visibleOnly = info.visibleOnly;
            boolean includeSupport = info.includeSupportBlocks;
            for (int y = 0; y < sizeY; ++y) {
                for (int z = 0; z < sizeZ; ++z) {
                    for (int x = 0; x < sizeX; ++x) {
                        BlockEntity te;
                        posMutable.m_122178_(x + startX, y + startY, z + startZ);
                        if (visibleOnly && !LitematicaSchematic.isExposed(world, (BlockPos)posMutable) && (!includeSupport || !LitematicaSchematic.isSupport(world, (BlockPos)posMutable))) continue;
                        BlockState state = world.m_8055_((BlockPos)posMutable);
                        container.set(x, y, z, state);
                        if (!state.m_60795_()) {
                            ++this.totalBlocksReadFromWorld;
                        }
                        if (!state.m_155947_() || (te = world.m_7702_((BlockPos)posMutable)) == null) continue;
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundTag tag = te.m_187481_();
                        NBTUtils.writeBlockPosToTag((Vec3i)pos, (CompoundTag)tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (world instanceof ServerLevel) {
                ServerLevel serverWorld = (ServerLevel)world;
                IntBoundingBox tickBox = IntBoundingBox.createProper((int)startX, (int)startY, (int)startZ, (int)(startX + sizeX), (int)(startY + sizeY), (int)(startZ + sizeZ));
                long currentTick = world.m_46467_();
                this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.m_183326_()).litematica_getChunkTickSchedulers(), blockTickMap, tickBox, minCorner, currentTick);
                this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.m_183324_()).litematica_getChunkTickSchedulers(), fluidTickMap, tickBox, minCorner, currentTick);
            }
            this.blockContainers.put(box.getName(), container);
            this.tileEntities.put(box.getName(), tileEntityMap);
            this.pendingBlockTicks.put(box.getName(), blockTickMap);
            this.pendingFluidTicks.put(box.getName(), fluidTickMap);
        }
    }

    private <T> void getTicksFromScheduler(Long2ObjectMap<LevelChunkTicks<T>> chunkTickSchedulers, Map<BlockPos, ScheduledTick<T>> outputMap, IntBoundingBox box, BlockPos minCorner, long currentTick) {
        int minCX = SectionPos.m_123171_((int)box.minX);
        int minCZ = SectionPos.m_123171_((int)box.minZ);
        int maxCX = SectionPos.m_123171_((int)box.maxX);
        int maxCZ = SectionPos.m_123171_((int)box.maxZ);
        for (int cx = minCX; cx <= maxCX; ++cx) {
            for (int cz = minCZ; cz <= maxCZ; ++cz) {
                long cp = ChunkPos.m_45589_((int)cx, (int)cz);
                LevelChunkTicks chunkTickScheduler = (LevelChunkTicks)chunkTickSchedulers.get(cp);
                if (chunkTickScheduler == null) continue;
                chunkTickScheduler.m_193196_().filter(t -> box.containsPos((Vec3i)t.f_193377_())).forEach(t -> this.addRelativeTickToMap(outputMap, (ScheduledTick)t, minCorner, currentTick));
            }
        }
    }

    private <T> void addRelativeTickToMap(Map<BlockPos, ScheduledTick<T>> outputMap, ScheduledTick<T> tick, BlockPos minCorner, long currentTick) {
        BlockPos pos = tick.f_193377_();
        BlockPos relativePos = new BlockPos(pos.m_123341_() - minCorner.m_123341_(), pos.m_123342_() - minCorner.m_123342_(), pos.m_123343_() - minCorner.m_123343_());
        ScheduledTick newTick = new ScheduledTick(tick.f_193376_(), relativePos, tick.f_193378_() - currentTick, tick.f_193379_(), tick.f_193380_());
        outputMap.put(relativePos, newTick);
    }

    public static boolean isExposed(Level world, BlockPos pos) {
        for (Direction dir : PositionUtils.ALL_DIRECTIONS) {
            BlockPos posAdj = pos.m_121945_(dir);
            BlockState stateAdj = world.m_8055_(posAdj);
            if (stateAdj.m_60815_() && stateAdj.m_60783_((BlockGetter)world, posAdj, dir.m_122424_())) continue;
            return true;
        }
        return false;
    }

    public static boolean isGravityBlock(BlockState state) {
        return state.m_204336_(BlockTags.f_13029_) || state.m_60734_() instanceof FallingBlock || state.m_60734_() == Blocks.f_49994_;
    }

    public static boolean isGravityBlock(Level world, BlockPos pos) {
        return LitematicaSchematic.isGravityBlock(world.m_8055_(pos));
    }

    public static boolean supportsExposedBlocks(Level world, BlockPos pos) {
        BlockPos posUp = pos.m_121945_(Direction.UP);
        BlockState stateUp = world.m_8055_(posUp);
        while (true) {
            if (LitematicaSchematic.needsSupportNonGravity(stateUp)) {
                return true;
            }
            if (!LitematicaSchematic.isGravityBlock(stateUp)) break;
            if (LitematicaSchematic.isExposed(world, posUp)) {
                return true;
            }
            if ((posUp = posUp.m_121945_(Direction.UP)).m_123342_() >= world.m_151558_()) break;
            stateUp = world.m_8055_(posUp);
        }
        return false;
    }

    public static boolean needsSupportNonGravity(BlockState state) {
        Block block = state.m_60734_();
        return block == Blocks.f_50146_ || block == Blocks.f_50328_ || block == Blocks.f_50125_ || block instanceof CarpetBlock;
    }

    public static boolean isSupport(Level world, BlockPos pos) {
        BlockPos posUp = pos.m_121945_(Direction.UP);
        BlockState stateUp = world.m_8055_(posUp);
        if (LitematicaSchematic.needsSupportNonGravity(stateUp)) {
            return true;
        }
        return LitematicaSchematic.isGravityBlock(stateUp) && (LitematicaSchematic.isExposed(world, posUp) || LitematicaSchematic.supportsExposedBlocks(world, posUp));
    }

    public void takeBlocksFromWorldWithinChunk(Level world, ImmutableMap<String, IntBoundingBox> volumes, ImmutableMap<String, Box> boxes, SchematicSaveInfo info) {
        BlockPos.MutableBlockPos posMutable = new BlockPos.MutableBlockPos(0, 0, 0);
        for (Map.Entry volumeEntry : volumes.entrySet()) {
            String regionName = (String)volumeEntry.getKey();
            IntBoundingBox bb = (IntBoundingBox)volumeEntry.getValue();
            Box box = (Box)boxes.get((Object)regionName);
            if (box == null) {
                Litematica.logger.error("null Box for sub-region '{}' while trying to save chunk-wise schematic", (Object)regionName);
                continue;
            }
            LitematicaBlockStateContainer container = this.blockContainers.get(regionName);
            Map<BlockPos, CompoundTag> tileEntityMap = this.tileEntities.get(regionName);
            Map blockTickMap = this.pendingBlockTicks.get(regionName);
            Map fluidTickMap = this.pendingFluidTicks.get(regionName);
            if (container == null || tileEntityMap == null || blockTickMap == null || fluidTickMap == null) {
                Litematica.logger.error("null map(s) for sub-region '{}' while trying to save chunk-wise schematic", (Object)regionName);
                continue;
            }
            BlockPos minCorner = fi.dy.masa.litematica.util.PositionUtils.getMinCorner(box.getPos1(), box.getPos2());
            int offsetX = minCorner.m_123341_();
            int offsetY = minCorner.m_123342_();
            int offsetZ = minCorner.m_123343_();
            int startX = bb.minX - minCorner.m_123341_();
            int startY = bb.minY - minCorner.m_123342_();
            int startZ = bb.minZ - minCorner.m_123343_();
            int endX = startX + (bb.maxX - bb.minX);
            int endY = startY + (bb.maxY - bb.minY);
            int endZ = startZ + (bb.maxZ - bb.minZ);
            boolean visibleOnly = info.visibleOnly;
            boolean includeSupport = info.includeSupportBlocks;
            for (int y = startY; y <= endY; ++y) {
                for (int z = startZ; z <= endZ; ++z) {
                    for (int x = startX; x <= endX; ++x) {
                        BlockEntity te;
                        posMutable.m_122178_(x + offsetX, y + offsetY, z + offsetZ);
                        if (visibleOnly && !LitematicaSchematic.isExposed(world, (BlockPos)posMutable) && (!includeSupport || !LitematicaSchematic.isSupport(world, (BlockPos)posMutable))) continue;
                        BlockState state = world.m_8055_((BlockPos)posMutable);
                        container.set(x, y, z, state);
                        if (!state.m_60795_()) {
                            ++this.totalBlocksReadFromWorld;
                        }
                        if (!state.m_155947_() || (te = world.m_7702_((BlockPos)posMutable)) == null) continue;
                        BlockPos pos = new BlockPos(x, y, z);
                        CompoundTag tag = te.m_187481_();
                        NBTUtils.writeBlockPosToTag((Vec3i)pos, (CompoundTag)tag);
                        tileEntityMap.put(pos, tag);
                    }
                }
            }
            if (!(world instanceof ServerLevel)) continue;
            ServerLevel serverWorld = (ServerLevel)world;
            IntBoundingBox tickBox = IntBoundingBox.createProper((int)(offsetX + startX), (int)(offsetY + startY), (int)(offsetZ + startZ), (int)(offsetX + endX + 1), (int)(offsetY + endY + 1), (int)(offsetZ + endZ + 1));
            long currentTick = world.m_46467_();
            this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.m_183326_()).litematica_getChunkTickSchedulers(), blockTickMap, tickBox, minCorner, currentTick);
            this.getTicksFromScheduler(((IMixinWorldTickScheduler)serverWorld.m_183324_()).litematica_getChunkTickSchedulers(), fluidTickMap, tickBox, minCorner, currentTick);
        }
    }

    private void setSubRegionPositions(List<Box> boxes, BlockPos areaOrigin) {
        for (Box box : boxes) {
            this.subRegionPositions.put(box.getName(), box.getPos1().m_121996_((Vec3i)areaOrigin));
        }
    }

    private void setSubRegionSizes(List<Box> boxes) {
        for (Box box : boxes) {
            this.subRegionSizes.put(box.getName(), box.getSize());
        }
    }

    @Nullable
    public LitematicaBlockStateContainer getSubRegionContainer(String regionName) {
        return this.blockContainers.get(regionName);
    }

    @Nullable
    public Map<BlockPos, CompoundTag> getBlockEntityMapForRegion(String regionName) {
        return this.tileEntities.get(regionName);
    }

    @Nullable
    public List<EntityInfo> getEntityListForRegion(String regionName) {
        return this.entities.get(regionName);
    }

    @Nullable
    public Map<BlockPos, ScheduledTick<Block>> getScheduledBlockTicksForRegion(String regionName) {
        return this.pendingBlockTicks.get(regionName);
    }

    @Nullable
    public Map<BlockPos, ScheduledTick<Fluid>> getScheduledFluidTicksForRegion(String regionName) {
        return this.pendingFluidTicks.get(regionName);
    }

    private CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128405_("MinecraftDataVersion", MINECRAFT_DATA_VERSION);
        nbt.m_128405_("Version", 6);
        nbt.m_128405_("SubVersion", 1);
        nbt.m_128365_("Metadata", (Tag)this.metadata.writeToNBT());
        nbt.m_128365_("Regions", (Tag)this.writeSubRegionsToNBT());
        return nbt;
    }

    private CompoundTag writeSubRegionsToNBT() {
        CompoundTag wrapper = new CompoundTag();
        if (!this.blockContainers.isEmpty()) {
            for (String regionName : this.blockContainers.keySet()) {
                LitematicaBlockStateContainer blockContainer = this.blockContainers.get(regionName);
                Map<BlockPos, CompoundTag> tileMap = this.tileEntities.get(regionName);
                List<EntityInfo> entityList = this.entities.get(regionName);
                Map pendingBlockTicks = this.pendingBlockTicks.get(regionName);
                Map pendingFluidTicks = this.pendingFluidTicks.get(regionName);
                CompoundTag tag = new CompoundTag();
                tag.m_128365_("BlockStatePalette", (Tag)blockContainer.getPalette().writeToNBT());
                tag.m_128365_("BlockStates", (Tag)new LongArrayTag(blockContainer.getBackingLongArray()));
                tag.m_128365_("TileEntities", (Tag)this.writeTileEntitiesToNBT(tileMap));
                if (pendingBlockTicks != null) {
                    tag.m_128365_("PendingBlockTicks", (Tag)this.writePendingTicksToNBT(pendingBlockTicks, (Registry)BuiltInRegistries.f_256975_, "Block"));
                }
                if (pendingFluidTicks != null) {
                    tag.m_128365_("PendingFluidTicks", (Tag)this.writePendingTicksToNBT(pendingFluidTicks, (Registry)BuiltInRegistries.f_257020_, "Fluid"));
                }
                if (entityList != null) {
                    tag.m_128365_("Entities", (Tag)this.writeEntitiesToNBT(entityList));
                }
                BlockPos pos = this.subRegionPositions.get(regionName);
                tag.m_128365_("Position", (Tag)NBTUtils.createBlockPosTag((Vec3i)pos));
                pos = this.subRegionSizes.get(regionName);
                tag.m_128365_("Size", (Tag)NBTUtils.createBlockPosTag((Vec3i)pos));
                wrapper.m_128365_(regionName, (Tag)tag);
            }
        }
        return wrapper;
    }

    private ListTag writeEntitiesToNBT(List<EntityInfo> entityList) {
        ListTag tagList = new ListTag();
        if (!entityList.isEmpty()) {
            for (EntityInfo info : entityList) {
                tagList.add((Object)info.nbt);
            }
        }
        return tagList;
    }

    private <T> ListTag writePendingTicksToNBT(Map<BlockPos, ScheduledTick<T>> tickMap, Registry<T> registry, String tagName) {
        ListTag tagList = new ListTag();
        if (!tickMap.isEmpty()) {
            for (ScheduledTick<T> entry : tickMap.values()) {
                Object target = entry.f_193376_();
                ResourceLocation id = registry.m_7981_(target);
                if (id == null) continue;
                CompoundTag tag = new CompoundTag();
                tag.m_128359_(tagName, id.toString());
                tag.m_128405_("Priority", entry.f_193379_().m_193445_());
                tag.m_128356_("SubTick", entry.f_193380_());
                tag.m_128405_("Time", (int)entry.f_193378_());
                tag.m_128405_("x", entry.f_193377_().m_123341_());
                tag.m_128405_("y", entry.f_193377_().m_123342_());
                tag.m_128405_("z", entry.f_193377_().m_123343_());
                tagList.add((Object)tag);
            }
        }
        return tagList;
    }

    private ListTag writeTileEntitiesToNBT(Map<BlockPos, CompoundTag> tileMap) {
        ListTag tagList = new ListTag();
        if (!tileMap.isEmpty()) {
            tagList.addAll(tileMap.values());
        }
        return tagList;
    }

    private boolean readFromNBT(CompoundTag nbt) {
        this.blockContainers.clear();
        this.tileEntities.clear();
        this.entities.clear();
        this.pendingBlockTicks.clear();
        this.subRegionPositions.clear();
        this.subRegionSizes.clear();
        if (nbt.m_128425_("Version", 3)) {
            int version = nbt.m_128451_("Version");
            int minecraftDataVersion = nbt.m_128451_("MinecraftDataVersion");
            if (version >= 1 && version <= 6) {
                this.metadata.readFromNBT(nbt.m_128469_("Metadata"));
                this.readSubRegionsFromNBT(nbt.m_128469_("Regions"), version, minecraftDataVersion);
                return true;
            }
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_load.unsupported_schematic_version", (Object[])new Object[]{version});
        } else {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_load.no_schematic_version_information", (Object[])new Object[0]);
        }
        return false;
    }

    private void readSubRegionsFromNBT(CompoundTag tag, int version, int minecraftDataVersion) {
        for (String regionName : tag.m_128431_()) {
            Tag nbtBase;
            ListTag list;
            if (tag.m_128423_(regionName).m_7060_() != 10) continue;
            CompoundTag regionTag = tag.m_128469_(regionName);
            BlockPos regionPos = NBTUtils.readBlockPos((CompoundTag)regionTag.m_128469_("Position"));
            BlockPos regionSize = NBTUtils.readBlockPos((CompoundTag)regionTag.m_128469_("Size"));
            Map<BlockPos, CompoundTag> tiles = null;
            if (regionPos == null || regionSize == null) continue;
            this.subRegionPositions.put(regionName, regionPos);
            this.subRegionSizes.put(regionName, regionSize);
            if (version >= 2) {
                tiles = this.readTileEntitiesFromNBT(regionTag.m_128437_("TileEntities", 10));
                this.tileEntities.put(regionName, tiles);
                this.entities.put(regionName, this.readEntitiesFromNBT(regionTag.m_128437_("Entities", 10)));
            } else if (version == 1) {
                tiles = this.readTileEntitiesFromNBT_v1(regionTag.m_128437_("TileEntities", 10));
                this.tileEntities.put(regionName, tiles);
                this.entities.put(regionName, this.readEntitiesFromNBT_v1(regionTag.m_128437_("Entities", 10)));
            }
            if (version >= 3) {
                list = regionTag.m_128437_("PendingBlockTicks", 10);
                this.pendingBlockTicks.put(regionName, this.readPendingTicksFromNBT(list, (Registry)BuiltInRegistries.f_256975_, "Block", (Object)Blocks.f_50016_));
            }
            if (version >= 5) {
                list = regionTag.m_128437_("PendingFluidTicks", 10);
                this.pendingFluidTicks.put(regionName, this.readPendingTicksFromNBT(list, (Registry)BuiltInRegistries.f_257020_, "Fluid", (Object)Fluids.f_76191_));
            }
            if ((nbtBase = regionTag.m_128423_("BlockStates")) == null || nbtBase.m_7060_() != 12) continue;
            ListTag palette = regionTag.m_128437_("BlockStatePalette", 10);
            long[] blockStateArr = ((LongArrayTag)nbtBase).m_128851_();
            BlockPos posEndRel = fi.dy.masa.litematica.util.PositionUtils.getRelativeEndPositionFromAreaSize((Vec3i)regionSize).m_121955_((Vec3i)regionPos);
            BlockPos posMin = fi.dy.masa.litematica.util.PositionUtils.getMinCorner(regionPos, posEndRel);
            BlockPos posMax = fi.dy.masa.litematica.util.PositionUtils.getMaxCorner(regionPos, posEndRel);
            BlockPos size = posMax.m_121996_((Vec3i)posMin).m_7918_(1, 1, 1);
            palette = this.convertBlockStatePalette_1_12_to_1_13_2(palette, version, minecraftDataVersion);
            LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createFrom(palette, blockStateArr, size);
            if (minecraftDataVersion < MINECRAFT_DATA_VERSION) {
                this.postProcessContainerIfNeeded(palette, container, tiles);
            }
            this.blockContainers.put(regionName, container);
        }
    }

    public static boolean isSizeValid(@Nullable Vec3i size) {
        return size != null && size.m_123341_() > 0 && size.m_123342_() > 0 && size.m_123343_() > 0;
    }

    @Nullable
    private static Vec3i readSizeFromTagImpl(CompoundTag tag) {
        ListTag tagList;
        if (tag.m_128425_("size", 9) && (tagList = tag.m_128437_("size", 3)).size() == 3) {
            return new Vec3i(tagList.m_128763_(0), tagList.m_128763_(1), tagList.m_128763_(2));
        }
        return null;
    }

    @Nullable
    public static BlockPos readBlockPosFromNbtList(CompoundTag tag, String tagName) {
        ListTag tagList;
        if (tag.m_128425_(tagName, 9) && (tagList = tag.m_128437_(tagName, 3)).size() == 3) {
            return new BlockPos(tagList.m_128763_(0), tagList.m_128763_(1), tagList.m_128763_(2));
        }
        return null;
    }

    protected boolean readPaletteFromLitematicaFormatTag(ListTag tagList, ILitematicaBlockStatePalette palette) {
        int size = tagList.size();
        ArrayList<BlockState> list = new ArrayList<BlockState>(size);
        HolderLookup.RegistryLookup lookup = BuiltInRegistries.f_256975_.m_255303_();
        for (int id = 0; id < size; ++id) {
            CompoundTag tag = tagList.m_128728_(id);
            BlockState state = net.minecraft.nbt.NbtUtils.m_247651_((HolderGetter)lookup, (CompoundTag)tag);
            list.add(state);
        }
        return palette.setMapping(list);
    }

    public static boolean isValidSpongeSchematic(CompoundTag tag) {
        if (tag.m_128425_("Width", 99) && tag.m_128425_("Height", 99) && tag.m_128425_("Length", 99) && tag.m_128425_("Version", 3) && tag.m_128425_("Palette", 10) && tag.m_128425_("BlockData", 7)) {
            return LitematicaSchematic.isSizeValid(LitematicaSchematic.readSizeFromTagSponge(tag));
        }
        return false;
    }

    public static boolean isValidSpongeSchematicv3(CompoundTag tag) {
        CompoundTag nbtV3;
        if (tag.m_128425_("Schematic", 10) && (nbtV3 = tag.m_128469_("Schematic")).m_128425_("Width", 99) && nbtV3.m_128425_("Height", 99) && nbtV3.m_128425_("Length", 99) && nbtV3.m_128425_("Version", 3) && nbtV3.m_128451_("Version") >= 3 && nbtV3.m_128441_("Blocks") && nbtV3.m_128441_("DataVersion")) {
            return LitematicaSchematic.isSizeValid(LitematicaSchematic.readSizeFromTagSponge(nbtV3));
        }
        return false;
    }

    public static Vec3i readSizeFromTagSponge(CompoundTag tag) {
        return new Vec3i(tag.m_128451_("Width"), tag.m_128451_("Height"), tag.m_128451_("Length"));
    }

    protected boolean readSpongePaletteFromTag(CompoundTag tag, ILitematicaBlockStatePalette palette) {
        int size = tag.m_128431_().size();
        ArrayList<BlockState> list = new ArrayList<BlockState>(size);
        BlockState air = Blocks.f_50016_.m_49966_();
        for (int i = 0; i < size; ++i) {
            list.add(air);
        }
        for (String key : tag.m_128431_()) {
            BlockState state;
            int id = tag.m_128451_(key);
            Optional<BlockState> stateOptional = BlockUtils.getBlockStateFromString(key);
            if (stateOptional.isPresent()) {
                state = stateOptional.get();
            } else {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.WARNING, (String)("Unknown block in the Sponge schematic palette: '" + key + "'"), (Object[])new Object[0]);
                state = LitematicaBlockStateContainer.AIR_BLOCK_STATE;
            }
            if (id < 0 || id >= size) {
                String msg = "Invalid ID in the Sponge schematic palette: '" + id + "'";
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)msg, (Object[])new Object[0]);
                Litematica.logger.error(msg);
                return false;
            }
            list.set(id, state);
        }
        return palette.setMapping(list);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected boolean readSpongeBlocksFromTag(CompoundTag tag, String schematicName, Vec3i size, int minecraftDataVersion, int spongeVersion) {
        int paletteSize;
        byte[] blockData;
        CompoundTag paletteTag;
        CompoundTag blocksTag;
        block7: {
            blocksTag = new CompoundTag();
            if (spongeVersion >= 3 && tag.m_128441_("Blocks")) {
                blocksTag = tag.m_128469_("Blocks");
                if (blocksTag.m_128425_("Palette", 10) && blocksTag.m_128425_("Data", 7) && blocksTag.m_128425_("BlockEntities", 9)) {
                    paletteTag = blocksTag.m_128469_("Palette");
                    blockData = blocksTag.m_128463_("Data");
                    paletteSize = paletteTag.m_128431_().size();
                    break block7;
                } else {
                    String msg = "Failed to read blocks from Sponge schematic";
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)msg, (Object[])new Object[0]);
                    Litematica.logger.error(msg);
                    return false;
                }
            }
            if (tag.m_128425_("Palette", 10) && tag.m_128425_("BlockData", 7)) {
                paletteTag = tag.m_128469_("Palette");
                blockData = tag.m_128463_("BlockData");
                paletteSize = paletteTag.m_128431_().size();
            } else {
                String msg = "Failed to read blocks from Sponge schematic";
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)msg, (Object[])new Object[0]);
                Litematica.logger.error(msg);
                return false;
            }
        }
        LitematicaBlockStateContainer container = LitematicaBlockStateContainer.createContainer(paletteSize, blockData, size);
        if (container == null) {
            String msg = "Failed to read blocks from Sponge schematic";
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)msg, (Object[])new Object[0]);
            Litematica.logger.error(msg);
            return false;
        }
        this.blockContainers.put(schematicName, container);
        if (!this.readSpongePaletteFromTag(paletteTag, container.getPalette())) {
            return false;
        }
        if (spongeVersion < 3) return true;
        if (blocksTag.m_128456_()) return false;
        this.tileEntities.put(schematicName, this.readSpongeBlockEntitiesFromTag(blocksTag, spongeVersion));
        return true;
    }

    protected Map<BlockPos, CompoundTag> readSpongeBlockEntitiesFromTag(CompoundTag tag, int spongeVersion) {
        HashMap<BlockPos, CompoundTag> blockEntities = new HashMap<BlockPos, CompoundTag>();
        String tagName = spongeVersion == 1 ? "TileEntities" : "BlockEntities";
        ListTag tagList = tag.m_128437_(tagName, 10);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag beTag = tagList.m_128728_(i);
            BlockPos pos = NbtUtils.readBlockPosFromArrayTag(beTag, "Pos");
            if (pos == null || beTag.m_128456_()) continue;
            beTag.m_128359_("id", beTag.m_128461_("Id"));
            beTag.m_128473_("Id");
            beTag.m_128473_("Pos");
            if (spongeVersion == 1) {
                beTag.m_128473_("ContentVersion");
            }
            if (spongeVersion >= 3) {
                CompoundTag beData = beTag.m_128469_("Data");
                blockEntities.put(pos, beData);
                continue;
            }
            blockEntities.put(pos, beTag);
        }
        return blockEntities;
    }

    protected List<EntityInfo> readSpongeEntitiesFromTag(CompoundTag tag, Vec3i offset, int spongeVersion) {
        ArrayList<EntityInfo> entities = new ArrayList<EntityInfo>();
        ListTag tagList = tag.m_128437_("Entities", 10);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag entityEntry = tagList.m_128728_(i);
            Vec3 pos = NbtUtils.readVec3dFromListTag(entityEntry);
            if (pos == null || entityEntry.m_128456_()) continue;
            entityEntry.m_128359_("id", entityEntry.m_128461_("Id"));
            entityEntry.m_128473_("Id");
            if (spongeVersion >= 3) {
                CompoundTag entityData = entityEntry.m_128469_("Data");
                if (!entityData.m_128425_("id", 8)) {
                    entityData.m_128359_("id", entityEntry.m_128461_("id"));
                }
                entities.add(new EntityInfo(pos, entityData));
                continue;
            }
            pos = new Vec3(pos.f_82479_ - (double)offset.m_123341_(), pos.f_82480_ - (double)offset.m_123342_(), pos.f_82481_ - (double)offset.m_123343_());
            entities.add(new EntityInfo(pos, entityEntry));
        }
        return entities;
    }

    public boolean readFromSpongeSchematic(String name, CompoundTag tag) {
        if (LitematicaSchematic.isValidSpongeSchematicv3(tag)) {
            CompoundTag spongeTag = tag.m_128469_("Schematic");
            tag.m_128473_("Schematic");
            tag.m_128391_(spongeTag);
        } else if (!LitematicaSchematic.isValidSpongeSchematic(tag)) {
            return false;
        }
        int spongeVersion = tag.m_128441_("Version") ? tag.m_128451_("Version") : -1;
        int minecraftDataVersion = tag.m_128441_("DataVersion") ? tag.m_128451_("DataVersion") : 1139;
        Vec3i size = LitematicaSchematic.readSizeFromTagSponge(tag);
        if (!this.readSpongeBlocksFromTag(tag, name, size, minecraftDataVersion, spongeVersion)) {
            return false;
        }
        Vec3i offset = NbtUtils.readVec3iFromIntArray(tag, "Offset");
        if (offset == null) {
            offset = Vec3i.f_123288_;
        }
        if (spongeVersion < 3) {
            this.tileEntities.put(name, this.readSpongeBlockEntitiesFromTag(tag, spongeVersion));
        }
        this.entities.put(name, this.readSpongeEntitiesFromTag(tag, offset, spongeVersion));
        if (tag.m_128425_("Metadata", 10)) {
            CompoundTag metadata = tag.m_128469_("Metadata");
            this.metadata.setName(metadata.m_128425_("Name", 8) ? metadata.m_128461_("Name") : name);
            this.metadata.setAuthor(metadata.m_128425_("Author", 8) ? metadata.m_128461_("Author") : "unknown");
            this.metadata.setTimeCreated(metadata.m_128425_("Date", 4) ? metadata.m_128454_("Date") : System.currentTimeMillis());
        } else {
            this.metadata.setAuthor("unknown");
            this.metadata.setName(name);
            this.metadata.setTimeCreated(System.currentTimeMillis());
        }
        if (tag.m_128425_("author", 8)) {
            this.metadata.setAuthor(tag.m_128461_("author"));
        }
        this.subRegionPositions.put(name, BlockPos.f_121853_);
        this.subRegionSizes.put(name, new BlockPos(size));
        this.metadata.setRegionCount(1);
        this.metadata.setTotalVolume(size.m_123341_() * size.m_123342_() * size.m_123343_());
        this.metadata.setEnclosingSize(size);
        this.metadata.setTimeModified(this.metadata.getTimeCreated());
        this.metadata.setTotalBlocks(this.totalBlocksReadFromWorld);
        return true;
    }

    public boolean readFromVanillaStructure(String name, CompoundTag tag) {
        Vec3i size = LitematicaSchematic.readSizeFromTagImpl(tag);
        if (tag.m_128425_("palette", 9) && tag.m_128425_("blocks", 9) && LitematicaSchematic.isSizeValid(size)) {
            ListTag paletteTag = tag.m_128437_("palette", 10);
            HashMap<BlockPos, CompoundTag> tileMap = new HashMap<BlockPos, CompoundTag>();
            this.tileEntities.put(name, tileMap);
            BlockState air = Blocks.f_50016_.m_49966_();
            int paletteSize = paletteTag.size();
            ArrayList<BlockState> list = new ArrayList<BlockState>(paletteSize);
            HolderLookup.RegistryLookup lookup = BuiltInRegistries.f_256975_.m_255303_();
            for (int id = 0; id < paletteSize; ++id) {
                CompoundTag t = paletteTag.m_128728_(id);
                BlockState state = net.minecraft.nbt.NbtUtils.m_247651_((HolderGetter)lookup, (CompoundTag)t);
                list.add(state);
            }
            BlockState zeroState = (BlockState)list.get(0);
            int airId = -1;
            for (int i = 0; i < paletteSize; ++i) {
                if (list.get(i) != air) continue;
                airId = i;
                break;
            }
            if (airId != 0) {
                if (airId == -1) {
                    list.add(0, air);
                    ++paletteSize;
                } else {
                    list.set(0, air);
                    list.set(airId, zeroState);
                }
            }
            int bits = Math.max(2, 32 - Integer.numberOfLeadingZeros(paletteSize - 1));
            LitematicaBlockStateContainer container = new LitematicaBlockStateContainer(size.m_123341_(), size.m_123342_(), size.m_123343_(), bits, null);
            ILitematicaBlockStatePalette palette = container.getPalette();
            palette.setMapping(list);
            this.blockContainers.put(name, container);
            if (tag.m_128425_("author", 8)) {
                this.getMetadata().setAuthor(tag.m_128461_("author"));
            }
            this.subRegionPositions.put(name, BlockPos.f_121853_);
            this.subRegionSizes.put(name, new BlockPos(size));
            this.metadata.setName(name);
            this.metadata.setRegionCount(1);
            this.metadata.setTotalVolume(size.m_123341_() * size.m_123342_() * size.m_123343_());
            this.metadata.setEnclosingSize(size);
            this.metadata.setTimeCreated(System.currentTimeMillis());
            this.metadata.setTimeModified(this.metadata.getTimeCreated());
            ListTag blockList = tag.m_128437_("blocks", 10);
            int count = blockList.size();
            int totalBlocks = 0;
            for (int i = 0; i < count; ++i) {
                CompoundTag blockTag = blockList.m_128728_(i);
                BlockPos pos = LitematicaSchematic.readBlockPosFromNbtList(blockTag, "pos");
                if (pos == null) {
                    InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"Failed to read block position for vanilla structure", (Object[])new Object[0]);
                    return false;
                }
                int id = blockTag.m_128451_("state");
                BlockState state = airId == -1 ? palette.getBlockState(id + 1) : (airId != 0 ? (id == 0 ? zeroState : (id == airId ? air : palette.getBlockState(id))) : palette.getBlockState(id));
                if (state == null) {
                    state = air;
                } else if (state != air) {
                    ++totalBlocks;
                }
                container.set(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), state);
                if (!blockTag.m_128425_("nbt", 10)) continue;
                tileMap.put(pos, blockTag.m_128469_("nbt"));
            }
            this.metadata.setTotalBlocks(totalBlocks);
            this.entities.put(name, this.readEntitiesFromVanillaStructure(tag));
            return true;
        }
        return false;
    }

    protected List<EntityInfo> readEntitiesFromVanillaStructure(CompoundTag tag) {
        ArrayList<EntityInfo> entities = new ArrayList<EntityInfo>();
        ListTag tagList = tag.m_128437_("entities", 10);
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag entityData = tagList.m_128728_(i);
            Vec3 pos = LitematicaSchematic.readVec3dFromNbtList(entityData, "pos");
            if (pos == null || !entityData.m_128425_("nbt", 10)) continue;
            entities.add(new EntityInfo(pos, entityData.m_128469_("nbt")));
        }
        return entities;
    }

    @Nullable
    public static Vec3 readVec3dFromNbtList(@Nullable CompoundTag tag, String tagName) {
        ListTag tagList;
        if (tag != null && tag.m_128425_(tagName, 9) && (tagList = tag.m_128437_(tagName, 6)).m_7264_() == 6 && tagList.size() == 3) {
            return new Vec3(tagList.m_128772_(0), tagList.m_128772_(1), tagList.m_128772_(2));
        }
        return null;
    }

    private void postProcessContainerIfNeeded(ListTag palette, LitematicaBlockStateContainer container, @Nullable Map<BlockPos, CompoundTag> tiles) {
        List<BlockState> states = LitematicaSchematic.getStatesFromPaletteTag(palette);
        if (this.converter.createPostProcessStateFilter(states)) {
            IdentityHashMap<BlockState, SchematicConversionFixers.IStateFixer> postProcessingFilter = this.converter.getPostProcessStateFilter();
            SchematicConverter.postProcessBlocks(container, tiles, postProcessingFilter);
        }
    }

    public static List<BlockState> getStatesFromPaletteTag(ListTag palette) {
        ArrayList<BlockState> states = new ArrayList<BlockState>();
        HolderLookup.RegistryLookup lookup = BuiltInRegistries.f_256975_.m_255303_();
        int size = palette.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = palette.m_128728_(i);
            BlockState state = net.minecraft.nbt.NbtUtils.m_247651_((HolderGetter)lookup, (CompoundTag)tag);
            if (i <= 0 && state == LitematicaBlockStateContainer.AIR_BLOCK_STATE) continue;
            states.add(state);
        }
        return states;
    }

    private ListTag convertBlockStatePalette_1_12_to_1_13_2(ListTag oldPalette, int version, int minecraftDataVersion) {
        if (version < 5 || minecraftDataVersion < 1631 && minecraftDataVersion > 0) {
            ListTag newPalette = new ListTag();
            int count = oldPalette.size();
            for (int i = 0; i < count; ++i) {
                newPalette.add((Object)SchematicConversionMaps.get_1_13_2_StateTagFor_1_12_Tag(oldPalette.m_128728_(i)));
            }
            return newPalette;
        }
        return oldPalette;
    }

    private List<EntityInfo> readEntitiesFromNBT(ListTag tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag entityData = tagList.m_128728_(i);
            Vec3 posVec = NBTUtils.readEntityPositionFromTag((CompoundTag)entityData);
            if (posVec == null || entityData.m_128456_()) continue;
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, CompoundTag> readTileEntitiesFromNBT(ListTag tagList) {
        HashMap<BlockPos, CompoundTag> tileMap = new HashMap<BlockPos, CompoundTag>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.m_128728_(i);
            BlockPos pos = NBTUtils.readBlockPos((CompoundTag)tag);
            if (pos == null || tag.m_128456_()) continue;
            tileMap.put(pos, tag);
        }
        return tileMap;
    }

    private <T> Map<BlockPos, ScheduledTick<T>> readPendingTicksFromNBT(ListTag tagList, Registry<T> registry, String tagName, T emptyValue) {
        HashMap<BlockPos, ScheduledTick<T>> tickMap = new HashMap<BlockPos, ScheduledTick<T>>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.m_128728_(i);
            if (!tag.m_128425_("Time", 99)) continue;
            Object target = null;
            try {
                target = registry.m_7745_(new ResourceLocation(tag.m_128461_(tagName)));
                if (target == null || target == emptyValue) {
                    continue;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (target == null) continue;
            BlockPos pos = new BlockPos(tag.m_128451_("x"), tag.m_128451_("y"), tag.m_128451_("z"));
            TickPriority priority = TickPriority.m_193446_((int)tag.m_128451_("Priority"));
            int scheduledTime = tag.m_128451_("Time");
            long subTick = tag.m_128454_("SubTick");
            tickMap.put(pos, new ScheduledTick(target, pos, (long)scheduledTime, priority, subTick));
        }
        return tickMap;
    }

    private List<EntityInfo> readEntitiesFromNBT_v1(ListTag tagList) {
        ArrayList<EntityInfo> entityList = new ArrayList<EntityInfo>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.m_128728_(i);
            Vec3 posVec = NBTUtils.readVec3d((CompoundTag)tag);
            CompoundTag entityData = tag.m_128469_("EntityData");
            if (posVec == null || entityData.m_128456_()) continue;
            NBTUtils.writeEntityPositionToTag((Vec3)posVec, (CompoundTag)entityData);
            entityList.add(new EntityInfo(posVec, entityData));
        }
        return entityList;
    }

    private Map<BlockPos, CompoundTag> readTileEntitiesFromNBT_v1(ListTag tagList) {
        HashMap<BlockPos, CompoundTag> tileMap = new HashMap<BlockPos, CompoundTag>();
        int size = tagList.size();
        for (int i = 0; i < size; ++i) {
            CompoundTag tag = tagList.m_128728_(i);
            CompoundTag tileNbt = tag.m_128469_("TileNBT");
            BlockPos pos = NBTUtils.readBlockPos((CompoundTag)tag);
            if (pos == null || tileNbt.m_128456_()) continue;
            NBTUtils.writeBlockPosToTag((Vec3i)pos, (CompoundTag)tileNbt);
            tileMap.put(pos, tileNbt);
        }
        return tileMap;
    }

    public boolean writeToFile(File dir, String fileNameIn, boolean override) {
        Object fileName = fileNameIn;
        if (!((String)fileName).endsWith(FILE_EXTENSION)) {
            fileName = (String)fileName + FILE_EXTENSION;
        }
        File fileSchematic = new File(dir, (String)fileName);
        try {
            if (!dir.exists() && !dir.mkdirs()) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.directory_creation_failed", (Object[])new Object[]{dir.getAbsolutePath()});
                return false;
            }
            if (!override && fileSchematic.exists()) {
                InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.exists", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
                return false;
            }
            FileOutputStream os = new FileOutputStream(fileSchematic);
            NbtIo.m_128947_((CompoundTag)this.writeToNBT(), (OutputStream)os);
            os.close();
            return true;
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_write_to_file_failed.exception", (Object[])new Object[]{fileSchematic.getAbsolutePath()});
            Litematica.logger.error(StringUtils.translate((String)"litematica.error.schematic_write_to_file_failed.exception", (Object[])new Object[]{fileSchematic.getAbsolutePath()}), (Throwable)e);
            Litematica.logger.error(e.getMessage());
            return false;
        }
    }

    public boolean readFromFile() {
        return this.readFromFile(this.schematicType);
    }

    private boolean readFromFile(FileType schematicType) {
        try {
            CompoundTag nbt = LitematicaSchematic.readNbtFromFile(this.schematicFile);
            if (nbt != null) {
                if (schematicType == FileType.SPONGE_SCHEMATIC) {
                    String name = FileUtils.getNameWithoutExtension((String)this.schematicFile.getName()) + " (Converted Structure)";
                    return this.readFromSpongeSchematic(name, nbt);
                }
                if (schematicType == FileType.VANILLA_STRUCTURE) {
                    String name = FileUtils.getNameWithoutExtension((String)this.schematicFile.getName()) + " (Converted Structure)";
                    return this.readFromVanillaStructure(name, nbt);
                }
                if (schematicType == FileType.LITEMATICA_SCHEMATIC) {
                    return this.readFromNBT(nbt);
                }
            }
        }
        catch (Exception e) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.exception", (Object[])new Object[]{this.schematicFile.getAbsolutePath()});
            Litematica.logger.error((Object)e);
        }
        return false;
    }

    public static CompoundTag readNbtFromFile(File file) {
        if (file == null) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.no_file", (Object[])new Object[0]);
            return null;
        }
        if (!file.exists() || !file.canRead()) {
            InfoUtils.showGuiOrInGameMessage((Message.MessageType)Message.MessageType.ERROR, (String)"litematica.error.schematic_read_from_file_failed.cant_read", (Object[])new Object[]{file.getAbsolutePath()});
            return null;
        }
        return NbtUtils.readNbtFromFile(file);
    }

    public static File fileFromDirAndName(File dir, String fileName, FileType schematicType) {
        if (!((String)fileName).endsWith(FILE_EXTENSION) && schematicType == FileType.LITEMATICA_SCHEMATIC) {
            fileName = (String)fileName + FILE_EXTENSION;
        }
        return new File(dir, (String)fileName);
    }

    @Nullable
    public static SchematicMetadata readMetadataFromFile(File dir, String fileName) {
        CompoundTag nbt = LitematicaSchematic.readNbtFromFile(LitematicaSchematic.fileFromDirAndName(dir, fileName, FileType.LITEMATICA_SCHEMATIC));
        if (nbt != null) {
            int version;
            SchematicMetadata metadata = new SchematicMetadata();
            if (nbt.m_128425_("Version", 3) && (version = nbt.m_128451_("Version")) >= 1 && version <= 6) {
                metadata.readFromNBT(nbt.m_128469_("Metadata"));
                return metadata;
            }
        }
        return null;
    }

    @Nullable
    public static LitematicaSchematic createFromFile(File dir, String fileName) {
        return LitematicaSchematic.createFromFile(dir, fileName, FileType.LITEMATICA_SCHEMATIC);
    }

    @Nullable
    public static LitematicaSchematic createFromFile(File dir, String fileName, FileType schematicType) {
        File file = LitematicaSchematic.fileFromDirAndName(dir, fileName, schematicType);
        LitematicaSchematic schematic = new LitematicaSchematic(file, schematicType);
        return schematic.readFromFile(schematicType) ? schematic : null;
    }

    public static class SchematicSaveInfo {
        public final boolean visibleOnly;
        public final boolean includeSupportBlocks;
        public final boolean ignoreEntities;
        public final boolean fromSchematicWorld;

        public SchematicSaveInfo(boolean visibleOnly, boolean ignoreEntities) {
            this(visibleOnly, false, ignoreEntities, false);
        }

        public SchematicSaveInfo(boolean visibleOnly, boolean includeSupportBlocks, boolean ignoreEntities, boolean fromSchematicWorld) {
            this.visibleOnly = visibleOnly;
            this.includeSupportBlocks = includeSupportBlocks;
            this.ignoreEntities = ignoreEntities;
            this.fromSchematicWorld = fromSchematicWorld;
        }
    }

    public static class EntityInfo {
        public final Vec3 posVec;
        public final CompoundTag nbt;

        public EntityInfo(Vec3 posVec, CompoundTag nbt) {
            this.posVec = posVec;
            if (nbt.m_128425_("SleepingX", 3)) {
                nbt.m_128405_("SleepingX", Mth.m_14107_((double)posVec.f_82479_));
            }
            if (nbt.m_128425_("SleepingY", 3)) {
                nbt.m_128405_("SleepingY", Mth.m_14107_((double)posVec.f_82480_));
            }
            if (nbt.m_128425_("SleepingZ", 3)) {
                nbt.m_128405_("SleepingZ", Mth.m_14107_((double)posVec.f_82481_));
            }
            this.nbt = nbt;
        }
    }
}

